/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.CenteredDialog;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.NavigatorFrame;
import oracle.ldap.admin.client.common.AdminButton;
import oracle.ldap.admin.client.common.AdminMenuItem;
import oracle.ldap.admin.client.common.AdminPopupMenu;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.client.propEditors.GridViewList;
import oracle.ldap.admin.client.propEditors.GridViewListOfValuePicker;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.IAdminProp;

class GridViewListLOVButton
extends AdminButton
implements GridViewItem,
ActionListener,
AdminPropertyChangeListener {
    GridView m_parent;
    IAdminProp m_ap;
    int m_propId;
    Object[] m_lov;
    String[] m_lovStrings;
    Object[] m_keys;
    GridViewList m_gvl;
    GridViewItem m_gvi;
    IAdminProp m_lovEditor;
    Dialog m_dialog;
    GridViewListOfValuePicker m_picker;
    AdminPopupMenu m_popupMenu;

    public GridViewListLOVButton(GridView gridView, IAdminProp iAdminProp, int n, String string, Object object) {
        super(string);
        this.m_propId = n;
        this.m_parent = gridView;
        this.m_gvl = null;
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            this.m_keys = new Object[hashtable.size()];
            this.m_lov = new Object[hashtable.size()];
            int n2 = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int n3 = this.m_keys.length - 1 - n2;
                this.m_keys[n3] = enumeration.nextElement();
                this.m_lov[n3] = hashtable.get(this.m_keys[n3]);
                ++n2;
            }
        } else if (object instanceof IAdminProp) {
            this.m_lovEditor = (IAdminProp)object;
            this.m_lovEditor.addAdminPropertyChangeListener(this);
        } else {
            this.m_lov = (Object[])object;
        }
        this.m_ap = iAdminProp;
        this.addActionListener(this);
    }

    void setGVI(Component component) {
        if (component instanceof GridViewList) {
            try {
                this.m_gvl = (GridViewList)((Object)component);
                return;
            }
            catch (ClassCastException classCastException) {
                AdminProp.sUnexpectedException(classCastException);
                return;
            }
        }
        try {
            this.m_gvi = (GridViewItem)((Object)component);
            return;
        }
        catch (ClassCastException classCastException) {
            AdminProp.sUnexpectedException(classCastException);
            return;
        }
    }

    public Dialog getPickerDialog() {
        CenteredDialog centeredDialog;
        if (this.m_dialog != null) {
            this.m_picker.reset(this.m_lov);
            return this.m_dialog;
        }
        try {
            centeredDialog = new CenteredDialog(AdminUtil.getFrame((Component)((Object)this.m_parent)), String.valueOf(ClientLang.getStrLovFor()) + this.m_ap.getPropName(this.m_propId), true);
        }
        catch (ClassCastException classCastException) {
            AdminProp.sUnexpectedException(classCastException);
            centeredDialog = new CenteredDialog(AdminUtil.getFrame((Component)((Object)this.m_parent)), String.valueOf(ClientLang.getStrLovFor()) + this.m_ap.getPropName(this.m_propId), true);
        }
        centeredDialog.setLayout(new BorderLayout());
        ((Component)((Object)centeredDialog)).setSize(300, 400);
        this.m_picker = new GridViewListOfValuePicker(this.m_lov, this);
        ((Container)((Object)centeredDialog)).add("Center", (Component)((Object)this.m_picker));
        this.m_dialog = centeredDialog;
        return this.m_dialog;
    }

    public AdminPopupMenu getPopupMenu() {
        if (this.m_popupMenu != null) {
            return this.m_popupMenu;
        }
        if (GridView.DEBUG) {
            System.out.println("menu lov for " + this.getLabel());
        }
        this.m_popupMenu = new AdminPopupMenu(ClientLang.getStrLov());
        this.m_lovStrings = new String[this.m_lov.length];
        int n = 0;
        while (n < this.m_lov.length) {
            if (GridView.DEBUG) {
                System.out.println("\tlov[" + n + "] =" + this.m_lov[n].toString());
            }
            this.m_lovStrings[n] = this.m_lov[n].toString();
            AdminMenuItem adminMenuItem = new AdminMenuItem(this.m_lovStrings[n]);
            adminMenuItem.addActionListener(this);
            ((Container)((Object)this.m_popupMenu)).add((Component)((Object)adminMenuItem));
            ++n;
        }
        ((Component)((Object)this)).getParent().add((Component)((Object)this.m_popupMenu));
        return this.m_popupMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Component component = null;
        if (actionEvent.getSource() instanceof Component) {
            component = (Component)actionEvent.getSource();
        }
        if (component != null && string == null && component instanceof AdminButton) {
            string = ((AdminButton)((Object)component)).getLabel();
        }
        if (string == null && this.m_lovEditor != null || string.equals(this.getLabel())) {
            if (this.m_lovEditor != null) {
                try {
                    this.m_lovEditor.setProp(4260001, this.m_ap);
                    this.m_lovEditor.setProp(2162850, new Integer(this.m_propId));
                    if (this.m_gvl != null) {
                        this.m_lovEditor.setProp(7405739, this.m_gvl.getItemValue());
                    } else if (this.m_gvi != null) {
                        this.m_lovEditor.setProp(7405739, this.m_gvi.getItemValue());
                    }
                }
                catch (Exception exception) {
                    new ErrorAlert(AdminUtil.getFrame((Component)((Object)this.m_parent)), exception);
                    return;
                }
                this.m_parent.setModified(this.m_propId);
                AdminUtil.editStandalone(this.m_lovEditor, null, (Component)((Object)this.m_parent));
                return;
            }
            if (this.m_lov.length < 20) {
                if (GridView.DEBUG) {
                    System.out.println("m_lov.length=" + this.m_lov.length);
                }
                AdminPopupMenu adminPopupMenu = this.getPopupMenu();
                Rectangle rectangle = ((Component)((Object)this)).getBounds();
                adminPopupMenu.show((Component)((Object)this), rectangle.width / 2, rectangle.height / 2);
                return;
            }
            Dialog dialog = this.getPickerDialog();
            dialog.addWindowListener(new windowListener(this.m_picker));
            Frame frame = this.m_parent.getFrame();
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("actionperformed():  WAIT_CURSOR");
            }
            ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
            try {
                ((Component)dialog).setVisible(true);
                return;
            }
            finally {
                Object var7_10 = null;
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("actionPerformed():  DEFAULT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (this.m_gvl != null) {
            if (GridView.DEBUG) {
                System.out.println("cmd=" + string);
            }
            try {
                this.m_gvl.remove(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.m_gvl.internalAdd(string);
            return;
        }
        if (this.m_gvi != null) {
            int n = 0;
            while (n < this.m_lovStrings.length) {
                if (this.m_lovStrings[n].equals(string)) {
                    if (this.m_keys != null) {
                        this.m_gvi.setItemValue(this.m_keys[n]);
                        return;
                    }
                    this.m_gvi.setItemValue(this.m_lov[n]);
                    return;
                }
                ++n;
            }
        }
    }

    public void setPickedValue(Object object) {
        if (this.m_gvl != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n = 0;
                while (n < objectArray.length) {
                    String string = objectArray[n].toString();
                    try {
                        this.m_gvl.remove(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    this.m_gvl.internalAdd(string);
                    ++n;
                }
            } else {
                String string = object.toString();
                try {
                    this.m_gvl.remove(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                this.m_gvl.internalAdd(string);
            }
            this.m_parent.trackChange(this.m_gvl);
            return;
        }
        if (this.m_gvi != null) {
            Object object2;
            if (object instanceof Object[]) {
                object2 = (Object[])object;
                if (((Object[])object2).length == 0) {
                    return;
                }
                object = object2[0];
            }
            object2 = object.toString();
            if (this.m_lovStrings == null) {
                this.m_gvi.setItemValue(object2);
            } else {
                int n = 0;
                while (n < this.m_lovStrings.length) {
                    if (this.m_lovStrings[n] != null && this.m_lovStrings[n].equals(object2)) {
                        if (this.m_keys != null) {
                            this.m_gvi.setItemValue(this.m_keys[n]);
                            break;
                        }
                        this.m_gvi.setItemValue(this.m_lov[n]);
                        break;
                    }
                    ++n;
                }
            }
            this.m_parent.trackChange(this.m_gvi);
        }
    }

    public int getPropId() {
        return this.m_propId;
    }

    public boolean setObject(Object object) {
        this.m_ap = (IAdminProp)object;
        this.update();
        return true;
    }

    public Object getInitValue() {
        return null;
    }

    public void setInitValue(Object object) {
    }

    public void setItemValue(Object object) {
    }

    public Object getItemValue() {
        return null;
    }

    public void shutdown() {
        System.out.println("shutdown of lov button is called");
        if (this.m_lovEditor != null) {
            this.m_lovEditor.removeAdminPropertyChangeListener(this);
        }
    }

    public boolean isModified(StringBuffer stringBuffer) {
        return false;
    }

    public void revert() {
    }

    public void update() {
    }

    public void commit() {
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        if (this.m_lovEditor == null) {
            return;
        }
        while (true) {
            block11: {
                if (adminPropertyChangeEvent.getPropId() == 7405739) {
                    try {
                        Integer n = (Integer)this.m_lovEditor.getProp(2162850);
                        if (n == null || n != this.m_propId) {
                            if (!adminPropertyChangeEvent.hasMoreElements()) {
                                return;
                            }
                            break block11;
                        }
                        if (this.m_lovEditor.getProp(4260001) != this.m_ap) {
                            if (!adminPropertyChangeEvent.hasMoreElements()) {
                                return;
                            }
                            break block11;
                        }
                        Object object = this.m_lovEditor.getProp(7405739);
                        if (object != null) {
                            this.setPickedValue(object);
                        }
                    }
                    catch (Exception exception) {
                        AdminProp.sUnexpectedException(exception);
                    }
                }
                if (!adminPropertyChangeEvent.hasMoreElements()) {
                    return;
                }
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    class windowListener
    implements WindowListener {
        GridViewListOfValuePicker m_picker;

        public windowListener(GridViewListOfValuePicker gridViewListOfValuePicker) {
            GridViewListLOVButton.this = GridViewListLOVButton.this;
            this.m_picker = gridViewListOfValuePicker;
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
            this.m_picker.setup();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

