/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import oracle.ldap.admin.client.common.AdminCheckboxGroup;
import oracle.ldap.admin.client.common.AdminRadioButton;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.client.propEditors.IEnableField;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GridViewRadio
extends AdminRadioButton
implements GridViewItem,
ItemListener,
IEnableField {
    GridView m_parent;
    IAdminProp m_ap;
    int m_propId;
    Object m_initValue;
    Object m_rollbackValue;
    Vector m_enabledFields = new Vector();
    String m_falseValue = "0";
    String m_trueValue = "1";

    public GridViewRadio(GridView gridView, IAdminProp iAdminProp, int n, boolean bl, Object object, String string, AdminCheckboxGroup adminCheckboxGroup) {
        super(string, adminCheckboxGroup, false);
        this.m_parent = gridView;
        this.m_ap = iAdminProp;
        this.m_propId = n;
        object = this.valueObject2Editor(object);
        this.setState(object != null && (Boolean)object != false);
        this.m_rollbackValue = this.m_initValue = object;
        if (this.m_parent.isSyncProp(n)) {
            this.addItemListener(this);
        } else {
            this.addItemListener(new enableFields());
        }
        this.addItemListener(this.m_parent);
        ((Component)((Object)this)).setEnabled(!bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (GridView.DEBUG) {
            System.out.println("itemStateChanged boolean property : " + itemEvent + " " + this.m_ap.getPropName(this.m_propId) + " state =" + this.getState());
        }
        this.setEnabledFields(this.getState());
        if (this.isModifiedNow(null)) {
            try {
                int[] nArray = new int[1];
                Object[] objectArray = new Object[1];
                nArray[0] = this.m_propId;
                objectArray[0] = this.valueEditor2Object(this.getItemValue());
                this.m_parent.setModified(this.m_propId);
                if (GridView.DEBUG) {
                    System.out.println("Setting boolean property synchronusly: " + this.m_ap.getPropName(this.m_propId) + " to " + objectArray[0]);
                }
                this.m_ap.setProps(nArray, objectArray);
                return;
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
                return;
            }
        }
    }

    public int getPropId() {
        return this.m_propId;
    }

    public boolean setObject(Object object) {
        this.m_ap = (IAdminProp)object;
        this.update();
        return true;
    }

    public Object getInitValue() {
        return this.m_initValue;
    }

    public void setInitValue(Object object) {
        this.m_initValue = object;
    }

    public Object getItemValue() {
        if (this.getState()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setItemValue(Object object) {
        object = this.valueObject2Editor(object);
        if (this.getState() != ((Boolean)object).booleanValue()) {
            this.setState((Boolean)object);
        }
        this.setEnabledFields(this.getState());
    }

    public void shutdown() {
    }

    public boolean isModifiedNow(StringBuffer stringBuffer) {
        block7: {
            block6: {
                boolean bl;
                block5: {
                    Object object;
                    block4: {
                        object = this.m_initValue;
                        if (object != null) break block4;
                        bl = (Boolean)this.getItemValue();
                        break block5;
                    }
                    if (!object.equals(this.getItemValue())) break block6;
                    bl = false;
                }
                if (!bl) break block7;
            }
            if (GridView.DEBUG) {
                System.out.print("Boolean field is modified (now)");
                System.out.print(" m_initValue == " + this.m_initValue);
                System.out.println("  currValue == " + this.getItemValue());
            }
            return true;
        }
        return false;
    }

    public boolean isModified(StringBuffer stringBuffer) {
        block10: {
            block9: {
                boolean bl;
                block8: {
                    Object object;
                    block7: {
                        object = this.m_initValue;
                        if (this.m_parent.isSyncProp(this.m_propId)) {
                            object = this.m_rollbackValue;
                        }
                        if (object != null) break block7;
                        bl = (Boolean)this.getItemValue();
                        break block8;
                    }
                    if (!object.equals(this.getItemValue())) break block9;
                    bl = false;
                }
                if (!bl) break block10;
            }
            if (GridView.DEBUG) {
                System.out.print("Boolean field is modified");
                if (this.m_parent.isSyncProp(this.m_propId)) {
                    System.out.print(" m_rollbackValue == " + this.m_rollbackValue);
                } else {
                    System.out.print(" m_initValue == " + this.m_rollbackValue);
                }
                System.out.println("  currValue == " + this.getItemValue());
            }
            return true;
        }
        return false;
    }

    public void revert() {
        this.setState(this.m_initValue != null && (Boolean)this.m_initValue != false);
        this.setEnabledFields(this.getState());
    }

    public void update() {
        try {
            this.m_initValue = this.valueObject2Editor(this.m_ap.getProp(this.getPropId()));
            this.revert();
            if (GridView.DEBUG) {
                System.out.println("Update boolean property: " + this.m_ap.getPropName(this.m_propId) + " to " + this.m_initValue + " verified " + this.getItemValue());
                return;
            }
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
    }

    public void commit() {
        this.m_rollbackValue = this.m_initValue = this.getItemValue();
        if (GridView.DEBUG) {
            System.out.println("Commit boolean property: " + this.m_ap.getPropName(this.m_propId) + " to " + this.m_initValue);
        }
    }

    public void setEnabledFields(boolean bl) {
        int n = this.m_enabledFields.size();
        int n2 = 0;
        while (n2 < n) {
            Component component = (Component)this.m_enabledFields.elementAt(n2);
            if (GridView.DEBUG) {
                System.out.println("setEnabled " + component + " on=" + bl);
            }
            component.setEnabled(bl);
            ++n2;
        }
    }

    public void addEnabledFields(Component component, Component component2) {
        if (GridView.DEBUG) {
            System.out.println("addEnabledFields " + component);
        }
        this.m_enabledFields.addElement(component);
        if (component2 != null) {
            this.m_enabledFields.addElement(component2);
        }
        if (!this.getState()) {
            component.setEnabled(false);
            if (component2 != null) {
                component2.setEnabled(false);
            }
        }
    }

    public Object valueObject2Editor(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() > 0) {
                String[] stringArray = new String[]{"y", "n", "yes", "no", "true", "false", "on", "off"};
                int n = 0;
                while (n < stringArray.length) {
                    if (string.equalsIgnoreCase(stringArray[n + 1])) {
                        this.m_falseValue = stringArray[n + 1];
                        this.m_trueValue = stringArray[n];
                        object = "0";
                        break;
                    }
                    n += 2;
                }
            }
            object = object.equals("0") ? Boolean.FALSE : Boolean.TRUE;
        } else if (object instanceof Integer) {
            object = object.equals(new Integer(0)) ? Boolean.FALSE : Boolean.TRUE;
        }
        return object;
    }

    public Object valueEditor2Object(Object object) {
        if (!(object instanceof Boolean)) {
            return object;
        }
        if (AdminProp.getPropType(this.m_propId) == 0x100000) {
            if (((Boolean)object).booleanValue()) {
                return this.m_trueValue;
            }
            return this.m_falseValue;
        }
        if (AdminProp.getPropType(this.m_propId) == 0x200000) {
            return new Integer((Boolean)object != false ? 1 : 0);
        }
        return object;
    }

    public String toString() {
        return "[GridViewRadio of " + this.m_ap.getPropName(this.m_propId) + "]";
    }

    class enableFields
    implements ItemListener {
        public enableFields() {
            GridViewRadio.this = GridViewRadio.this;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            GridViewRadio.this.setEnabledFields(GridViewRadio.this.getState());
        }
    }
}

