/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import oracle.ldap.admin.client.common.AdminTextArea;
import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.GridViewItem;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

class GridViewTextArea
extends AdminTextArea
implements GridViewItem,
ActionListener,
FocusListener {
    Object m_initValue;
    Object m_rollbackValue;
    GridView m_parent;
    IAdminProp m_ap;
    int m_propId;
    boolean m_saveOnFocusLost = false;

    public GridViewTextArea(GridView gridView, IAdminProp iAdminProp, int n, boolean bl, Object object) {
        super(gridView.getPropHeight(n, 4), gridView.getPropWidth(n, 60));
        this.m_parent = gridView;
        this.m_ap = iAdminProp;
        this.m_propId = n;
        this.setEditable(!bl);
        if (object != null) {
            this.setText(object.toString());
        }
        this.m_rollbackValue = this.m_initValue = object;
        if (this.m_parent.isSyncProp(n)) {
            this.m_saveOnFocusLost = true;
        }
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.m_saveOnFocusLost && this.isModified(null)) {
            try {
                int[] nArray = new int[1];
                Object[] objectArray = new Object[1];
                nArray[0] = this.m_propId;
                objectArray[0] = this.getItemValue();
                this.m_parent.setModified(this.m_propId);
                this.m_ap.setProps(nArray, objectArray);
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
            }
        }
        this.select(0, 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.m_parent.actionPerformed(null);
    }

    public int getPropId() {
        return this.m_propId;
    }

    public boolean setObject(Object object) {
        this.m_ap = (IAdminProp)object;
        this.update();
        return true;
    }

    public Object getInitValue() {
        return this.m_initValue;
    }

    public void setInitValue(Object object) {
        this.m_initValue = object;
    }

    public Object getItemValue() {
        return this.getText();
    }

    public void setItemValue(Object object) {
        this.setText(object.toString());
    }

    public void shutdown() {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        Object object = this.m_initValue;
        if (this.m_parent.isSyncProp(this.m_propId)) {
            object = this.m_rollbackValue;
        }
        if (object == this.getItemValue()) {
            return false;
        }
        if (object != null && this.getItemValue() == null) {
            return true;
        }
        if (object == null) {
            return !"".equals(this.getItemValue());
        }
        return !object.equals(this.getItemValue());
    }

    public void revert() {
        if (this.m_initValue != null) {
            this.setText(this.m_initValue.toString());
            return;
        }
        this.setText("");
    }

    public void update() {
        try {
            this.m_initValue = this.m_ap.getProp(this.getPropId());
            this.revert();
            return;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return;
        }
    }

    public void commit() {
        this.m_rollbackValue = this.m_initValue = this.getItemValue();
    }
}

