/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.RelativePlacement;
import com.roguewave.chart.core.v2_1.graphics.RelativePosition;
import com.roguewave.chart.standard.v2_1.Chart;
import com.roguewave.chart.standard.v2_1.LineChart;
import com.roguewave.chart.standard.v2_1.events.ChartClickEvent;
import com.roguewave.chart.standard.v2_1.events.ChartClickListener;
import com.roguewave.chart.standard.v2_1.parts.SingleRowLegend;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.common.AdminScrollPane;
import oracle.ldap.admin.client.propEditors.LineDataModel;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class LineView
extends AdminScrollPane
implements RelativePlacement,
ChartClickListener,
AdminPropertyChangeListener {
    Object[] m_items;
    String[] legends;
    String[] xLabels;
    int[] prop_list;
    int item_count;
    int prop_count;
    int c_status;
    Color[] colors;
    Integer CStatus;
    Chart component;

    public LineView(IAdminProp iAdminProp, DataModel dataModel) {
        LineChart lineChart = new LineChart();
        if (dataModel != null) {
            this.component = new Chart((ChartBuilder)lineChart, 2, dataModel);
        }
        this.init(iAdminProp);
        this.component.addChartClickListener((ChartClickListener)this);
        this.setView(iAdminProp);
        this.setColor(iAdminProp);
        this.setLegend(iAdminProp);
        this.component.setDrawAreaInsets(new Insets(45, 25, 35, 50));
        this.component.setLabelColor(Color.black);
        this.component.setTitleColor(Color.blue);
        this.component.setTitleBackgroundColor(Color.cyan.darker());
        Font font = new Font("TimesNewRoman", 0, 11);
        this.component.setLegendItemFont(font);
        this.component.setLabelFont(font);
        this.component.setScale2DFont(font);
        this.component.setLegendPosition(new RelativePosition(0.5, 0.975, -2, 0, 3));
        this.component.setLegendItemBoxSize(12.0);
        AdminUtil.addAdminPropertyChangeListener(iAdminProp, this);
        this.addScrollComponent((Component)this.component);
    }

    private void init(IAdminProp iAdminProp) {
        try {
            this.CStatus = (Integer)iAdminProp.getProp(2162758);
            if (this.CStatus != null) {
                this.c_status = this.CStatus;
            }
            this.xLabels = (String[])iAdminProp.getProp(0x10110041);
            this.legends = (String[])iAdminProp.getProp(269549635);
            this.m_items = (Object[])iAdminProp.getProp(272695365);
            if (this.xLabels != null) {
                this.prop_count = this.xLabels.length;
            }
            if (this.legends != null) {
                this.item_count = this.legends.length;
            }
            this.resizeWidth("labels");
            this.resizeWidth("legends");
            this.colors = (Color[])iAdminProp.getProp(269549634);
            return;
        }
        catch (PropertyException propertyException) {
            return;
        }
    }

    void resizeWidth(String string) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        fontMetrics.getHeight();
        int n = 0;
        int n2 = string.equals("labels") ? this.xLabels.length : this.legends.length;
        int n3 = 0;
        while (n3 < n2) {
            n = string.equals("labels") ? (n += fontMetrics.stringWidth(this.xLabels[n3])) : (n += fontMetrics.stringWidth(this.legends[n3]));
            Dimension dimension = this.component.getSize();
            if (n + 30 > dimension.width) {
                this.component.setSize(new Dimension(dimension.width + 40, dimension.height));
            }
            ++n3;
        }
    }

    public void chartClick(ChartClickEvent chartClickEvent) {
        AdminUtil.editStandalone((IAdminProp)this.m_items[chartClickEvent.getColumn(0)], null, (Component)((Object)this));
    }

    void setColor(IAdminProp iAdminProp) {
        if (this.colors != null) {
            int n = 0;
            while (n < this.prop_count) {
                int n2 = 0;
                while (n2 < this.item_count) {
                    if (this.c_status == 1) {
                        this.component.setProperty("ForegroundColor", (Object)this.colors[n2], n, n2, 1, 1);
                    } else {
                        this.component.setProperty("ForegroundColor", (Object)this.colors[n2], n2, n, 1, 1);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    void setView(IAdminProp iAdminProp) {
        int n = 0;
        try {
            Integer n2 = (Integer)iAdminProp.getProp(2162760);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (PropertyException propertyException) {}
        if (n == 1) {
            this.component.setViewMode(0);
            return;
        }
        this.component.setViewMode(2);
    }

    void setData(IAdminProp iAdminProp) {
        this.init(iAdminProp);
        this.component.setData((DataModel)new LineDataModel(iAdminProp));
        this.setRange(iAdminProp);
        this.resizeWidth("labels");
    }

    void setTitle(IAdminProp iAdminProp) {
        String string = null;
        try {
            string = (String)iAdminProp.getProp(0x110050);
        }
        catch (PropertyException propertyException) {}
        this.component.setTitle(string);
    }

    void setRange(IAdminProp iAdminProp) {
        Double[] doubleArray = null;
        try {
            doubleArray = (Double[])iAdminProp.getProp(273743936);
        }
        catch (PropertyException propertyException) {}
        if (doubleArray[0] != null & doubleArray[1] != null) {
            this.component.setDataRange(doubleArray[0].doubleValue(), doubleArray[1].doubleValue());
        }
    }

    void setLegend(IAdminProp iAdminProp) {
        String[] stringArray = null;
        try {
            stringArray = (String[])iAdminProp.getProp(269549635);
        }
        catch (PropertyException propertyException) {}
        if (this.colors != null & stringArray != null) {
            this.component.setLegend((Customizer)new SingleRowLegend(stringArray, this.colors));
        } else {
            this.component.setLegend((Customizer)new SingleRowLegend());
        }
        this.resizeWidth("legends");
    }

    public static Component createChart(IAdminProp iAdminProp, EditorOwner editorOwner) {
        LineView lineView = new LineView(iAdminProp, new LineDataModel(iAdminProp));
        return lineView;
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            IAdminProp iAdminProp = (IAdminProp)adminPropertyChangeEvent.getSource();
            switch (adminPropertyChangeEvent.getPropId()) {
                case 2162758: 
                case 272695365: 
                case 281083972: {
                    this.setData(iAdminProp);
                    break;
                }
                case 269549634: {
                    this.setColor(iAdminProp);
                    break;
                }
                case 2162760: {
                    this.setView(iAdminProp);
                    break;
                }
                case 0x110050: {
                    this.setTitle(iAdminProp);
                    break;
                }
                case 273743936: {
                    this.setRange(iAdminProp);
                    break;
                }
                case 269549635: {
                    this.setLegend(iAdminProp);
                    break;
                }
            }
            this.component.repaint();
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    void unexpectedException(Exception exception) {
        System.out.println("Unexpected Exception " + exception);
    }
}

