/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import oracle.ldap.admin.client.propEditors.GraphNode;
import oracle.ldap.admin.client.propEditors.Rubberband;
import oracle.ldap.admin.client.propEditors.Shape;

class NodeLabel
implements Shape {
    Object label;
    GraphNode m_parent;
    Rubberband m_band;

    public NodeLabel(Object object, GraphNode graphNode) {
        this.label = object;
        this.m_parent = graphNode;
        this.m_band = this.m_parent.getCanvas().getRubberband();
    }

    public int getWidth() {
        Font font = this.m_parent.m_parent.getFont();
        if (font == null) {
            return this.label.toString().length() * 10;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        if (fontMetrics == null) {
            return this.label.toString().length() * 10;
        }
        return fontMetrics.stringWidth(this.label.toString());
    }

    public int getHeight() {
        Font font = this.m_parent.m_parent.getFont();
        if (font == null) {
            return 10;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        if (fontMetrics == null) {
            return 10;
        }
        return fontMetrics.getHeight() - 2;
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public void paint(Graphics graphics) {
        Point point = this.getOrigin();
        Font font = this.m_parent.getCanvas().getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        graphics.drawString((String)this.label, point.x, point.y + fontMetrics.getAscent());
    }

    public Point getOrigin() {
        Font font = this.m_parent.getCanvas().getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Point point = this.m_parent.getOrigin();
        Dimension dimension = this.m_parent.getDimension();
        return new Point(point.x + (dimension.width - fontMetrics.stringWidth(this.label.toString())) / 2, point.y + dimension.height);
    }

    public void setOrigin(Point point) {
    }

    public void setDimension(Dimension dimension) {
    }

    public void setOrigin(int n, int n2) {
    }

    public void setDimension(int n, int n2) {
    }

    public boolean isDraggable() {
        return true;
    }

    public boolean isMouseOn(int n, int n2) {
        Point point = this.getOrigin();
        Dimension dimension = this.getDimension();
        int n3 = point.x;
        int n4 = point.y;
        int n5 = dimension.width;
        int n6 = dimension.height;
        return n3 <= n && n <= n3 + n5 && n4 <= n2 && n2 <= n4 + n6;
    }

    public void drawLast(Graphics graphics) {
        Point point = this.m_band.lastBounds();
        Dimension dimension = this.getDimension();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.drawRect(point.x, point.y, n, n2);
    }

    public void drawNext(Graphics graphics) {
        Point point = this.m_band.bounds();
        Dimension dimension = this.getDimension();
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.drawRect(point.x, point.y, n, n2);
    }
}

