/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.common.AdminList;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.client.propEditors.IShuttleList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;

class ShuttleList
extends AdminList
implements IEditor,
AdminPropertyChangeListener,
IShuttleList {
    IAdminProp m_ap;
    int m_propId;
    Object[] m_list;
    Vector m_objects = new Vector();

    public ShuttleList(IAdminProp iAdminProp, int n) {
        this.m_ap = iAdminProp;
        this.m_propId = n;
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
        this.init();
    }

    public void init() {
        try {
            this.m_list = (Object[])this.m_ap.getProp(this.m_propId);
            if (this.m_list != null) {
                int n = 0;
                while (n < this.m_list.length) {
                    this.addObject(this.m_list[n]);
                    ++n;
                }
                return;
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            if (adminPropertyChangeEvent.getPropId() == this.m_propId) {
                this.removeAll();
                this.init();
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 2048;
    }

    public void setupToolbar(int n) {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        int n = 0;
        if (this.m_list != null) {
            n = this.m_list.length;
        }
        if (n != this.getItemCount()) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.m_list[n2] instanceof IAdminProp ? this.m_list[n2] == this.getObjectItem(n2) : !this.m_list[n2].toString().equals(this.getItem(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void revert() {
        this.removeAll();
        if (this.m_list != null) {
            int n = 0;
            while (n < this.m_list.length) {
                this.addObject(this.m_list[n]);
                ++n;
            }
        }
    }

    public boolean commit() {
        if (!this.isModified(null)) {
            return true;
        }
        try {
            int n = this.getItemCount();
            switch (AdminProp.getPropType(this.m_propId)) {
                case 0x10100000: {
                    String[] stringArray = new String[n];
                    int n2 = 0;
                    while (n2 < n) {
                        stringArray[n2] = this.getItem(n2);
                        ++n2;
                    }
                    this.m_ap.setProp(this.m_propId, stringArray);
                    break;
                }
                case 0x10200000: {
                    Integer[] integerArray = new Integer[n];
                    int n3 = 0;
                    while (n3 < n) {
                        Object object = this.getObjectItem(n3);
                        integerArray[n3] = object instanceof Integer ? (Integer)object : Integer.valueOf(this.getItem(n3));
                        ++n3;
                    }
                    this.m_ap.setProp(this.m_propId, integerArray);
                    break;
                }
                case 0x10500000: {
                    Double[] doubleArray = new Double[n];
                    int n4 = 0;
                    while (n4 < n) {
                        Object object = this.getObjectItem(n4);
                        doubleArray[n4] = object instanceof Double ? (Double)object : Double.valueOf(this.getItem(n4));
                        ++n4;
                    }
                    this.m_ap.setProp(this.m_propId, doubleArray);
                    break;
                }
                case 0x10400000: {
                    IAdminProp[] iAdminPropArray = new IAdminProp[n];
                    int n5 = 0;
                    while (n5 < n) {
                        iAdminPropArray[n5] = (IAdminProp)this.getObjectItem(n5);
                        ++n5;
                    }
                    this.m_ap.setProp(this.m_propId, iAdminPropArray);
                    break;
                }
            }
            this.update();
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return false;
        }
        return true;
    }

    public void update() {
        this.removeAll();
        this.init();
    }

    public IAdminProp[] getCommandList() {
        return null;
    }

    public IAdminProp properties() {
        return null;
    }

    public void shutdown() {
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
    }

    public Object[] getSelectedObjectItems() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.getObjectItem(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    public void removeObject(Object object) {
        int n = object instanceof String ? this.m_objects.indexOf(object) : AdminProp.vectorIndexOf(this.m_objects, object);
        if (n >= 0) {
            this.m_objects.removeElementAt(n);
            this.remove(n);
        }
    }

    public Object[] getObjectItems() {
        return AdminProp.vectorToObjectArray(this.m_objects);
    }

    public Object getObjectItem(int n) {
        return this.m_objects.elementAt(n);
    }

    public void addObject(Object object, int n) {
        this.m_objects.insertElementAt(object, n);
        String string = null;
        if (object instanceof IAdminProp) {
            try {
                string = (String)((IAdminProp)object).getProp(0x110001);
            }
            catch (Exception exception) {}
        }
        if (string == null) {
            string = object.toString();
        }
        super.add(string, n);
    }

    public void addObject(Object object) {
        this.m_objects.addElement(object);
        String string = null;
        if (object instanceof IAdminProp) {
            try {
                string = (String)((IAdminProp)object).getProp(0x110001);
            }
            catch (Exception exception) {}
        }
        if (string == null) {
            string = object.toString();
        }
        super.add(string);
    }
}

