/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.client.propEditors.Shuttle;
import oracle.ldap.admin.client.propEditors.ShuttleList;
import oracle.ldap.admin.client.propEditors.ShuttleTree;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;

public class ShuttleView
extends Shuttle
implements IEditor,
AdminPropertyChangeListener {
    IAdminProp m_ap;
    IEditor m_fromHeader;
    IEditor m_toHeader;

    public ShuttleView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        this.m_ap = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
        this.init();
    }

    public void init() {
        try {
            ShuttleList shuttleList;
            Integer n = (Integer)this.m_ap.getProp(2098433);
            boolean bl = false;
            boolean bl2 = false;
            if (n != null) {
                int n2 = n;
                if ((n2 & 1) != 0) {
                    this.setMoveMode(true);
                } else {
                    this.setMoveMode(false);
                }
                if ((n2 & 2) != 0) {
                    bl = true;
                }
                if ((n2 & 4) != 0) {
                    bl2 = true;
                }
            }
            int[] nArray = (int[])this.m_ap.getProp(281085184);
            this.setFromHeader((Component)((Object)new AdminLabel(String.valueOf(this.m_ap.getPropName(nArray[0])) + ":")));
            switch (AdminProp.getPropType(nArray[0])) {
                case 0x10100000: 
                case 0x10200000: 
                case 0x10400000: 
                case 0x10500000: {
                    shuttleList = new ShuttleList(this.m_ap, nArray[0]);
                    this.setFromPicker((Component)((Object)shuttleList));
                    this.m_fromHeader = shuttleList;
                    break;
                }
                case 0x400000: {
                    ShuttleTree shuttleTree = new ShuttleTree(this.m_ap, nArray[0]);
                    this.setFromPicker((Component)((Object)shuttleTree));
                    this.m_fromHeader = shuttleTree;
                    break;
                }
            }
            this.setToHeader((Component)((Object)new AdminLabel(String.valueOf(this.m_ap.getPropName(nArray[1])) + ":")));
            switch (AdminProp.getPropType(nArray[1])) {
                case 0x10100000: 
                case 0x10200000: 
                case 0x10400000: 
                case 0x10500000: {
                    shuttleList = new ShuttleList(this.m_ap, nArray[1]);
                    this.setToPicker(shuttleList);
                    this.m_toHeader = shuttleList;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (adminPropertyChangeEvent.hasMoreElements()) {
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
        return;
    }

    public static void main(String[] stringArray) {
        AdminProp adminProp = new AdminProp();
        try {
            int n = 0x10103000;
            int n2 = 0x10103001;
            int[] nArray = new int[]{n, n2};
            adminProp.registerProp(n, "From", "");
            String[] stringArray2 = new String[]{"One", "Two", "Three"};
            adminProp.setProp(n, (Object)stringArray2);
            adminProp.registerProp(n2, "To", "");
            String[] stringArray3 = new String[]{"Four", "Five", "Six"};
            adminProp.setProp(n2, (Object)stringArray3);
            adminProp.setProp(281085184, (Object)nArray);
            adminProp.setProp(2098433, (Object)new Integer(1));
            adminProp.setProp(3080204, (Object)new Integer(2048));
            adminProp.setProp(2031768, (Object)"Test Shuttle");
            AdminUtil.editStandalone(adminProp, null);
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    public static Component createShuttleView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        return new ShuttleView(iAdminProp, editorOwner);
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 2048;
    }

    public void setupToolbar(int n) {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        if (this.m_toHeader != null) {
            return this.m_toHeader.isModified(stringBuffer);
        }
        return false;
    }

    public void revert() {
        if (this.m_fromHeader != null) {
            this.m_fromHeader.revert();
        }
        if (this.m_toHeader != null) {
            this.m_toHeader.revert();
        }
    }

    public boolean commit() {
        boolean bl = true;
        if (this.m_toHeader != null) {
            bl = this.m_toHeader.commit();
        }
        try {
            this.m_ap.saveChanges(0);
        }
        catch (Exception exception) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
            return false;
        }
        return bl;
    }

    public void update() {
        if (this.m_fromHeader != null) {
            this.m_fromHeader.update();
        }
        if (this.m_toHeader != null) {
            this.m_toHeader.update();
        }
    }

    public IAdminProp[] getCommandList() {
        return null;
    }

    public IAdminProp properties() {
        return null;
    }

    public void shutdown() {
        if (this.m_fromHeader != null) {
            this.m_fromHeader.shutdown();
        }
        if (this.m_toHeader != null) {
            this.m_toHeader.shutdown();
        }
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
    }
}

