/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorFactory;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminSplitter;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class SplitPanelView
extends AdminPanel
implements IEditor,
AdminPropertyChangeListener,
PropertyChangeListener {
    public static boolean DEBUG;
    IAdminProp m_ap;
    MyAdminSplitter m_splitter;
    Component[] m_cs = new Component[2];
    Component m_c1;
    Component m_c2;
    boolean m_layoutVertical;
    EditorOwner m_owner;

    public SplitPanelView(IAdminProp iAdminProp, EditorOwner editorOwner, boolean bl) {
        this.m_ap = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
        this.init(editorOwner, bl);
        AdminUtil.setBackground((Component)((Object)this));
    }

    public SplitPanelView(IAdminProp iAdminProp, Component component, Component component2, boolean bl) {
        this.m_ap = iAdminProp;
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
        this.init(component, component2, bl);
        AdminUtil.setBackground((Component)((Object)this));
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            switch (adminPropertyChangeEvent.getPropId()) {
                case 272630384: {
                    if (adminPropertyChangeEvent.getSource() != this.m_ap) break;
                    boolean bl = true;
                    try {
                        Integer n = (Integer)this.m_ap.getProp(2097777);
                        if (n != null) {
                            bl = n == 2;
                        }
                    }
                    catch (PropertyException propertyException) {
                        AdminProp.sUnexpectedException(propertyException);
                    }
                    this.removeAll();
                    AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
                    this.shutdown();
                    this.init(this.m_owner, bl);
                    AdminUtil.fixup((Component)((Object)this));
                    break;
                }
                case 282001422: {
                    this.propertyChange(null);
                    break;
                }
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public void init(EditorOwner editorOwner, boolean bl) {
        IAdminProp[] iAdminPropArray;
        this.m_owner = editorOwner;
        try {
            iAdminPropArray = (IAdminProp[])this.m_ap.getProp(272630384);
        }
        catch (PropertyException propertyException) {
            this.debugMessageLn("Couldn't get object list " + propertyException);
            return;
        }
        if (iAdminPropArray == null) {
            this.debugMessageLn("No property list!!");
            return;
        }
        try {
            this.init(EditorFactory.getEditor(iAdminPropArray[0], editorOwner), EditorFactory.getEditor(iAdminPropArray[1], editorOwner), bl);
            if (iAdminPropArray[0] != null) {
                iAdminPropArray[0].addAdminPropertyChangeListener(this);
            }
            if (iAdminPropArray[1] != null) {
                iAdminPropArray[1].addAdminPropertyChangeListener(this);
                return;
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
    }

    public void init(Component component, Component component2, boolean bl) {
        this.m_layoutVertical = bl;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        try {
            this.m_cs[0] = this.m_c1 = component;
            if (this.m_c1 == null) {
                this.m_cs[0] = this.m_c1 = new AdminLabel(ClientLang.getStrNoEditor());
            }
            this.m_cs[1] = this.m_c2 = component2;
            if (this.m_c2 == null) {
                this.m_cs[1] = this.m_c2 = new AdminLabel(ClientLang.getStrNoEditor());
            }
            if (this.m_splitter != null) {
                this.m_splitter.removePropertyChangeListener(this);
            }
            this.m_splitter = new MyAdminSplitter(this.m_c1, this.m_c2, bl);
            this.m_splitter.addPropertyChangeListener(this);
            ((Container)((Object)this)).add("Center", (Component)((Object)this.m_splitter));
            return;
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
            return;
        }
    }

    String getEditorName(Component component) {
        String string = component.getClass().getName();
        int n = string.lastIndexOf(".");
        return string.substring(n + 1);
    }

    void printState() {
        Dimension dimension = this.m_c1.getPreferredSize();
        System.out.print("\n" + this.getEditorName(this.m_c1) + ": c1 pref (w=" + dimension.width + " h=" + dimension.height);
        dimension = this.m_c1.getSize();
        System.out.println(") size (w=" + dimension.width + " h=" + dimension.height + ") obj=" + (this.m_c1 instanceof IEditor ? ((IEditor)((Object)this.m_c1)).getObject() : ""));
        Dimension dimension2 = this.m_c2.getPreferredSize();
        System.out.print(String.valueOf(this.getEditorName(this.m_c2)) + ": c2 pref (w=" + dimension2.width + " h=" + dimension2.height);
        dimension2 = this.m_c2.getSize();
        System.out.println(") c2 size (w=" + dimension2.width + " h=" + dimension2.height + ") obj=" + (this.m_c2 instanceof IEditor ? ((IEditor)((Object)this.m_c2)).getObject() : ""));
    }

    public static Component createSplitPanelView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        boolean bl = true;
        try {
            Integer n = (Integer)iAdminProp.getProp(2097777);
            if (n != null) {
                bl = n == 2;
            }
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        return new SplitPanelView(iAdminProp, editorOwner, bl);
    }

    void debugMessageLn(String string) {
        System.out.println(string);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, dimension.height + 100);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean displayObject(Object object) {
        if (this.getObject() == object) {
            return true;
        }
        Component[] componentArray = this.m_cs;
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    if (iEditor.displayObject(object)) {
                        return true;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return false;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 131072;
    }

    public void setupToolbar(int n) {
        Component[] componentArray = this.m_cs;
        int n2 = 0;
        while (n2 < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n2]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    iEditor.setupToolbar(n);
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n2;
        }
    }

    public boolean isModified(StringBuffer stringBuffer) {
        Component[] componentArray = this.m_cs;
        int n = 0;
        while (n < componentArray.length) {
            Component component = AdminUtil.removeScrollBox(componentArray[n]);
            if (component instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)component);
                    if (iEditor.isModified(stringBuffer)) {
                        return true;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return false;
    }

    public void revert() {
        Component[] componentArray = this.m_cs;
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)componentArray[n]);
                    iEditor.revert();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
    }

    public boolean commit() {
        Component[] componentArray = this.m_cs;
        boolean bl = true;
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)componentArray[n]);
                    if (!iEditor.commit()) {
                        bl = false;
                    }
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
        return bl;
    }

    public void update() {
        Component[] componentArray = this.m_cs;
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)componentArray[n]);
                    iEditor.update();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
    }

    public IAdminProp[] getCommandList() {
        IAdminProp[] iAdminPropArray = null;
        IAdminProp[] iAdminPropArray2 = null;
        try {
            iAdminPropArray = ((IEditor)((Object)this.m_c1)).getCommandList();
        }
        catch (Exception exception) {}
        try {
            iAdminPropArray2 = ((IEditor)((Object)this.m_c2)).getCommandList();
        }
        catch (Exception exception) {}
        return AdminUtil.mergeCmdList(iAdminPropArray, iAdminPropArray2);
    }

    public IAdminProp properties() {
        return null;
    }

    public void shutdown() {
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
        Component[] componentArray = this.m_cs;
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof IEditor) {
                try {
                    IEditor iEditor = (IEditor)((Object)componentArray[n]);
                    iEditor.shutdown();
                }
                catch (ClassCastException classCastException) {
                    AdminProp.sUnexpectedException(classCastException);
                }
            }
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    void adjustSize(Component component, Component component2, Dimension dimension, Dimension dimension2, double d) {
        int n = dimension.height + dimension2.height;
        double d2 = dimension.height / n;
        if (d2 > d && d2 - d > 0.1) {
            int n2 = new Double((double)n * (d2 - d)).intValue();
            dimension.height -= n2;
        } else if (d2 < d && d - d2 > 0.1) {
            int n3 = new Double((double)n * (d - d2)).intValue();
            dimension2.height -= n3;
        }
        component.setSize(dimension);
        component2.setSize(dimension2);
    }

    public class MyAdminSplitter
    extends AdminSplitter {
        boolean initialized = true;
        int m_lastPos;
        Dimension m_lastSize = new Dimension(0, 0);
        boolean m_locked = false;
        boolean m_once = true;

        public MyAdminSplitter(Component component, Component component2, boolean bl) {
            super(component, component2, bl);
            SplitPanelView.this = SplitPanelView.this;
        }

        public void setSplitterPosition(int n) {
            block4: {
                if (this.m_locked) {
                    if (DEBUG) {
                        System.out.println("Locked update");
                    }
                    return;
                }
                this.m_locked = true;
                try {
                    this.setSplitterPosition2(n);
                    if (!this.initialized) break block4;
                    this.m_once = false;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.m_locked = false;
                    throw throwable;
                }
            }
            Object var3_2 = null;
            this.m_locked = false;
        }

        public void setSplitterPosition2(int n) {
            if (DEBUG) {
                System.out.println("\nsetSplitterPosition=" + n);
            }
            if (!this.initialized) {
                if (DEBUG) {
                    System.out.println("\nsuper.setSplitterPosition1=" + n);
                }
                super.setSplitterPosition(n);
                return;
            }
            Dimension dimension = SplitPanelView.this.m_c1.getPreferredSize();
            Dimension dimension2 = SplitPanelView.this.m_c2.getSize();
            Dimension dimension3 = SplitPanelView.this.m_c2.getSize();
            double d = this.getSizeRatio();
            if (DEBUG) {
                System.out.println("c1.prefSize = " + dimension);
                System.out.println("c2.size = " + dimension2);
                System.out.println("ratio is " + d);
            }
            if (SplitPanelView.this.m_layoutVertical) {
                if (n < 0 || this.m_once || dimension.height > 10 && dimension.height < n && (dimension2.width == 0 || dimension2.height == 0 || dimension3.width == 0 || dimension3.height == 0)) {
                    if (DEBUG) {
                        String string = "vertical";
                        System.out.println("set split position at " + dimension.height + " " + string);
                    }
                    if (dimension.height <= 0) {
                        dimension.height = 50;
                    }
                    super.setSplitterPosition(dimension.height + 30);
                    SplitPanelView.this.adjustSize(SplitPanelView.this.m_c1, SplitPanelView.this.m_c2, dimension, dimension2, d);
                    if (DEBUG) {
                        System.out.println("c1 = " + SplitPanelView.this.m_c1.getBounds());
                        System.out.println("c2 = " + SplitPanelView.this.m_c2.getBounds());
                    }
                    return;
                }
            } else if (n < 0 || this.m_once || dimension.width > 10 && dimension.width < n && (dimension2.width == 0 || dimension2.height == 0 || dimension3.width == 0 || dimension3.height == 0)) {
                if (DEBUG) {
                    String string = "horizontal";
                    System.out.println("set split position at " + dimension.width + " " + string);
                }
                if (dimension.width <= 0) {
                    dimension.width = 50;
                }
                super.setSplitterPosition(dimension.width - 50);
                if (DEBUG) {
                    System.out.println("c1 = " + SplitPanelView.this.m_c1.getBounds());
                    System.out.println("c2 = " + SplitPanelView.this.m_c2.getBounds());
                }
                return;
            }
            Dimension dimension4 = ((Component)((Object)this)).getSize();
            if (this.m_lastPos != 0 && !this.m_lastSize.equals(dimension4)) {
                this.m_lastSize.setSize(dimension4);
                return;
            }
            if (DEBUG) {
                System.out.println("\nsuper.setSplitterPosition2=" + n);
            }
            this.m_lastSize.setSize(dimension4);
            this.m_lastPos = n;
            super.setSplitterPosition(this.m_lastPos);
        }
    }
}

