/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.CommandPopupMenu;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.ISelectionOwner;
import oracle.ldap.admin.client.NavigatorFrame;
import oracle.ldap.admin.client.PropToolbar;
import oracle.ldap.admin.client.common.AdminButton;
import oracle.ldap.admin.client.common.AdminGrid;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminSpreadTable;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.client.propEditors.TableCols;
import oracle.ldap.admin.client.propEditors.TableCommandProp;
import oracle.ldap.admin.client.propEditors.TableConfig;
import oracle.ldap.admin.client.propEditors.TableConfigFind;
import oracle.ldap.admin.client.propEditors.TableData;
import oracle.ldap.admin.client.propEditors.TablePanel;
import oracle.ldap.admin.client.propEditors.TableRows;
import oracle.ldap.admin.common.AdminLang;
import oracle.ldap.admin.common.AdminList;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.AdminSort;
import oracle.ldap.admin.common.ClientLang;
import oracle.ldap.admin.common.CommandProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;

public class Table
extends AdminSpreadTable
implements IEditor,
AdminPropertyChangeListener,
ISelectionOwner,
ActionListener {
    public static boolean DEBUG;
    static final int ICON_COL_LENGTH = 1;
    static final int ICON_WIDTH = 26;
    boolean m_sendSelectionNotification = false;
    IAdminProp[] _cmdList;
    TableData m_data;
    TableCols m_cols;
    TableRows m_rows;
    IAdminProp m_ap;
    boolean m_allowOpen = true;
    boolean m_allowSort = true;
    boolean m_allowEdit = true;
    boolean m_allowFind = false;
    boolean m_allowCreate = true;
    boolean m_allowDelete = true;
    boolean m_allowMove = true;
    boolean m_allowSaveChange = false;
    boolean m_useButtons = true;
    boolean m_placeButtonsEast = false;
    boolean m_hideToolbarBtns = false;
    boolean m_limitSize = false;
    boolean m_dontCreateEditBtn = false;
    IAdminProp m_selectionObj;
    trackButtonState m_trackBtnState;
    static int colWidthFactor;
    Point _popupPoint;
    TablePanel m_parent;
    static IAdminProp[] m_noSelection;
    Hashtable m_colSorting;
    String m_singleSortedColumn;
    int m_singleSortedColumnNum;

    public boolean hasSelection() {
        return this.m_selectionObj != null;
    }

    public IAdminProp getSelection() {
        int[] nArray = this.getSelectedRows();
        if (nArray == null) {
            return null;
        }
        Object[] objectArray = this.m_data.getRows();
        if (objectArray == null) {
            return null;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < objectArray.length) {
                return (IAdminProp)objectArray[nArray[n]];
            }
            ++n;
        }
        return null;
    }

    public void setSelection(IAdminProp iAdminProp) {
        this.m_selectionObj = iAdminProp;
        AdminUtil.setSelectionOwner((Component)((Object)this), this);
    }

    public void clearSelection() {
        if (this.isSomethingSelected()) {
            this.deselectAll();
        }
        this.m_selectionObj = null;
        AdminUtil.removeSelectionOwner((Component)((Object)this), this);
    }

    public void rowSelected() {
        if (DEBUG) {
            System.out.println("Table.rowSelected");
        }
        if (!this.hasSelection()) {
            this.setSelection(this.m_ap);
        }
        this.updateCmdSelection(null);
        if (this._popupPoint != null) {
            int[] nArray = this.getSelectedRows();
            Object[] objectArray = this.m_data.getRows();
            Vector<IAdminProp> vector = new Vector<IAdminProp>();
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] < objectArray.length) {
                    vector.addElement((IAdminProp)objectArray[nArray[n]]);
                }
                ++n;
            }
            Object[] objectArray2 = new IAdminProp[vector.size()];
            vector.copyInto(objectArray2);
            this._popupPoint = null;
        }
    }

    public void rowDeselected() {
        if (DEBUG) {
            System.out.println("Table.rowDeselected");
        }
        this.updateCmdSelection(null);
        if (!this.isSomethingSelected()) {
            this.clearSelection();
        }
    }

    public void deselectAll() {
        super.deselectAll();
        this.resetSelection();
    }

    public Table(IAdminProp iAdminProp, TableData tableData, TableCols tableCols, TableRows tableRows) {
        super(tableData, tableCols, tableRows);
        this.m_data = tableData;
        this.m_cols = tableCols;
        this.m_rows = tableRows;
        this.m_ap = iAdminProp;
        this.init();
    }

    public Table(IAdminProp iAdminProp, TableData tableData, TableCols tableCols, TableRows tableRows, AdminGrid adminGrid) {
        super(tableData, tableCols, tableRows);
        this.setAdminGrid(adminGrid);
        this.m_data = tableData;
        this.m_cols = tableCols;
        this.m_rows = tableRows;
        this.m_ap = iAdminProp;
        this.init();
    }

    public void init() {
        AdminUtil.addAdminPropertyChangeListener(this.m_ap, this);
        this.deselectAll();
        this.m_data.setTable(this);
        try {
            Integer n = (Integer)this.m_ap.getProp(2162725);
            if (n != null) {
                int n2 = n;
                if ((n2 & 1) != 0) {
                    this.setVerticalSeparatorsVisible(true);
                }
                if ((n2 & 2) != 0) {
                    this.setHorizontalSeparatorsVisible(true);
                }
                if ((n2 & 0x40) != 0) {
                    this.m_sendSelectionNotification = true;
                }
                if ((n2 & 0x80) != 0) {
                    this.m_allowOpen = false;
                }
                if ((n2 & 0x20) != 0) {
                    this.m_allowSort = false;
                }
                if ((n2 & 0x100) != 0) {
                    this.m_allowEdit = false;
                    this.m_data.setEdit(this.m_allowEdit);
                }
                if ((n2 & 0x20000) != 0) {
                    this.m_allowFind = true;
                }
                if ((n2 & 8) != 0) {
                    this.m_allowCreate = false;
                }
                if ((n2 & 4) != 0) {
                    this.m_allowDelete = false;
                }
                if ((n2 & 0x10) != 0) {
                    this.m_allowMove = false;
                }
                if ((n2 & 0x800) != 0) {
                    this.m_allowSaveChange = true;
                }
                if ((n2 & 0x2000) != 0) {
                    this.m_useButtons = false;
                    this.m_dontCreateEditBtn = true;
                }
                if ((n2 & 0x8000) != 0) {
                    this.m_hideToolbarBtns = true;
                }
                if ((n2 & 0x4000) != 0) {
                    this.m_placeButtonsEast = true;
                }
                if ((n2 & 0x10000) != 0) {
                    this.m_limitSize = true;
                }
            }
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
        }
        this.m_cols.setParent(this);
        this.setColumnWidths();
        this.setSelection();
        this.setTopRow();
    }

    public void buildTableButtons(TablePanel tablePanel) {
        if (!this.m_useButtons || this._cmdList == null || this._cmdList.length == 0) {
            return;
        }
        if (this.m_trackBtnState == null) {
            this.m_trackBtnState = new trackButtonState();
        }
        AdminPanel adminPanel = new AdminPanel();
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        if (this.m_placeButtonsEast) {
            gridBagLayout = new GridBagLayout();
            ((Container)((Object)adminPanel)).setLayout(gridBagLayout);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.insets.right = 5;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
        } else {
            ((Container)((Object)adminPanel)).setLayout(new FlowLayout(2));
        }
        int n = 0;
        while (n < this._cmdList.length) {
            block14: {
                AdminButton adminButton;
                IAdminProp iAdminProp;
                block13: {
                    iAdminProp = this._cmdList[n];
                    try {
                        adminButton = new AdminButton((String)iAdminProp.getProp(0x110001));
                        ((Component)((Object)adminButton)).setEnabled((Boolean)iAdminProp.getProp(8978948));
                        adminButton.setToolTipValue((String)iAdminProp.getProp(1638914));
                        if (this.m_placeButtonsEast) break block13;
                        if (n == 0) {
                            adminButton.setLeftmost(true);
                        }
                        if (n + 1 != this._cmdList.length) break block13;
                        adminButton.setRightmost(true);
                    }
                    catch (Exception exception) {
                        break block14;
                    }
                }
                adminButton.addActionListener(this);
                this.m_trackBtnState.associate(iAdminProp, adminButton);
                if (this.m_placeButtonsEast) {
                    gridBagConstraints.gridy = n;
                    if (n == 0) {
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.insets.top = 20;
                    } else {
                        gridBagConstraints.insets.top = 5;
                        gridBagConstraints.weighty = 0.0;
                    }
                    if (n + 1 == this._cmdList.length) {
                        gridBagConstraints.weighty = 1.0;
                    }
                    gridBagLayout.setConstraints((Component)((Object)adminButton), gridBagConstraints);
                }
                ((Container)((Object)adminPanel)).add((Component)((Object)adminButton));
            }
            ++n;
        }
        if (this.m_placeButtonsEast) {
            ((Container)((Object)tablePanel)).add("East", (Component)((Object)adminPanel));
            return;
        }
        ((Container)((Object)tablePanel)).add("South", (Component)((Object)adminPanel));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (this._cmdList == null) {
            return;
        }
        Component component = actionEvent != null ? (Component)actionEvent.getSource() : null;
        String string2 = string = actionEvent != null ? actionEvent.getActionCommand() : null;
        if (component != null && string == null && component instanceof AdminButton) {
            string = ((AdminButton)((Object)component)).getLabel();
        }
        int n = 0;
        while (n < this._cmdList.length) {
            try {
                IAdminProp iAdminProp = this._cmdList[n];
                if (iAdminProp != null && string.equals((String)iAdminProp.getProp(0x110001))) {
                    if (DEBUG) {
                        System.out.println("Table.actionPerformed() server object command invoked");
                    }
                    PropToolbar.callCommand(iAdminProp, (Component)((Object)this));
                    return;
                }
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
            }
            ++n;
        }
    }

    static int getColWidthFactor() {
        if (colWidthFactor == 0) {
            String string = Locale.getDefault().toString().toLowerCase();
            colWidthFactor = string.startsWith("ja") || string.startsWith("zh") ? 20 : 10;
        }
        return colWidthFactor;
    }

    public void setColumnWidths() {
        block22: {
            try {
                int n;
                int[] nArray = (int[])this.m_ap.getProp(282001424);
                int[] nArray2 = (int[])this.m_ap.getProp(281083936);
                if (this._cmdList == null) {
                    IAdminProp[] iAdminPropArray;
                    Object object;
                    this._cmdList = AdminUtil.getCommandList(this.m_ap, 273220108);
                    n = 0;
                    if (this._cmdList != null && this._cmdList.length != 0 && AdminProp.findObject(this._cmdList, 0x110001, (Object)ClientLang.getStrEdit()) != null) {
                        n = 1;
                    }
                    if (n == 0 && this.m_allowOpen && !this.m_dontCreateEditBtn) {
                        object = (IAdminProp[])this.m_ap.getProp(1639559);
                        if (object == null) {
                            object = ClientLang.getStrEdit();
                        }
                        iAdminPropArray = new IAdminProp[]{new CommandProp(new TableCommandAdaptor(this), -51, (String)object, "", "images/edit.gif", 1, 1)};
                        this._cmdList = AdminUtil.mergeCmdList(this._cmdList, iAdminPropArray);
                    }
                    if (this.m_allowFind && !this.m_dontCreateEditBtn) {
                        object = (String)this.m_ap.getProp(1639560);
                        if (object == null) {
                            object = ClientLang.getStrFindObjects();
                        }
                        iAdminPropArray = new IAdminProp[]{new CommandProp(new TableCommandAdaptor(this), -18, (String)object, "", "images/find.gif", 0, 0)};
                        this._cmdList = AdminUtil.mergeCmdList(this._cmdList, iAdminPropArray);
                    }
                    if (this._cmdList != null && this._cmdList.length != 0) {
                        object = new IAdminProp[this._cmdList.length];
                        int n2 = 0;
                        while (n2 < this._cmdList.length) {
                            object[n2] = new TableCommandProp(0, this._cmdList[n2], this);
                            ++n2;
                        }
                        this._cmdList = object;
                    }
                }
                if (this._cmdList != null) {
                    this.enableCommandList(0, true, null);
                }
                if (this.getColumnCount() > 0) {
                    this.setColumnImageCellPainter(0);
                    this.setColumnWidth(0, 26);
                }
                if (nArray2 == null) break block22;
                n = Table.getColWidthFactor();
                int n3 = 0;
                while (n3 < nArray2.length) {
                    if (n3 + 1 >= this.getColumnCount()) break;
                    try {
                        this.setColumnWidth(n3 + 1, nArray2[n3] * n);
                        if (AdminProp.getPropType(nArray[n3]) == 0x800000) {
                            if (!AdminProp.isPropReadonly(nArray[n3])) {
                                this.setColumnCellBooleanInputHandler(n3 + 1);
                            }
                            this.setColumnCheckCellPainter(n3 + 1);
                        } else {
                            this.setColumnTextCellPainter(n3 + 1);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("column #=" + n3 + " col_width=" + nArray2[n3]);
                        exception.printStackTrace();
                    }
                    ++n3;
                }
                if (this.getHeaderItemCount() > 0) {
                    this.setHeaderItemSize(0, 26);
                }
                int n4 = 0;
                while (n4 < nArray2.length) {
                    if (n4 + 1 >= this.getHeaderItemCount()) break;
                    try {
                        this.setHeaderItemSize(n4 + 1, nArray2[n4] * n);
                    }
                    catch (Exception exception) {
                        System.out.println("column #=" + n4 + " col_width=" + nArray2[n4]);
                        exception.printStackTrace();
                    }
                    ++n4;
                }
                return;
            }
            catch (PropertyException propertyException) {
                new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
            }
        }
    }

    public static Component createTable(IAdminProp iAdminProp, EditorOwner editorOwner) {
        Table table = new Table(iAdminProp, new TableData(iAdminProp), new TableCols(iAdminProp), new TableRows(iAdminProp));
        Component component = table.getScrollPane();
        TablePanel tablePanel = new TablePanel(iAdminProp);
        tablePanel.add(component, table);
        table.m_parent = tablePanel;
        table.buildTableButtons(tablePanel);
        return tablePanel;
    }

    public static Component createTableView(IAdminProp iAdminProp, int n, IAdminProp iAdminProp2, AdminGrid[] adminGridArray) {
        IAdminProp[] iAdminPropArray = null;
        try {
            iAdminPropArray = (IAdminProp[])iAdminProp.getProp(n);
        }
        catch (Exception exception) {
            new ErrorAlert((Frame)((Object)AdminUtil.getNavigator()), exception);
        }
        AdminList adminList = new AdminList(iAdminPropArray);
        adminList.setSampleChild(iAdminProp2);
        Table table = new Table(adminList, new TableData(adminList), new TableCols(adminList), new TableRows(adminList));
        Component component = table.getScrollPane();
        TablePanel tablePanel = new TablePanel(adminList);
        tablePanel.add(component, table);
        table.m_parent = tablePanel;
        if (adminGridArray != null) {
            adminGridArray[0] = table.getAdminGrid();
        }
        return tablePanel;
    }

    public static void main(String[] stringArray) {
        IAdminProp[] iAdminPropArray = new IAdminProp[10];
        AdminList adminList = new AdminList(iAdminPropArray);
        AdminLang adminLang = new AdminLang();
        try {
            adminList.setProp(2031768, (Object)"Table Test");
        }
        catch (Exception exception) {
            new ErrorAlert((Frame)((Object)AdminUtil.getNavigator()), exception);
        }
        int n = 0;
        while (n < iAdminPropArray.length) {
            AdminProp adminProp = new AdminProp();
            iAdminPropArray[n] = adminProp;
            try {
                int n2 = 0;
                adminProp.setProp(4784134, (Object)adminLang);
                int n3 = 0x3000 | 0x200000 + n2++;
                adminProp.registerProp(n3, "Line", "");
                adminProp.setProp(n3, (Object)new Integer(n));
                n3 = 0x3000 | 0x100000 + n2++;
                adminProp.registerProp(n3, "String Column", "");
                adminProp.setProp(n3, (Object)"String value");
                n3 = 0x3000 | 0x10100000 + n2++;
                adminProp.registerProp(n3, "String List", "");
                String[] stringArray2 = new String[]{"One", "Two", "Three"};
                adminProp.setProp(n3, (Object)stringArray2);
                n3 = 0x3000 | 0x10200000 + n2++;
                adminProp.registerProp(n3, "Integer List", "");
                Integer[] integerArray = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
                adminProp.setProp(n3, (Object)integerArray);
            }
            catch (Exception exception) {
                new ErrorAlert((Frame)((Object)AdminUtil.getNavigator()), exception);
            }
            ++n;
        }
        AdminUtil.editStandalone(adminList, null);
    }

    void unexpectedException(Exception exception) {
        exception.printStackTrace();
        new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mousePressed(boolean bl, int n, int n2, int n3) {
        if (DEBUG) {
            System.out.println("Table.mousePressed");
        }
        if (bl) {
            int[] nArray = this.getSelectedRows();
            if (nArray != null) {
                int n4 = this.getRowAt(n2);
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (nArray[n5] == n4) {
                        Object[] objectArray = this.m_data.getRows();
                        Vector<IAdminProp> vector = new Vector<IAdminProp>();
                        int n6 = 0;
                        while (true) {
                            if (n6 >= nArray.length) {
                                Object[] objectArray2 = new IAdminProp[vector.size()];
                                vector.copyInto(objectArray2);
                                CommandPopupMenu commandPopupMenu = new CommandPopupMenu((IAdminProp)objectArray2[0]);
                                if (commandPopupMenu.getItemCount() > 0) {
                                    ((Container)((Object)this)).add((Component)((Object)commandPopupMenu));
                                    commandPopupMenu.show((Component)((Object)this), n, n2 + this.getColumnHeaderHeight());
                                }
                                return;
                            }
                            if (nArray[n6] < objectArray.length) {
                                vector.addElement((IAdminProp)objectArray[nArray[n6]]);
                            }
                            ++n6;
                        }
                    }
                    ++n5;
                }
            }
            this._popupPoint = new Point(n, n2);
            return;
        }
        this._popupPoint = null;
        if (this.m_allowOpen && n3 % 2 == 0) {
            int[] nArray = this.getSelectedRows();
            if (nArray == null) {
                return;
            }
            Object[] objectArray = this.m_data.getRows();
            if (objectArray == null) {
                return;
            }
            Frame frame = this.getFrame();
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("mousepressed():  WAIT_CURSOR");
            }
            ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
            try {
                int n7 = 0;
                while (n7 < nArray.length) {
                    if (nArray[n7] < objectArray.length) {
                        AdminUtil.editStandalone((IAdminProp)objectArray[nArray[n7]], null, (Component)((Object)this));
                        break;
                    }
                    ++n7;
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("mousepressed():  DEFAULT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            Object var9_14 = null;
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("mousepressed():  DEFAULT_CURSOR");
            }
            ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 64;
    }

    public void setupToolbar(int n) {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        return false;
    }

    public void revert() {
    }

    public boolean commit() {
        if (this.m_allowSaveChange) {
            try {
                this.m_ap.saveChanges(0);
            }
            catch (Exception exception) {
                new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
                return false;
            }
        }
        return true;
    }

    public void update() {
    }

    public IAdminProp[] getCommandList() {
        if (this.m_hideToolbarBtns) {
            return null;
        }
        return this._cmdList;
    }

    public IAdminProp properties() {
        return new TableConfig(this.m_ap, this, this.m_data, this.m_cols);
    }

    public void shutdown() {
        if (this.m_trackBtnState != null) {
            this.m_trackBtnState.shutdown();
        }
        this.m_data.shutdown();
        this.m_cols.shutdown();
        this.m_rows.shutdown();
        AdminUtil.removeAdminPropertyChangeListener(this.m_ap, this);
    }

    public void setSelection() {
        try {
            IAdminProp[] iAdminPropArray = (IAdminProp[])this.m_ap.getProp(273220105);
            if (iAdminPropArray == null) {
                return;
            }
            int n = 0;
            Object[] objectArray = this.m_data.getRows();
            super.deselectAll();
            if (objectArray == null) {
                return;
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                int n3 = 0;
                while (n3 < iAdminPropArray.length) {
                    if (objectArray[n2] == iAdminPropArray[n3]) {
                        this.setRowSelected(n2, true);
                        if (iAdminPropArray.length == ++n) break;
                    }
                    ++n3;
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public void setTopRow() {
        try {
            IAdminProp iAdminProp = (IAdminProp)this.m_ap.getProp(5177501);
            if (iAdminProp == null) {
                return;
            }
            Object[] objectArray = this.m_data.getRows();
            if (objectArray == null) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == iAdminProp) {
                    this.setFirstRowOnScreen(n);
                    return;
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            if (adminPropertyChangeEvent.getSource() == this.m_ap) {
                switch (adminPropertyChangeEvent.getPropId()) {
                    case 273220105: {
                        this.setSelection();
                        break;
                    }
                    case 5177501: {
                        this.setTopRow();
                        break;
                    }
                    case 0x10110021: 
                    case 282001424: {
                        int n = this.getColumnCount();
                        this.m_data.reset();
                        this.m_cols.reset();
                        this.m_rows.reset();
                        int n2 = this.m_data.getColumnCount();
                        if (n < n2) {
                            this.m_data.sendEvent(2001, n, n2 - n, 0, 0);
                            this.m_cols.sendEvent(2001, n, n2 - n);
                        } else if (n > n2) {
                            this.m_data.sendEvent(2002, n2, n - n2, 0, 0);
                            this.m_cols.sendEvent(2002, n2, n - n2);
                        }
                        this.setColumnWidths();
                        this.deselectAll();
                        return;
                    }
                }
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public Object doCommand(TableCommandProp tableCommandProp) throws PropertyException {
        Object object = null;
        try {
            IAdminProp iAdminProp = tableCommandProp.getCommandProp();
            this.updateCmdSelection(iAdminProp);
            object = iAdminProp.getProp(4784643);
        }
        catch (Exception exception) {
            try {
                if (exception instanceof PropertyException) {
                    throw (PropertyException)exception;
                }
            }
            catch (ClassCastException classCastException) {}
            throw new PropertyException(exception);
        }
        return object;
    }

    void updateCmdSelection(IAdminProp iAdminProp) {
        int n;
        Object[] objectArray;
        IAdminProp[] iAdminPropArray = null;
        int[] nArray = null;
        if (this.m_sendSelectionNotification && iAdminProp == null) {
            nArray = this.getSelectedRows();
            if (nArray != null && nArray.length != 0 && (objectArray = this.m_data.getRows()) != null) {
                iAdminPropArray = new IAdminProp[nArray.length];
                n = 0;
                while (n < nArray.length) {
                    if (nArray[n] >= objectArray.length) {
                        iAdminPropArray = new IAdminProp[]{};
                        break;
                    }
                    iAdminPropArray[n] = (IAdminProp)objectArray[nArray[n]];
                    ++n;
                }
            }
            try {
                this.m_ap.setProp(273220105, iAdminPropArray);
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
            }
        }
        if (this._cmdList == null) {
            if (DEBUG) {
                System.out.println("Table.updateCmdSelection: _cmdList is null");
            }
            return;
        }
        if (nArray == null) {
            nArray = this.getSelectedRows();
        }
        try {
            if (nArray == null || nArray.length == 0) {
                if (DEBUG) {
                    System.out.println("Table.updateCmdSelection: nothing selected");
                }
                if (iAdminProp != null) {
                    iAdminProp.setProp(273220105, null);
                    return;
                }
                this.enableCommandList(0, false, null);
                return;
            }
            if (iAdminProp != null) {
                objectArray = this.m_data.getRows();
                if (objectArray != null) {
                    iAdminPropArray = new IAdminProp[nArray.length];
                    n = 0;
                    while (n < nArray.length) {
                        if (DEBUG) {
                            System.out.println("Table.updateCmdSelection: selected row=" + nArray[n]);
                        }
                        if (nArray[n] >= objectArray.length) {
                            iAdminPropArray = new IAdminProp[]{};
                            break;
                        }
                        iAdminPropArray[n] = (IAdminProp)objectArray[nArray[n]];
                        ++n;
                    }
                    iAdminProp.setProp(273220105, iAdminPropArray);
                    return;
                }
            } else {
                if (DEBUG) {
                    System.out.println("Table.updateCmdSelection: selected row count=" + nArray.length);
                }
                this.enableCommandList(nArray.length, false, nArray);
            }
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(exception);
            return;
        }
    }

    public void enableCommandList(int n, boolean bl, int[] nArray) {
        if (this._cmdList == null) {
            return;
        }
        IAdminProp[] iAdminPropArray = null;
        int n2 = 0;
        while (n2 < this._cmdList.length) {
            try {
                Integer n3 = (Integer)this._cmdList[n2].getProp(2687498);
                Integer n4 = (Integer)this._cmdList[n2].getProp(2687499);
                if (n3 != null || n4 != null) {
                    IAdminProp iAdminProp;
                    int n5;
                    int n6 = n3 == null ? -1 : n3;
                    int n7 = n5 = n4 == null ? -1 : n4;
                    if (DEBUG) {
                        System.out.println("Table.enableCommandList: min = " + n6);
                    }
                    if (DEBUG) {
                        System.out.println("Table.enableCommandList: max = " + n5);
                    }
                    if (!(n6 != -1 && n6 > n || n5 != -1 && n5 < n)) {
                        if (DEBUG) {
                            System.out.println("Table.enableCommandList: enable cmd = " + this._cmdList[n2]);
                        }
                        if (n > 0) {
                            Object[] objectArray;
                            iAdminProp = this._cmdList[n2];
                            if (iAdminPropArray == null && (objectArray = this.m_data.getRows()) != null) {
                                iAdminPropArray = new IAdminProp[nArray.length];
                                int n8 = 0;
                                while (n8 < nArray.length) {
                                    if (DEBUG) {
                                        System.out.println("Table.updateCmdSelection: selected row=" + nArray[n8]);
                                    }
                                    if (nArray[n8] >= objectArray.length) {
                                        iAdminPropArray = new IAdminProp[]{};
                                        break;
                                    }
                                    iAdminPropArray[n8] = (IAdminProp)objectArray[nArray[n8]];
                                    ++n8;
                                }
                            }
                            iAdminProp.setProp(273220105, iAdminPropArray);
                        }
                        this._cmdList[n2].setProp(8978948, Boolean.TRUE);
                    } else {
                        if (DEBUG) {
                            System.out.println("Table.enableCommandList: disable cmd = " + this._cmdList[n2]);
                        }
                        this._cmdList[n2].setProp(8978948, Boolean.FALSE);
                        iAdminProp = this._cmdList[n2];
                        iAdminProp.setProp(273220105, null);
                    }
                }
            }
            catch (Exception exception) {
                this.unexpectedException(exception);
            }
            ++n2;
        }
    }

    public void doSort() {
        if (!this.m_allowSort || this.m_colSorting == null || this.m_singleSortedColumn == null) {
            return;
        }
        int[] nArray = this.m_data.getColumns();
        int n = this.m_singleSortedColumnNum;
        if (nArray == null || nArray.length < n) {
            return;
        }
        if (!AdminSort.isPropSortable(nArray[n])) {
            return;
        }
        Integer n2 = (Integer)this.m_colSorting.get(this.m_singleSortedColumn);
        if (n2 != null && n2 != 2) {
            Object[] objectArray = this.m_data.getRows();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            Frame frame = this.getFrame();
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("doSort():  WAIT_CURSOR");
            }
            ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
            try {
                AdminSort.qsort((IAdminProp[])objectArray, nArray[n], n2 == 0);
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("doSort():  DEFAULT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            catch (Exception exception) {
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("doSort():  DEFAULT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
                return;
            }
        }
    }

    public void itemSelected(int n) {
        if (!this.m_allowSort) {
            return;
        }
        int[] nArray = this.m_data.getColumns();
        if (nArray == null || nArray.length < --n) {
            return;
        }
        try {
            if (!AdminSort.isPropSortable(nArray[n])) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        Frame frame = this.getFrame();
        if (NavigatorFrame.DEBUG_CURSOR) {
            System.out.println("itemSelected():  WAIT_CURSOR");
        }
        ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                String[] stringArray;
                block29: {
                    block28: {
                        stringArray = this.m_cols.getColumns();
                        if (stringArray == null) break block28;
                        if (stringArray.length >= n) break block29;
                    }
                    Object var5_6 = null;
                    if (NavigatorFrame.DEBUG_CURSOR) {
                        System.out.println("itemSelected():  DEFAULT_CURSOR");
                    }
                    ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (this.m_colSorting == null) {
                    this.m_colSorting = new Hashtable();
                }
                if (this.m_singleSortedColumn != null && !this.m_singleSortedColumn.equals(stringArray[n])) {
                    this.m_colSorting.remove(this.m_singleSortedColumn);
                    this.repaintHeaderItem(this.m_singleSortedColumnNum + 1);
                }
                Integer n2 = (Integer)this.m_colSorting.get(stringArray[n]);
                Object[] objectArray = this.m_data.getRows();
                if (n2 == null) {
                    n2 = new Integer(0);
                    this.m_colSorting.put(stringArray[n], n2);
                } else {
                    n2 = new Integer((n2 + 1) % 3);
                    this.m_colSorting.put(stringArray[n], n2);
                }
                if (n2 == 2) {
                    frame = this.getFrame();
                    this.m_data.refresh();
                } else if (n2 == 0) {
                    AdminSort.qsort((IAdminProp[])objectArray, nArray[n], n2 == 0);
                } else if (objectArray != null && objectArray.length != 0) {
                    int n3 = objectArray.length / 2;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object = objectArray[n4];
                        int n5 = objectArray.length - n4 - 1;
                        objectArray[n4] = objectArray[n5];
                        objectArray[n5] = object;
                        ++n4;
                    }
                }
                this.m_singleSortedColumn = stringArray[n];
                this.m_singleSortedColumnNum = n;
                this.deselectAllHeaders();
                this.m_data.repaint();
            }
            catch (Exception exception) {
                if (NavigatorFrame.DEBUG_CURSOR) {
                    System.out.println("itemSelected():  DEFAULT_CURSOR");
                }
                ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
                new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (NavigatorFrame.DEBUG_CURSOR) {
                System.out.println("itemSelected():  DEFAULT_CURSOR");
            }
            ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        Object var5_7 = null;
        if (NavigatorFrame.DEBUG_CURSOR) {
            System.out.println("itemSelected():  DEFAULT_CURSOR");
        }
        ((Component)frame).setCursor(Cursor.getPredefinedCursor(0));
    }

    Frame getFrame() {
        return AdminUtil.getFrame((Component)((Object)this));
    }

    public int getSortState(Object object) {
        if (this.m_singleSortedColumn == null || !this.m_singleSortedColumn.equals(object)) {
            return 2;
        }
        Integer n = (Integer)this.m_colSorting.get(object);
        if (n == null) {
            return 2;
        }
        return n;
    }

    public static Table configGrid(AdminGrid adminGrid, IAdminProp[] iAdminPropArray, IAdminProp iAdminProp) {
        AdminList adminList = new AdminList(iAdminPropArray);
        adminList.setSampleChild(iAdminProp);
        Table table = new Table(adminList, new TableData(adminList), new TableCols(adminList), new TableRows(adminList), adminGrid);
        return table;
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics;
        Font font;
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 10) {
            dimension.width = 200;
        }
        if (dimension.width > 600) {
            dimension.width = 600;
        }
        if (dimension.height > 800) {
            dimension.height = 600;
        }
        if (this.m_limitSize && dimension.height > 100 && (font = this.getFont()) != null && (fontMetrics = ((Component)((Object)this)).getFontMetrics(font)) != null && dimension.height > fontMetrics.getHeight() * 5) {
            dimension.height = fontMetrics.getHeight() * 4;
        }
        return dimension;
    }

    public String toString() {
        return this.m_ap.toString();
    }

    static {
        m_noSelection = new IAdminProp[0];
    }

    class trackButtonState
    implements AdminPropertyChangeListener {
        Hashtable m_map = new Hashtable();
        Vector m_aps = new Vector();

        public trackButtonState() {
            Table.this = Table.this;
        }

        public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
            try {
                while (true) {
                    switch (adminPropertyChangeEvent.getPropId()) {
                        case 8978948: {
                            AdminButton adminButton = (AdminButton)this.m_map.get(adminPropertyChangeEvent.getSource());
                            if (adminButton == null) break;
                            ((Component)((Object)adminButton)).setEnabled((Boolean)adminPropertyChangeEvent.getNewValue());
                            break;
                        }
                    }
                    if (!adminPropertyChangeEvent.hasMoreElements()) {
                        return;
                    }
                    adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        public void associate(IAdminProp iAdminProp, AdminButton adminButton) {
            iAdminProp.addAdminPropertyChangeListener(this);
            this.m_aps.addElement(iAdminProp);
            this.m_map.put(iAdminProp, adminButton);
        }

        public void shutdown() {
            int n = this.m_aps.size();
            int n2 = 0;
            while (n2 < n) {
                IAdminProp iAdminProp = (IAdminProp)this.m_aps.elementAt(n2);
                iAdminProp.removeAdminPropertyChangeListener(this);
                ++n2;
            }
        }
    }

    class TableCommandAdaptor
    extends AdminProp
    implements ICommandParent {
        Table m_table;

        public TableCommandAdaptor(Table table2) {
            Table.this = Table.this;
            this.m_table = table2;
        }

        public IAdminProp doCommand(IAdminProp iAdminProp) throws PropertyException {
            try {
                int n = (Integer)iAdminProp.getProp(2687496);
                switch (n) {
                    case -51: {
                        IAdminProp[] iAdminPropArray = (IAdminProp[])iAdminProp.getProp(273220105);
                        if (iAdminPropArray == null || iAdminPropArray.length == 0) {
                            return null;
                        }
                        return iAdminPropArray[0];
                    }
                    case -18: {
                        return new TableConfigFind(Table.this.m_ap, this.m_table, Table.this.m_data, Table.this.m_cols);
                    }
                    default: {
                        return null;
                    }
                }
            }
            catch (PropertyException propertyException) {
                throw propertyException;
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        }
    }
}

