/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.client.propEditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Vector;
import oracle.ldap.admin.client.AdminUtil;
import oracle.ldap.admin.client.EditorFactory;
import oracle.ldap.admin.client.EditorOwner;
import oracle.ldap.admin.client.ErrorAlert;
import oracle.ldap.admin.client.common.AdminFrame;
import oracle.ldap.admin.client.common.AdminLabel;
import oracle.ldap.admin.client.common.AdminPanel;
import oracle.ldap.admin.client.common.AdminWizard;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.client.propEditors.WizardViewPage;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;
import oracle.ldap.admin.help.AdminHelp;

public class WizardView
extends AdminWizard
implements IEditor,
AdminPropertyChangeListener {
    EditorOwner m_owner;
    IAdminProp[] m_apWizards;
    IAdminProp m_apWizard;
    IAdminProp m_ap;
    int wStatus;
    boolean isHelpAvailable = false;
    boolean canApply = false;
    Vector m_vPages = new Vector();
    IEditor[] m_ieditors;
    WizardViewPage currPage;
    WizardViewPage prevPage;
    int pageindx;
    int previndx;
    public static boolean DEBUG;

    public static Component createWizardView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        String string = null;
        WizardView wizardView = new WizardView(iAdminProp, editorOwner);
        try {
            string = (String)iAdminProp.getProp(1049730);
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        if (string == null) {
            string = "Untitled Wizard";
        }
        AdminFrame adminFrame = new AdminFrame(string);
        ((Component)((Object)adminFrame)).setSize(wizardView.getPreferredSize());
        ((Component)((Object)adminFrame)).setLocation(50, 50);
        ((Container)((Object)adminFrame)).add("Center", (Component)((Object)wizardView));
        return adminFrame;
    }

    public WizardView(IAdminProp iAdminProp, EditorOwner editorOwner) {
        ((Component)((Object)this)).setSize(800, 600);
        try {
            Integer n = null;
            n = (Integer)iAdminProp.getProp(2098305);
            this.wStatus = n != null ? n : 1;
            Boolean bl = null;
            bl = (Boolean)iAdminProp.getProp(8389763);
            this.isHelpAvailable = bl != null ? bl : false;
            Boolean bl2 = null;
            bl2 = (Boolean)iAdminProp.getProp(0x800484);
            this.canApply = bl2 != null ? bl2 : false;
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        if (this.isBaseWizard()) {
            this.initWizard(0, this.isHelpAvailable, this.canApply);
        } else {
            this.initWizard(1, this.isHelpAvailable, this.canApply);
        }
        this.m_ap = iAdminProp;
        this.m_owner = editorOwner;
        this.init(this.m_owner);
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 420);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private Image getImage(IAdminProp iAdminProp, Component component) {
        Image image;
        String string = null;
        try {
            string = (String)iAdminProp.getProp(1049733);
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        if (string == null) {
            string = "images/logonBkgrnd.gif";
        }
        if ((image = AdminUtil.loadImage(string, component)) != null && (image.getWidth(null) != 150 || image.getHeight(null) != 330)) {
            image = image.getScaledInstance(150, 330, 4);
        }
        ((Component)((Object)this)).repaint();
        return image;
    }

    private void init(EditorOwner editorOwner) {
        this.removeAllPages();
        this.m_vPages = new Vector();
        this.m_ieditors = null;
        try {
            if (this.hasAllPages()) {
                this.m_apWizards = (IAdminProp[])this.m_ap.getProp(272696448);
            } else {
                this.m_apWizard = (IAdminProp)this.m_ap.getProp(4195101);
            }
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
        if (this.m_apWizards != null & this.hasAllPages()) {
            int n = 0;
            while (n < this.m_apWizards.length) {
                IAdminProp iAdminProp = this.m_apWizards[n];
                WizardViewPage wizardViewPage = new WizardViewPage(iAdminProp, editorOwner);
                this.m_vPages.addElement(wizardViewPage);
                this.addPage((Container)((Object)wizardViewPage), this.getImage(iAdminProp, (Component)((Object)this)), wizardViewPage.getName());
                ++n;
            }
        } else {
            WizardViewPage wizardViewPage = new WizardViewPage(this.m_apWizard, editorOwner);
            this.m_vPages.addElement(wizardViewPage);
            this.addPage((Container)((Object)wizardViewPage), this.getImage((IAdminProp)wizardViewPage.getObject(), EditorFactory.getEditor(this.m_apWizard, editorOwner, true)), wizardViewPage.getName());
            if (wizardViewPage.getCanFinish()) {
                this.setMustFinish(false);
            } else {
                wizardViewPage = new WizardViewPage();
                this.addPage((Container)((Object)wizardViewPage), null, null);
                this.m_vPages.addElement(wizardViewPage);
            }
        }
        this.currPage = (WizardViewPage)this.m_vPages.elementAt(0);
        this.restart();
    }

    private boolean hasAllPages() {
        return (this.wStatus & 3) != 0;
    }

    private boolean isBaseWizard() {
        return (this.wStatus & 1) != 0;
    }

    private void replaceInteractiveArea(IAdminProp iAdminProp) {
        Image image = null;
        String string = null;
        IEditor iEditor = null;
        Object object = EditorFactory.getEditor(iAdminProp, null, true);
        if (object == null) {
            AdminPanel adminPanel = new AdminPanel();
            ((Container)((Object)adminPanel)).setLayout(new BorderLayout());
            ((Container)((Object)adminPanel)).add("Center", (Component)((Object)new AdminLabel("No Editor " + string + " javaclass=" + iAdminProp.getClass().getName())));
            object = adminPanel;
        } else {
            Component component = AdminUtil.removeScrollBox(object);
            if (component instanceof IEditor) {
                try {
                    iEditor = (IEditor)((Object)component);
                }
                catch (Exception exception) {
                    AdminProp.sUnexpectedException(exception);
                }
            }
        }
        try {
            image = this.getImage(iAdminProp, (Component)object);
            string = (String)iAdminProp.getProp(0x110001);
        }
        catch (PropertyException propertyException) {}
        this.refreshWizardPageContent((Container)object, image, string);
        this.setFinishBtn(iAdminProp);
    }

    private void setFinishBtn(IAdminProp iAdminProp) {
        try {
            Boolean bl = (Boolean)iAdminProp.getProp(8389766);
            if (bl != null) {
                this.setMustFinish(bl == false);
                return;
            }
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
        }
    }

    public void wizardViewSelectionChanged(Object object) {
        WizardViewPage wizardViewPage;
        IAdminProp iAdminProp;
        if (DEBUG) {
            System.out.println("SELECTION GetIndex() = " + this.getIndex());
            System.out.println("SELECTION pageindx = " + this.pageindx);
        }
        if (this.getIndex() < this.pageindx) {
            this.prevPage = (WizardViewPage)object;
            this.previndx = this.getIndex();
            iAdminProp = (IAdminProp)this.prevPage.getObject();
            if (DEBUG) {
                System.out.println("Previous page= " + this.prevPage.getName());
            }
            try {
                if (DEBUG) {
                    System.out.println("Display name of Previous page:" + iAdminProp.getProp(0x110001));
                }
            }
            catch (PropertyException propertyException) {}
            wizardViewPage = this.currPage;
            this.currPage = (WizardViewPage)object;
            this.pageindx = this.getIndex();
        } else {
            this.currPage = (WizardViewPage)object;
            this.pageindx = this.getIndex();
            iAdminProp = (IAdminProp)this.currPage.getObject();
            if (DEBUG) {
                System.out.println("Current page= " + this.currPage.getName());
            }
            if (this.currPage.getCanFinish()) {
                this.setMustFinish(false);
            }
            try {
                if (DEBUG) {
                    System.out.println("Display name of Current page:" + iAdminProp.getProp(0x110001));
                }
            }
            catch (PropertyException propertyException) {}
            wizardViewPage = this.prevPage;
        }
        if (wizardViewPage != null && wizardViewPage.isModified(null)) {
            wizardViewPage.commit();
        }
        while (wizardViewPage != null && wizardViewPage.isModified(null)) {
            this.selectPage(wizardViewPage);
        }
    }

    public void wizardViewApplyState() {
        this.commit();
    }

    public void wizardViewCanceled() {
        this.removeAllPages();
        AdminUtil.getFrame((Component)((Object)this)).dispose();
    }

    public boolean wizardViewFinished2() {
        if (!this.commit()) {
            return false;
        }
        IAdminProp iAdminProp = (IAdminProp)this.currPage.getObject();
        try {
            iAdminProp.setProp(4195355, null);
            this.removeAllPages();
            AdminUtil.getFrame((Component)((Object)this)).dispose();
            return true;
        }
        catch (PropertyException propertyException) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
            this.revert();
            return false;
        }
    }

    public boolean wizardViewValidatePage() {
        boolean bl = true;
        IAdminProp iAdminProp = null;
        if (this.prevPage != null) {
            iAdminProp = (IAdminProp)this.prevPage.getObject();
        } else if (this.currPage != null) {
            iAdminProp = (IAdminProp)this.currPage.getObject();
        }
        try {
            if (DEBUG) {
                System.out.println("Validating Page = " + iAdminProp.getProp(0x110001));
            }
            iAdminProp.setProp(4195354, null);
        }
        catch (PropertyException propertyException) {
            Toolkit.getDefaultToolkit().beep();
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), propertyException);
            return false;
        }
        if (this.prevPage != null && this.prevPage.isModified(null)) {
            IAdminProp iAdminProp2 = null;
            iAdminProp2 = (IAdminProp)((WizardViewPage)this.m_vPages.elementAt(this.previndx + 1)).getObject();
            try {
                iAdminProp2.setProp(8389407, null);
            }
            catch (PropertyException propertyException) {}
            int n = this.previndx + 1;
            while (n < this.getPageCount()) {
                if (DEBUG) {
                    System.out.println("Removing page " + n);
                }
                this.removePage((WizardViewPage)this.m_vPages.elementAt(n));
                this.m_vPages.removeElementAt(n);
                ++n;
            }
            bl = true;
            this.pageindx = this.getIndex() + 1;
        }
        this.prevPage = null;
        this.previndx = -1;
        return true;
    }

    public void wizardViewHelpRequested() {
        String string = null;
        String string2 = null;
        IAdminProp iAdminProp = (IAdminProp)this.currPage.getObject();
        try {
            string = (String)iAdminProp.getProp(1049370);
            string2 = (String)iAdminProp.getProp(1048745);
        }
        catch (PropertyException propertyException) {}
        if (string != null & string2 != null) {
            AdminHelp.showTopic(string2, string);
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            switch (adminPropertyChangeEvent.getPropId()) {
                case 272696448: {
                    this.removeAllPages();
                    this.init(this.m_owner);
                    AdminUtil.fixup((Component)((Object)this));
                }
            }
            if (!adminPropertyChangeEvent.hasMoreElements()) {
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public static IEditor[] vectorToIEditorArray(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return new IEditor[0];
        }
        Object[] objectArray = new IEditor[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public IEditor[] getWizardViewPages() {
        if (this.m_ieditors != null) {
            return this.m_ieditors;
        }
        this.m_ieditors = WizardView.vectorToIEditorArray(this.m_vPages);
        return this.m_ieditors;
    }

    public boolean displayObject(Object object) {
        return this.getObject() == object;
    }

    public Object getHelpObject() {
        return this.getObject();
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        return 262144;
    }

    public void setupToolbar(int n) {
    }

    public boolean isModified(StringBuffer stringBuffer) {
        IEditor[] iEditorArray = this.getWizardViewPages();
        int n = 0;
        while (n < iEditorArray.length) {
            if (iEditorArray[n].isModified(stringBuffer)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void revert() {
        IEditor[] iEditorArray = this.getWizardViewPages();
        int n = 0;
        while (n < iEditorArray.length) {
            iEditorArray[n].revert();
            ++n;
        }
    }

    public boolean commit() {
        IEditor[] iEditorArray = this.getWizardViewPages();
        boolean bl = true;
        int n = 0;
        while (n < iEditorArray.length) {
            if (iEditorArray[n].isModified(null) && !iEditorArray[n].commit()) {
                bl = false;
            }
            ++n;
        }
        try {
            this.m_ap.saveChanges(0);
        }
        catch (Exception exception) {
            new ErrorAlert(AdminUtil.getFrame((Component)((Object)this)), exception);
            bl = false;
        }
        return bl;
    }

    public void update() {
        IEditor[] iEditorArray = this.getWizardViewPages();
        int n = 0;
        while (n < iEditorArray.length) {
            iEditorArray[n].update();
            ++n;
        }
    }

    public IAdminProp[] getCommandList() {
        return null;
    }

    public IAdminProp properties() {
        return null;
    }

    public void shutdown() {
        IEditor[] iEditorArray = this.getWizardViewPages();
        int n = 0;
        while (n < iEditorArray.length) {
            iEditorArray[n].shutdown();
            ++n;
        }
    }
}

