/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import java.awt.Image;
import oracle.ewt.event.ListenerManager;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.AdminPropertyChangeEvent;
import oracle.ldap.admin.common.AdminPropertyChangeListener;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.ICommandParent;
import oracle.ldap.admin.common.PropertyException;

public class CommandProp
extends AdminProp
implements AdminPropertyChangeListener {
    public static final int CMD_BUTTON = 1;
    public static final int CMD_CHECKBUTTON = 2;
    public static final int CMD_RADIOBUTTON = 4;
    public static final int CMD_SEPARATOR = 8;
    public static final int CMD_SPINBOX = 16;
    public static final int CMD_GROUP = 32;
    public static final int CMD_MENU = 64;
    private static CommandProp _separator;
    IAdminProp _parent;
    int _cmdID;
    String _name;
    String _description = "";
    Image _icon;
    int _type;
    boolean _enabled = true;
    boolean _cmdActive = true;
    boolean _selected = false;
    boolean _modal = false;
    int _status;
    IAdminProp _subCmd;
    int _loRange;
    int _hiRange;
    Object _value;
    CommandProp[] _list;
    ListenerManager _listeners;
    String _mnemonic;
    String m_iconName;
    SelectionEnableFilter m_selectFilter;

    public CommandProp() {
    }

    public CommandProp(IAdminProp iAdminProp, String string, int n) {
        this(iAdminProp, 0, string, "", n);
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2, int n2) {
        this.setParent(iAdminProp);
        this.setCmdID(n);
        this.setName(string);
        this.setDescription(string2);
        this.setType(n2);
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2, int n2, Image image) {
        this(iAdminProp, n, string, string2, n2);
        this.setIcon(image);
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2, int n2, String string3) {
        this(iAdminProp, n, string, string2, n2);
        this.m_iconName = string3;
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2) {
        this(iAdminProp, n, string, string2, 1);
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2, String string3) {
        this(iAdminProp, n, string, string2, 1);
        this.m_iconName = string3;
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2, String string3, Image image) {
        this(iAdminProp, n, string, string2, 1);
        this.m_iconName = string3;
        this.setIcon(image);
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2, String string3, int n2, int n3) {
        this(iAdminProp, n, string, string2, 1);
        this.m_iconName = string3;
        try {
            if (n2 > 0) {
                this.setProp(2687498, (Object)new Integer(n2));
            }
            if (n3 > 0) {
                this.setProp(2687499, (Object)new Integer(n3));
                return;
            }
        }
        catch (Exception exception) {}
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2, char c) {
        this(iAdminProp, n, string, string2, 1);
        this.setMnemonic(String.valueOf(c));
    }

    public CommandProp(IAdminProp iAdminProp, int n, String string, String string2, String string3, char c) {
        this(iAdminProp, n, string, string2, 1);
        this.m_iconName = string3;
        this.setMnemonic(String.valueOf(c));
    }

    public void registerMessages() {
        super.registerMessages();
        this.registerProp(2687495, "Type", "");
        this.registerProp(0x110001, "Name", "");
        this.registerProp(1638408, "Icon", "");
        this.registerProp(1638914, "Description", "");
        this.registerProp(8978948, "Enabled", "");
        this.registerProp(8978957, "Active", "");
        this.registerProp(8978949, "Selected", "");
        this.registerProp(8978950, "Modal", "");
        this.registerProp(2687496, "Id", "");
        this.registerProp(2687504, "Min Selection", "");
        this.registerProp(2687505, "Max Selection", "");
        this.registerProp(2687509, "Status", "");
    }

    public String getIconName() {
        return this.m_iconName;
    }

    public void setIconName(String string) {
        this.m_iconName = string;
    }

    public Object getProp(int n) throws PropertyException {
        if (this._subCmd != null) {
            switch (n) {
                case 0x110001: 
                case 1638408: 
                case 1638914: 
                case 1639168: 
                case 2687504: 
                case 2687505: 
                case 2687509: 
                case 7929864: 
                case 7930386: 
                case 8978950: 
                case 273613322: {
                    return this._subCmd.getProp(n);
                }
            }
        }
        switch (n) {
            case 3080204: {
                return new Integer(8192);
            }
            case 282001422: {
                int[] nArray = new int[]{2687495, 0x110001, 1638408, 1638914, 8978948, 8978957, 8978949, 8978950, 2687496, 2687504, 2687505, 2687509};
                return nArray;
            }
            case 2031768: {
                return "Command";
            }
            case 4784130: {
                return this.getParent();
            }
            case 2687495: {
                return this.getType();
            }
            case 0x110001: {
                return this.getName();
            }
            case 7929864: {
                return this.getIcon();
            }
            case 1638408: {
                return this.getIconName();
            }
            case 1638914: {
                return this.getDescription();
            }
            case 4784643: {
                if (this.isType(2) || this.isType(4)) {
                    this.setProp(8978949, (Object)(!this.isSelected() ? Boolean.TRUE : Boolean.FALSE));
                }
                return this.run();
            }
            case 8978948: {
                return this.getEnabled();
            }
            case 8978957: {
                return this.getCmdActive();
            }
            case 8978949: {
                return this.getSelected();
            }
            case 8978950: {
                return this.getModal();
            }
            case 2687496: {
                return this.getCmdID();
            }
            case 2687504: {
                return this.getCmdLoRange();
            }
            case 2687505: {
                return this.getCmdHiRange();
            }
            case 7930386: {
                return this.getCmdValue();
            }
            case 273613322: {
                return this.getMenuCmdList();
            }
            case 2687509: {
                return this.getStatus();
            }
            case 4784659: {
                return this.getSubCmd();
            }
            case 2032137: {
                return this.getMnemonic();
            }
        }
        return super.getProp(n);
    }

    public void setProp(int n, Object object) throws PropertyException {
        switch (n) {
            case 4784130: {
                this.setParent((IAdminProp)object);
                break;
            }
            case 2687495: {
                this.setType((Integer)object);
                break;
            }
            case 0x110001: {
                this.setName((String)object);
                break;
            }
            case 7929864: {
                this.setIcon((Image)object);
                break;
            }
            case 1638408: {
                this.setIconName((String)object);
                break;
            }
            case 1638914: {
                this.setDescription((String)object);
                break;
            }
            case 4784643: {
                throw new PropertyException("CommandProp::setProp called on readonly property PR_RUN_RESULT", 1, n, null);
            }
            case 8978948: {
                this.setEnabled((Boolean)object);
                break;
            }
            case 8978957: {
                this.setCmdActive((Boolean)object);
                break;
            }
            case 8978949: {
                this.setSelected((Boolean)object);
                break;
            }
            case 8978950: {
                this.setModal((Boolean)object);
                break;
            }
            case 2687496: {
                this.setCmdID((Integer)object);
                break;
            }
            case 2687504: {
                this.setCmdLoRange((Integer)object);
                break;
            }
            case 2687505: {
                this.setCmdHiRange((Integer)object);
                break;
            }
            case 7930386: {
                this.setCmdValue(object);
                break;
            }
            case 273613322: {
                this.setMenuCmdList((CommandProp[])object);
                break;
            }
            case 4784659: {
                this.setSubCmd((IAdminProp)object);
                break;
            }
            case 2687509: {
                this.setStatus((Integer)object);
                break;
            }
            case 273220105: {
                if (this.m_selectFilter != null) {
                    if (this.m_selectFilter.enableOnSelection(object, this)) {
                        if (!this.getEnabled().booleanValue()) {
                            this.setEnabled(true);
                            this.sendAdminPropertyChangeEvents(8978948, Boolean.TRUE);
                        }
                    } else if (this.getEnabled().booleanValue()) {
                        this.setEnabled(false);
                        this.sendAdminPropertyChangeEvents(8978948, Boolean.FALSE);
                    }
                }
                super.setProp(n, object);
                return;
            }
            case 2032137: {
                this.setMnemonic((String)object);
                return;
            }
            default: {
                super.setProp(n, object);
                return;
            }
        }
        this.sendAdminPropertyChangeEvents(n, object);
    }

    protected IAdminProp run() throws PropertyException {
        IAdminProp iAdminProp = this.getSubCmd();
        if (iAdminProp != null) {
            return (IAdminProp)iAdminProp.getProp(4784643);
        }
        if (this.getParent() instanceof ICommandParent) {
            return ((ICommandParent)((Object)this.getParent())).doCommand(this);
        }
        return null;
    }

    public Integer getType() {
        return new Integer(this._type);
    }

    public void setType(int n) {
        this._type = n;
    }

    public boolean isType(int n) {
        return this._type == n;
    }

    public Boolean getEnabled() {
        return new Boolean(this._enabled);
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public Boolean getCmdActive() {
        return new Boolean(this._cmdActive);
    }

    public void setCmdActive(boolean bl) {
        this._cmdActive = bl;
    }

    public void setSelected(boolean bl) {
        this._selected = bl;
    }

    public Boolean getSelected() {
        return new Boolean(this._selected);
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setModal(boolean bl) {
        this._modal = bl;
    }

    public Boolean getModal() {
        return new Boolean(this._modal);
    }

    public IAdminProp getParent() {
        return this._parent;
    }

    public void setParent(IAdminProp iAdminProp) {
        this._parent = iAdminProp;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public Image getIcon() {
        return this._icon;
    }

    public void setIcon(Image image) {
        this._icon = image;
    }

    public Integer getCmdID() {
        return new Integer(this._cmdID);
    }

    public void setCmdID(int n) {
        this._cmdID = n;
    }

    public Integer getCmdLoRange() {
        return new Integer(this._loRange);
    }

    public void setCmdLoRange(int n) {
        this._loRange = n;
    }

    public Integer getCmdHiRange() {
        return new Integer(this._hiRange);
    }

    public void setCmdHiRange(int n) {
        this._hiRange = n;
    }

    public Object getCmdValue() {
        return this._value;
    }

    public void setCmdValue(Object object) {
        this._value = object;
    }

    public CommandProp[] getMenuCmdList() {
        return this._list;
    }

    public void setMenuCmdList(CommandProp[] commandPropArray) {
        this._list = commandPropArray;
    }

    public Integer getStatus() {
        return new Integer(this._status);
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public void setMnemonic(String string) {
        this._mnemonic = string;
    }

    public String getMnemonic() {
        return this._mnemonic;
    }

    public IAdminProp getSubCmd() {
        return this._subCmd;
    }

    public void setSubCmd(IAdminProp iAdminProp) {
        if (iAdminProp != null && this._subCmd == iAdminProp) {
            return;
        }
        if (this._subCmd != null) {
            this._subCmd.removeAdminPropertyChangeListener(this);
        }
        this._subCmd = iAdminProp;
        if (this._subCmd != null) {
            this._subCmd.addAdminPropertyChangeListener(this);
        }
        try {
            this.sendAdminPropertyChangeEvents(8978948, this.getProp(8978948));
            this.sendAdminPropertyChangeEvents(0x110001, this.getProp(0x110001));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addAdminPropertyChangeListener(AdminPropertyChangeListener adminPropertyChangeListener) {
        super.addAdminPropertyChangeListener(adminPropertyChangeListener);
        IAdminProp iAdminProp = this.getSubCmd();
        if (iAdminProp != null) {
            iAdminProp.addAdminPropertyChangeListener(adminPropertyChangeListener);
        }
    }

    public void adminPropertyChange(AdminPropertyChangeEvent adminPropertyChangeEvent) {
        while (true) {
            block7: {
                IAdminProp iAdminProp = (IAdminProp)adminPropertyChangeEvent.getSource();
                try {
                    int n = adminPropertyChangeEvent.getPropId();
                    switch (n) {
                        case 0x110001: 
                        case 1638408: 
                        case 7929864: 
                        case 8978948: 
                        case 8978950: 
                        case 8978957: {
                            this.setProp(n, iAdminProp.getProp(n));
                            break;
                        }
                        default: {
                            if (adminPropertyChangeEvent.hasMoreElements()) break block7;
                        }
                    }
                }
                catch (Exception exception) {
                    this.unexpectedException(exception);
                }
                if (adminPropertyChangeEvent.hasMoreElements()) break block7;
                return;
            }
            adminPropertyChangeEvent = (AdminPropertyChangeEvent)adminPropertyChangeEvent.nextElement();
        }
    }

    public static CommandProp getSeparator() {
        if (_separator == null) {
            _separator = new CommandProp();
        }
        return _separator;
    }

    public void setSelectionEnableFilter(SelectionEnableFilter selectionEnableFilter) {
        this.m_selectFilter = selectionEnableFilter;
    }

    public interface SelectionEnableFilter {
        public boolean enableOnSelection(Object var1, Object var2);
    }
}

