/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import com.visigenic.vbroker.ObjLocation.Agent;
import com.visigenic.vbroker.ObjLocation.AgentHelper;
import com.visigenic.vbroker.ObjLocation.Desc;
import java.util.Hashtable;
import java.util.Properties;
import oracle.ldap.admin.common.IAdminServer;
import oracle.ldap.admin.common.IAdminServerHelper;
import oracle.ldap.admin.common.ICoordinator;
import oracle.ldap.admin.common._ICoordinatorImplBase;
import org.omg.CORBA.BOA;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

public class Coordinator
extends _ICoordinatorImplBase
implements ICoordinator {
    public Agent locAgent;
    public String[] serverList;

    public void init() {
        try {
            ORB oRB = ORB.init();
            oRB.BOA_init();
            try {
                Object object = oRB.resolve_initial_references("LocationService");
                if (object == null || (this.locAgent = AgentHelper.narrow((Object)object)) == null) {
                    System.err.println("make sure location server is up ");
                    System.exit(1);
                }
                return;
            }
            catch (InvalidName invalidName) {
                System.out.println("Not able to resolve references for LocationService");
                System.exit(1);
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
            return;
        }
    }

    public Coordinator(String string) {
        super(string);
        this.init();
    }

    public String[] getServerAddresses() {
        String string = "IDL:oracle/ldap/admin/common/IAdminServer:1.0";
        try {
            Object[] objectArray = this.locAgent.all_instances(string);
            Desc[] descArray = this.locAgent.all_instances_descs(string);
            System.out.println("Agent returned " + objectArray.length + " object references");
            if (objectArray.length > 0) {
                this.serverList = new String[objectArray.length];
            }
            int n = 0;
            while (n < objectArray.length) {
                System.out.println("Stringified IOR for account #" + (n + 1) + ":");
                IAdminServer iAdminServer = IAdminServerHelper.narrow(objectArray[n]);
                try {
                    this.serverList[n] = new String(String.valueOf(descArray[n].agent_hostname) + ":" + descArray[n].instance_name + ":" + iAdminServer.getWorkload().toString());
                }
                catch (Exception exception) {
                    System.out.println("Server is down...");
                    this.serverList[n] = new String(":::");
                }
                System.out.println(this.serverList[n]);
                ++n;
            }
            if (this.serverList == null) {
                this.serverList = new String[1];
                this.serverList[0] = new String(":::");
            }
            return this.serverList;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("ORBservices", "com.visigenic.vbroker.ObjLocation");
            ORB oRB = ORB.init((String[])stringArray, (Properties)properties);
            BOA bOA = oRB.BOA_init();
            Coordinator coordinator = new Coordinator("Coordinator");
            bOA.obj_is_ready((Object)coordinator);
            bOA.impl_is_ready();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }
}

