/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;

public class PropertyException
extends Exception
implements Enumeration {
    protected int m_type;
    protected int m_property;
    protected Object m_value;
    protected PropertyException m_next;
    public static final int CANNOT_WRITE_ERROR = 1;
    public static final int CANNOT_READ_ERROR = 2;
    public static final int CANNOT_DELETE_ERROR = 3;
    public static final int INVALID_CHANGE_ERROR = 4;
    public static final int DUPLICATE_VALUE_ERROR = 5;
    public static final int NOT_CONNECTED_ERROR = 6;
    String m_title;
    Exception m_e;
    int T_ERROR = 1;
    int T_WARNING = 2;
    int T_NOTICE = 3;
    int T_REMINDER = 4;
    int type = this.T_ERROR;
    boolean bWarning = false;
    boolean bNotice = false;
    boolean bReminder = false;

    public PropertyException(String string, int n, int n2, Object object) {
        super(string);
        this.m_type = n;
        this.m_property = n2;
        this.m_value = object;
        this.m_next = null;
    }

    public PropertyException(String string) {
        this(string, 0, 0, null);
    }

    public PropertyException(String string, int n) {
        this(string, n, 0, null);
    }

    public PropertyException(String string, String string2) {
        this(string2, 0, 0, null);
        this.m_title = string;
    }

    public String getTitle() {
        return this.m_title;
    }

    public PropertyException(Exception exception) {
        super(exception.getMessage());
        this.m_e = exception;
    }

    public Exception getRealException() {
        return this.m_e;
    }

    public void printStackTrace() {
        if (this.m_e != null) {
            this.m_e.printStackTrace();
            System.err.println("");
        }
        super.printStackTrace();
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.m_e != null) {
            this.m_e.printStackTrace(printWriter);
            printWriter.println("-------------------------");
        }
        super.printStackTrace(printWriter);
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.m_e != null) {
            this.m_e.printStackTrace(printStream);
            printStream.println("-------------------------");
        }
        super.printStackTrace(printStream);
    }

    public int GetType() {
        return this.m_type;
    }

    public int getProperty() {
        return this.m_property;
    }

    public Object GetValue() {
        return this.m_value;
    }

    public PropertyException GetNext() {
        return this.m_next;
    }

    public void SetNext(PropertyException propertyException) {
        this.m_next = propertyException;
    }

    public boolean hasMoreElements() {
        return this.GetNext() != null;
    }

    public Object nextElement() {
        return this.GetNext();
    }

    public boolean isError() {
        return this.type == this.T_ERROR || this.m_next != null && this.m_next.isError();
    }

    public void setError() {
        this.type = this.T_ERROR;
    }

    public boolean isWarning() {
        return this.type == this.T_WARNING || this.m_next != null && this.m_next.isWarning();
    }

    public void setWarning() {
        this.type = this.T_WARNING;
    }

    public boolean isNotice() {
        return this.type == this.T_NOTICE || this.m_next != null && this.m_next.isNotice();
    }

    public void setNotice() {
        this.type = this.T_NOTICE;
    }

    public boolean isReminder() {
        return this.type == this.T_REMINDER || this.m_next != null && this.m_next.isReminder();
    }

    public void setReminder() {
        this.type = this.T_REMINDER;
    }
}

