/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.Date;

class ProxyLog {
    static final int LOG_MASK = 255;
    static final int LOG_OPERATION = 1;
    static final int LOG_CACHE = 2;
    static final int LOG_GARB_COLL = 4;
    static final int LOG_EXCEPTION = 8;
    static final int LOG_NEXTLINE = 16;
    private static boolean m_nextline;
    private int m_mask;
    private File m_outputFile;
    private RandomAccessFile m_raf;

    public void open(String string) {
        try {
            this.m_outputFile = new File(string);
            this.m_raf = new RandomAccessFile(this.m_outputFile, "rw");
            this.m_raf.seek(this.m_raf.length());
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
    }

    public void close() {
        try {
            if (this.m_raf != null) {
                this.m_raf.close();
                return;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void turnOff() {
        this.m_mask = 0;
    }

    public void turnOnOper() {
        this.m_mask |= 1;
    }

    public void turnOnCache() {
        this.m_mask |= 2;
    }

    public void turnOnCarbColl() {
        this.m_mask |= 4;
    }

    public void turnOnExcep() {
        this.m_mask |= 8;
    }

    public void put(int n, String string) {
        String string2;
        new String("");
        if (this.m_raf == null) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                string2 = this.genOutputMsg(n, string);
                if (string2 != null) break;
                return;
            }
            case 16: {
                if (this.isNextLineOn()) {
                    string2 = "    " + string + "\n";
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        try {
            this.m_raf.writeBytes(string2);
            return;
        }
        catch (IOException iOException) {
            System.out.println("caught IOException: " + iOException.getMessage());
            return;
        }
    }

    private String getExecLocation() {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Exception().printStackTrace(printWriter);
        String string = stringWriter.toString();
        int n2 = string.indexOf("at ") + 3;
        if (n2 >= 0 && (n2 = string.indexOf("at ", n2) + 3) >= 0 && (n2 = string.indexOf("at ", n2) + 3) >= 0 && (n2 = string.indexOf("at ", n2) + 3) >= 0 && (n = string.indexOf("\n", n2)) >= 0) {
            return string.substring(n2, n);
        }
        return new String("");
    }

    private String genOutputMsg(int n, String string) {
        Date date = new Date();
        String string2 = null;
        if ((this.m_mask & n) != 0) {
            String string3 = new String("");
            switch (n) {
                case 1: {
                    string3 = new String("OPERATION at: ");
                    break;
                }
                case 2: {
                    string3 = new String("CACHE at: ");
                    break;
                }
                case 4: {
                    string3 = new String("GARBAGE COLLECTION at: ");
                    break;
                }
                case 8: {
                    string3 = new String("EXCEPTION at: ");
                    break;
                }
            }
            String string4 = new String(String.valueOf(string3) + this.getExecLocation());
            string2 = String.valueOf(date.toString()) + ": " + string4 + "\n    " + string + "\n";
            this.turnOnNextLine();
        } else {
            this.turnOffNextLine();
        }
        return string2;
    }

    private void turnOnNextLine() {
        m_nextline = true;
    }

    private void turnOffNextLine() {
        m_nextline = false;
    }

    private boolean isNextLineOn() {
        return m_nextline;
    }
}

