/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Vector;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.common.PropertyException;

public class Util
extends AdminProp {
    public static int getChildListProperty(Integer n) {
        int n2 = n;
        if ((n2 & 0x100000) != 0 || (n2 & 0x200000) != 0) {
            return 273612805;
        }
        if ((n2 & 0x40) != 0 || (n2 & 0x100) != 0) {
            return 273219601;
        }
        if ((n2 & 0x1000) != 0) {
            return 272695330;
        }
        if ((n2 & 0x20000) != 0) {
            return 272630384;
        }
        if ((n2 & 0x8000) != 0) {
            return 272630352;
        }
        if ((n2 & 0x400) != 0) {
            return 272695365;
        }
        if ((n2 & 0x200) != 0 || (n2 & 0x10000) != 0) {
            return 272630786;
        }
        if ((n2 & 0x40000) != 0) {
            return 272696448;
        }
        return -1;
    }

    public static String debugPropIdToString(int n) {
        AdminProp adminProp = new AdminProp();
        return adminProp.getPropName(n);
    }

    public static boolean isMember(int[] nArray, int n) {
        if (nArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean vectorContains(Vector vector, Object object) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) == object) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int vectorIndexOf(Vector vector, Object object) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) == object) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static boolean vectorContainsIgnoreCase(Vector vector, String string) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase((String)vector.elementAt(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void subtract(Vector vector, Vector vector2) {
        int n;
        int n2 = vector != null ? vector.size() : 0;
        int n3 = n = vector2 != null ? vector2.size() : 0;
        if (n2 >= n) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = vector.indexOf(vector2.elementAt(n4));
                if (n5 >= 0) {
                    vector.removeElementAt(n5);
                }
                ++n4;
            }
            return;
        }
        int n6 = 0;
        while (n6 < n2) {
            if (vector2.contains(vector.elementAt(n6))) {
                vector.removeElementAt(n6--);
                --n2;
            }
            ++n6;
        }
    }

    public static void intersect(Vector vector, Vector vector2) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (!vector2.contains(vector.elementAt(n2))) {
                vector.removeElementAt(n2--);
                --n;
            }
            ++n2;
        }
    }

    public static void union(Vector vector, Vector vector2) {
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(vector2.elementAt(n2));
            ++n2;
        }
    }

    public static int compareToIgnoreCase(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = n2 < (n = string2.length()) ? n2 : n;
        int n4 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = Character.toLowerCase(string.charAt(n4));
            if (c2 != (c = Character.toLowerCase(string2.charAt(n4)))) {
                return c2 - c;
            }
            ++n4;
        }
        return n2 - n;
    }

    public static int addSortedCmp(Object object, Object object2) {
        if (object instanceof String && object2 instanceof String) {
            return Util.compareToIgnoreCase((String)object, (String)object2);
        }
        if (object instanceof Integer && object2 instanceof Integer) {
            return (Integer)object - (Integer)object2;
        }
        if (object instanceof Double && object2 instanceof Double) {
            double d = (Double)object - (Double)object2;
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return 0;
        }
        if (object instanceof Date && object2 instanceof Date) {
            if (((Date)object).after((Date)object2)) {
                return 1;
            }
            if (((Date)object).before((Date)object2)) {
                return -1;
            }
            return 0;
        }
        if (object instanceof IAdminProp && object2 instanceof IAdminProp) {
            try {
                return Util.addSortedCmp(((IAdminProp)object).getProp(0x110001), ((IAdminProp)object2).getProp(0x110001));
            }
            catch (PropertyException propertyException) {
                AdminProp.sUnexpectedException(propertyException);
            }
        }
        return 1;
    }

    public static void addSorted(Vector vector, IAdminProp iAdminProp, int n) {
        Object object = null;
        int n2 = vector.size();
        try {
            object = iAdminProp.getProp(n);
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            vector.addElement(iAdminProp);
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            block6: {
                IAdminProp iAdminProp2 = (IAdminProp)vector.elementAt(n3);
                Object object2 = null;
                try {
                    object2 = iAdminProp2.getProp(n);
                }
                catch (PropertyException propertyException) {
                    AdminProp.sUnexpectedException(propertyException);
                    break block6;
                }
                if (object2 != null && Util.addSortedCmp(object2, object) >= 0) {
                    vector.insertElementAt(iAdminProp, n3);
                    return;
                }
            }
            ++n3;
        }
        vector.addElement(iAdminProp);
    }

    public static void addSorted(Vector vector, IAdminProp iAdminProp) {
        Util.addSorted(vector, iAdminProp, 0x110001);
    }

    public static int count(Vector vector, int n, Object object, int n2) {
        if (vector == null) {
            return 0;
        }
        int n3 = 0;
        int n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            if (n3 >= n2) break;
            IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n5);
            if (Util.keyEqualsValue(iAdminProp, object, n)) {
                ++n3;
            }
            ++n5;
        }
        return n3;
    }

    public static Object[] findObjects(Vector vector, int n, Object object) {
        if (vector == null) {
            return new Object[0];
        }
        Vector<IAdminProp> vector2 = new Vector<IAdminProp>();
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n3);
            if (Util.keyEqualsValue(iAdminProp, object, n)) {
                vector2.addElement(iAdminProp);
            }
            ++n3;
        }
        return Util.vectorToObjectArray(vector2);
    }

    public static Object[] findObjects(IAdminProp[] iAdminPropArray, int n, Object object) {
        if (iAdminPropArray == null) {
            return new Object[0];
        }
        Vector<IAdminProp> vector = new Vector<IAdminProp>();
        int n2 = 0;
        while (n2 < iAdminPropArray.length) {
            IAdminProp iAdminProp = iAdminPropArray[n2];
            if (Util.keyEqualsValue(iAdminProp, object, n)) {
                vector.addElement(iAdminProp);
            }
            ++n2;
        }
        return Util.vectorToObjectArray(vector);
    }

    public static Object findObject(Vector vector, int n, Object object) {
        if (vector == null) {
            return null;
        }
        Vector vector2 = vector;
        synchronized (vector2) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                IAdminProp iAdminProp = (IAdminProp)vector.elementAt(n3);
                if (Util.keyEqualsValue(iAdminProp, object, n)) {
                    IAdminProp iAdminProp2 = iAdminProp;
                    Object var5_8 = null;
                    return iAdminProp2;
                }
                ++n3;
            }
        }
        return null;
    }

    public static Object findObject(IAdminProp[] iAdminPropArray, int n, Object object) {
        if (iAdminPropArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < iAdminPropArray.length) {
            IAdminProp iAdminProp = iAdminPropArray[n2];
            if (Util.keyEqualsValue(iAdminProp, object, n)) {
                return iAdminProp;
            }
            ++n2;
        }
        return null;
    }

    static boolean keyEqualsValue(IAdminProp iAdminProp, Object object, int n) {
        Object object2;
        try {
            object2 = iAdminProp.getProp(n);
        }
        catch (PropertyException propertyException) {
            AdminProp.sUnexpectedException(propertyException);
            return false;
        }
        if (object2 != null && object instanceof String && AdminProp.isPropArray(n)) {
            String[] stringArray = (String[])object2;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equalsIgnoreCase((String)object)) {
                    return true;
                }
                ++n2;
            }
        }
        if (object2 instanceof String && object instanceof String) {
            return ((String)object2).equalsIgnoreCase((String)object);
        }
        return object2 != null && object2.equals(object);
    }

    public static Vector objectArrayToVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    public static Object[] vectorToObjectArray(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        if (vector.elementAt(0) instanceof AdminProp) {
            Object[] objectArray = new AdminProp[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (vector.elementAt(0) instanceof IAdminProp) {
            Object[] objectArray = new IAdminProp[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] vectorToStringArray(Vector vector) {
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Object[] cloneAdminPropArray(AdminProp[] adminPropArray) {
        if (adminPropArray == null || adminPropArray.length == 0) {
            return null;
        }
        Object[] objectArray = new Object[adminPropArray.length];
        int n = 0;
        while (n < adminPropArray.length) {
            objectArray[n] = adminPropArray[n];
            ++n;
        }
        return objectArray;
    }

    public static void backup(String string) throws PropertyException {
        Object object;
        File file = new File(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (file.exists()) {
            try {
                object = Runtime.getRuntime().exec("cp " + string + " " + string + ".bak");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append("\n");
                    string2 = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                throw new PropertyException(exception);
            }
        }
        if (stringBuffer.length() != 0) {
            object = new PropertyException(stringBuffer.toString());
            ((PropertyException)object).setNotice();
            throw object;
        }
    }

    public static void copy(String string, String string2) throws PropertyException {
        Object object;
        new File(string);
        new File(string2);
        StringBuffer stringBuffer = new StringBuffer();
        Util.backup(string2);
        try {
            object = Runtime.getRuntime().exec("cp " + string + " " + string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuffer.append(string3);
                stringBuffer.append("\n");
                string3 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            throw new PropertyException(exception);
        }
        if (stringBuffer.length() != 0) {
            object = new PropertyException(stringBuffer.toString());
            ((PropertyException)object).setNotice();
            throw object;
        }
    }
}

