/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.admin.oemclient;

import oracle.ldap.admin.client.propEditors.GridView;
import oracle.ldap.admin.client.propEditors.IEditor;
import oracle.ldap.admin.common.AdminProp;
import oracle.ldap.admin.common.IAdminProp;
import oracle.ldap.admin.oemclient.MyClient;
import oracle.ldap.admin.oemclient.MyPropertyPage;
import oracle.ldap.admin.oemclient.MyPropertySheet;
import oracle.sysman.emSDK.adminObj.client.ClientObject;
import oracle.sysman.emSDK.adminObj.client.GuiObject;
import oracle.sysman.emSDK.adminObj.client.PropertyPage;
import oracle.sysman.emSDK.adminObj.client.PropertySheet;
import oracle.sysman.emSDK.client.appContainer.ImageLoader;

public class MyObject
extends GuiObject
implements IEditor {
    private IAdminProp m_ap;
    private IAdminProp[] m_tabObjList;
    public boolean m_initiallyModified = false;
    MyPropertyPage[] m_pages;

    public MyObject(IAdminProp iAdminProp) {
        super((ClientObject)new MyClient());
        this.m_ap = GridView.doTransforms(iAdminProp);
        this.checkModifiedStatus();
    }

    public String getDisplayName() {
        try {
            return (String)this.m_ap.getProp(0x110001);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getNumPages() {
        try {
            if (this.m_tabObjList != null) {
                if (this.m_pages == null) {
                    this.m_pages = new MyPropertyPage[this.m_tabObjList.length];
                }
                return this.m_tabObjList.length;
            }
            int n = (Integer)this.m_ap.getProp(3080204);
            if ((n & 0x1000) != 0) {
                this.m_tabObjList = (IAdminProp[])this.m_ap.getProp(272695330);
                if (this.m_tabObjList != null) {
                    if (this.m_pages == null) {
                        this.m_pages = new MyPropertyPage[this.m_tabObjList.length];
                    }
                    return this.m_tabObjList.length;
                }
            }
        }
        catch (Exception exception) {}
        if (this.m_pages == null) {
            this.m_pages = new MyPropertyPage[1];
        }
        return 1;
    }

    public PropertyPage createPageAt(int n) {
        if (this.m_pages[n] != null) {
            return this.m_pages[n];
        }
        if (this.m_tabObjList == null) {
            this.m_pages[n] = new MyPropertyPage(this.m_ap);
            return this.m_pages[n];
        }
        this.m_pages[n] = new MyPropertyPage(this.m_tabObjList[n], this.m_initiallyModified);
        return this.m_pages[n];
    }

    protected boolean arePagesResizable() {
        return true;
    }

    public PropertySheet createPropertySheet(ImageLoader imageLoader) {
        return new MyPropertySheet(imageLoader, this.m_ap, this);
    }

    protected boolean isModifiable() {
        try {
            int n = (Integer)this.m_ap.getProp(2686979);
            if ((n & 2) == 0) {
                return false;
            }
        }
        catch (Exception exception) {}
        return true;
    }

    public boolean displayObject(Object object) {
        return false;
    }

    public Object getHelpObject() {
        return this.m_ap;
    }

    public Object getObject() {
        return this.m_ap;
    }

    public boolean isModified(StringBuffer stringBuffer) {
        if (this.m_pages == null) {
            return false;
        }
        int n = 0;
        while (n < this.m_pages.length) {
            if (this.m_pages[n] != null && this.m_pages[n].isModified2(stringBuffer)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void revert() {
        if (this.m_pages == null) {
            return;
        }
        int n = 0;
        while (n < this.m_pages.length) {
            this.m_pages[n].revert();
            ++n;
        }
    }

    public boolean commit() {
        if (this.m_pages == null) {
            return true;
        }
        int n = 0;
        while (n < this.m_pages.length) {
            if (!this.m_pages[n].commit()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void update() {
        if (this.m_pages == null) {
            return;
        }
        int n = 0;
        while (n < this.m_pages.length) {
            this.m_pages[n].update();
            ++n;
        }
    }

    public void shutdown() {
        if (this.m_pages == null) {
            return;
        }
        int n = 0;
        while (n < this.m_pages.length) {
            this.m_pages[n].shutdown();
            ++n;
        }
    }

    public IAdminProp properties() {
        return null;
    }

    public boolean setObject(Object object) {
        return false;
    }

    public int getEditorType() {
        if (this.m_tabObjList == null) {
            return 8192;
        }
        return 4096;
    }

    public void setupToolbar(int n) {
        int n2 = 0;
        while (n2 < this.m_pages.length) {
            this.m_pages[n2].setupToolbar(n);
            ++n2;
        }
    }

    public IAdminProp[] getCommandList() {
        return null;
    }

    public String[] getHelpBookNTopic() {
        System.out.println("MyObject.getHelpBookNTopic()");
        return super.getHelpBookNTopic();
    }

    public void checkModifiedStatus() {
        try {
            Integer n = (Integer)this.m_ap.getProp(3080204);
            if (n != null && (n & 2) != 0) {
                this.m_initiallyModified = true;
                return;
            }
        }
        catch (Exception exception) {
            AdminProp.sUnexpectedException(exception);
        }
    }
}

