/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;

public class AQDequeueOption {
    public static final int NAVIGATION_FIRST_MESSAGE = 1;
    public static final int NAVIGATION_NEXT_TRANSACTION = 2;
    public static final int NAVIGATION_NEXT_MESSAGE = 3;
    public static final int DEQUEUE_BROWSE = 1;
    public static final int DEQUEUE_LOCKED = 2;
    public static final int DEQUEUE_REMOVE = 3;
    public static final int DEQUEUE_REMOVE_NODATA = 4;
    public static final int WAIT_FOREVER = -1;
    public static final int WAIT_NONE = 0;
    public static final int VISIBILITY_ONCOMMIT = 2;
    public static final int VISIBILITY_IMMEDIATE = 1;
    static final int DEFAULT_DEQUEUE_MODE = 3;
    static final int DEFAULT_NAVIGATION_MODE = 3;
    static final int DEFAULT_WAIT_TIME = -1;
    static final int DEFAULT_VISIBILITY = 2;
    private String consumer = null;
    private int deq_mode = 3;
    private int navig_mode = 3;
    private int visib = 2;
    private int wait = -1;
    private byte[] msgid = null;
    private String corr = null;

    public String getConsumerName() throws AQException {
        return this.consumer;
    }

    public String getCorrelation() throws AQException {
        return this.corr;
    }

    public int getDequeueMode() throws AQException {
        return this.deq_mode;
    }

    public byte[] getMessageId() throws AQException {
        return this.msgid;
    }

    public int getNavigationMode() throws AQException {
        return this.navig_mode;
    }

    public int getVisibility() throws AQException {
        return this.visib;
    }

    public int getWaitTime() throws AQException {
        return this.wait;
    }

    public void setConsumerName(String consumer_name) throws AQException {
        this.consumer = consumer_name;
    }

    public void setCorrelation(String correlation) throws AQException {
        this.corr = correlation;
    }

    public void setDequeueMode(int dequeue_mode) throws AQException {
        if (dequeue_mode != 1 && dequeue_mode != 2 && dequeue_mode != 3 && dequeue_mode != 4) {
            throw new AQException(0, "Invaild dequeue mode");
        }
        this.deq_mode = dequeue_mode;
    }

    public void setMessageId(byte[] message_id) throws AQException {
        this.msgid = message_id;
    }

    public void setNavigationMode(int navigation) throws AQException {
        if (navigation != 1 && navigation != 3 && navigation != 2) {
            throw new AQException(0, "Invalid navigation mode");
        }
        this.navig_mode = navigation;
    }

    public void setVisibility(int visibility) throws AQException {
        if (visibility != 1 && visibility != 2) {
            throw new AQException(0, "Invalid value for visibility");
        }
        this.visib = visibility;
    }

    public void setWaitTime(int wait_time) throws AQException {
        if (wait_time == -1 || wait_time == 0) {
            this.wait = wait_time;
        } else if (wait_time > 0) {
            this.wait = wait_time;
        } else {
            throw new AQException(0, "Invalid value for wait_time");
        }
    }
}

