/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;
import oracle.AQ.AQRawPayload;
import oracle.AQ.AQUtil;

public class AQOracleRawPayload
implements AQRawPayload {
    private byte[] data;
    private int length;

    public AQOracleRawPayload() {
        this.data = new byte[100];
        this.length = 100;
    }

    public AQOracleRawPayload(byte[] raw_data, int len) {
        this.data = raw_data;
        this.length = len;
    }

    public byte[] getBytes() throws AQException {
        int i = 0;
        byte[] value = null;
        value = new byte[this.length];
        i = 0;
        while (i < this.length) {
            value[i] = this.data[i];
            ++i;
        }
        return value;
    }

    public int getLength() {
        return this.length;
    }

    public int getStream(byte[] value, int len) throws AQException {
        int i = 0;
        int read_len = len;
        if (value.length < len) {
            AQUtil.throwAQEx(189);
        }
        if (read_len > this.length) {
            read_len = this.length;
        }
        i = 0;
        while (i < read_len) {
            value[i] = this.data[i];
            ++i;
        }
        return read_len;
    }

    public void setStream(byte[] value, int len) throws AQException {
        int i = 0;
        if (len > this.data.length) {
            this.data = new byte[len];
        }
        i = 0;
        while (i < len) {
            this.data[i] = value[i];
            ++i;
        }
        this.length = len;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.data == null || this.length == 0) {
            buf.append("Data  :  <Empty byte array!>");
        } else {
            int n = this.length;
            buf.append("Length:  " + this.length);
            buf.append("Data  :  ");
            int i = 0;
            while (i < n) {
                int v = this.data[i] & 0xFF;
                if (v < 16) {
                    buf.append("0" + Integer.toHexString(v));
                } else {
                    buf.append(Integer.toHexString(v));
                }
                ++i;
            }
        }
        return buf.toString();
    }
}

