/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropDatum;
import oracle.jms.AdtMessage;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class AQjmsAdtMessage
extends AQjmsMessage
implements AdtMessage {
    CustomDatum adt_payload;

    AQjmsAdtMessage(CustomDatum payload) throws JMSException {
        this.message_id = null;
        this.enqueue_time = null;
        this.msg_dest = null;
        this.del_mode = 2;
        this.corr_id = "";
        this.redelivered = false;
        this.expiration = 0L;
        this.priority = 1;
        this.msg_properties = null;
        this.access_mode = 2;
        this.prop_read_only = false;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.header_ext = null;
        this.adt_payload = payload;
    }

    public void clearBody() throws JMSException {
        this.adt_payload = null;
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    public CustomDatum getAdtPayload() throws JMSException {
        return this.adt_payload;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return false;
        }
        try {
            if (name.startsWith("JMS", 0)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        String str = (String)value;
                        return Boolean.valueOf(str);
                    }
                    return ((Datum)value).booleanValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return false;
        }
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return 0;
        }
        try {
            if (name.startsWith("JMS", 0)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        String str = (String)value;
                        return Byte.parseByte(str);
                    }
                    return ((Datum)value).byteValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0;
        }
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return 0.0;
        }
        try {
            if (name.startsWith("JMS", 0)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return Double.valueOf((String)value);
                    }
                    return ((Datum)value).doubleValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0.0;
        }
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return 0.0f;
        }
        try {
            if (name.startsWith("JMS", 0)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return Float.valueOf((String)value).floatValue();
                    }
                    return ((Datum)value).floatValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0.0f;
        }
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return 0;
        }
        try {
            if (name.startsWith("JMS", 0)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return Integer.parseInt((String)value);
                    }
                    return ((Datum)value).intValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0;
        }
    }

    public Destination getJMSReplyTo() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public String getJMSType() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return 0L;
        }
        try {
            if (name.startsWith("JMS", 0)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return Long.parseLong((String)value);
                    }
                    return ((Datum)value).longValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0L;
        }
    }

    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    public Object getObjectProperty(String name) throws JMSException {
        block12: {
            Object prop_datum = null;
            Object value = null;
            boolean java_type = false;
            if (name == null) {
                AQjmsError.throwEx(139);
            } else {
                try {
                    if (name.startsWith("JMS", 0)) {
                        value = this.getSystemProperty(name);
                        if (value != null) {
                            if (name.equals("JMSXRecvTimestamp")) {
                                return new Long(((Datum)value).longValue());
                            }
                            if (name.equals("JMSXState")) {
                                return new Integer(((Datum)value).intValue());
                            }
                            if (name.equals("JMS_OracleExcpQ")) {
                                return value;
                            }
                            if (name.equals("JMS_OracleDelay")) {
                                return new Integer(((Datum)value).intValue());
                            }
                            if (name.equals("JMS_OracleOriginalMessageID")) {
                                return value;
                            }
                            if (name.equals("JMSXDeliveryCount")) {
                                return new Integer(((Datum)value).intValue());
                            }
                            break block12;
                        }
                        return null;
                    }
                    return null;
                }
                catch (SQLException sQLException) {
                    AQjmsError.throwMsgFormatEx(161, null);
                }
            }
        }
        return null;
    }

    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    public synchronized Enumeration getPropertyNames() throws JMSException {
        Hashtable<String, AQjmsPropDatum> prop_ht = null;
        Enumeration prop_enum = null;
        AQjmsPropDatum prop_datum = null;
        Object key = null;
        prop_datum = new AQjmsPropDatum(27, null);
        prop_ht = new Hashtable<String, AQjmsPropDatum>();
        prop_ht.put("JMSXRecvTimestamp", prop_datum);
        prop_ht.put("JMSXState", prop_datum);
        prop_ht.put("JMSXDeliveryCount", prop_datum);
        prop_ht.put("JMS_OracleExcpQ", prop_datum);
        prop_ht.put("JMS_OracleDelay", prop_datum);
        prop_ht.put("JMS_OracleOriginalMessageID", prop_datum);
        prop_enum = prop_ht.keys();
        return prop_enum;
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = null;
        Class<?> cl = null;
        try {
            cl = Class.forName("oracle.sql.NUMBER");
        }
        catch (Exception ex) {
            AQjmsError.throwEx(109, ex);
            return 0;
        }
        if (name == null) {
            AQjmsError.throwEx(139);
            return 0;
        }
        try {
            if (name.startsWith("JMS", 0)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return Short.parseShort((String)value);
                    }
                    if (cl.isInstance(value)) {
                        return ((NUMBER)value).shortValue();
                    }
                    throw new NullPointerException();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0;
        }
    }

    public String getStringProperty(String name) throws JMSException {
        Object value = null;
        if (name == null) {
            AQjmsError.throwEx(139);
            return null;
        }
        try {
            if (name.startsWith("JMS", 0)) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (value instanceof String) {
                        return (String)value;
                    }
                    return ((Datum)value).stringValue();
                }
                return null;
            }
            return null;
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    Object getSystemProperty(String name) throws SQLException {
        void var2_10;
        Object var2_2 = null;
        Object str_value = null;
        boolean num_value = false;
        AQjmsOracleDebug.trace(4, "AQjmsAdtMessage.setSystemProperty", "entry");
        if (!name.startsWith("JMS", 0)) {
            AQjmsOracleDebug.trace(5, "AQjmsAdtMessage.setSystemProperty", "name does not start with JMS, returning null");
            return null;
        }
        if (name.equals("JMSXUserID")) {
            return null;
        }
        if (name.equals("JMSXAppID")) {
            return null;
        }
        if (name.equals("JMSXDeliveryCount")) {
            NUMBER nUMBER = new NUMBER(this.attempts);
        } else {
            if (name.equals("JMSXGroupID")) {
                return null;
            }
            if (name.equals("JMSXGroupSeq")) {
                return null;
            }
            if (name.equals("JMSXProducerTXID")) {
                return null;
            }
            if (name.equals("JMSXConsumerTXID")) {
                return null;
            }
            if (name.equals("JMSXRecvTimestamp")) {
                NUMBER nUMBER = new NUMBER(this.recv_time);
            } else if (name.equals("JMSXState")) {
                NUMBER nUMBER = new NUMBER(this.msg_state);
            } else if (name.equals("JMS_OracleExcpQ")) {
                String string = this.excp_queue;
            } else if (name.equals("JMS_OracleDelay")) {
                NUMBER nUMBER = new NUMBER(this.msg_delay);
            } else {
                if (!name.equals("JMS_OracleOriginalMessageID")) {
                    AQjmsOracleDebug.trace(5, "AQjmsAdtMessage.setSystemProperty", "returning null");
                    return null;
                }
                if (this.orig_msg_id == null) {
                    Object var2_8 = null;
                } else {
                    String string = "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
                }
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsAdtMessage.setSystemProperty", "exit");
        return var2_10;
    }

    public boolean propertyExists(String name) throws JMSException {
        boolean exists = false;
        if (name.startsWith("JMS", 0)) {
            return name.equals("JMSXRecvTimestamp") || name.equals("JMSXState") || name.equals("JMSXDeliveryCount") || name.equals("JMS_OracleExcpQ") || name.equals("JMS_OracleDelay") || name.equals("JMS_OracleOriginalMessageID");
        }
        return false;
    }

    public void setAdtPayload(CustomDatum payload) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            this.adt_payload = payload;
        }
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (name.startsWith("JMS", 0)) {
                NUMBER new_value = new NUMBER(value);
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (name.startsWith("JMS", 0)) {
                NUMBER new_value = new NUMBER(value);
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (!name.startsWith("JMS", 0)) {
                AQjmsError.throwEx(150);
                throw new AQjmsException("User properties not supported on ADT messages", 0);
            }
            NUMBER new_value = new NUMBER(value);
            this.setSystemProperty(name, new_value);
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (!name.startsWith("JMS", 0)) {
                AQjmsError.throwEx(150);
                throw new AQjmsException("User properties not supported on ADT messages", 0);
            }
            NUMBER new_value = new NUMBER(value);
            this.setSystemProperty(name, new_value);
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (name.startsWith("JMS", 0)) {
                NUMBER new_value = new NUMBER(value);
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119);
            throw new AQjmsException("Could not set property value", 0, sql_ex);
        }
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        AQjmsError.throwEx(102);
    }

    public void setJMSType(String type) throws JMSException {
        AQjmsError.throwEx(102);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (name.startsWith("JMS", 0)) {
                NUMBER new_value = new NUMBER(value);
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        if (value == null) {
            AQjmsError.throwMsgFormatEx(119, null);
        }
        if (value instanceof Boolean) {
            this.setBooleanProperty(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByteProperty(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShortProperty(name, (Short)value);
        } else if (value instanceof Integer) {
            this.setIntProperty(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLongProperty(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDoubleProperty(name, (Double)value);
        } else if (value instanceof String) {
            this.setStringProperty(name, (String)value);
        } else {
            AQjmsError.throwMsgFormatEx(119, null);
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (name.startsWith("JMS", 0)) {
                NUMBER new_value = new NUMBER(value);
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyValue(name, value);
        try {
            if (name.startsWith("JMS", 0)) {
                this.setSystemProperty(name, value);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, sql_ex);
        }
    }

    void setSystemProperty(String name, Object value) throws JMSException, SQLException {
        if (name.startsWith("JMS", 0)) {
            if (name.equals("JMSXUserID")) {
                AQjmsError.throwEx(150);
            } else if (name.equals("JMSXAppID")) {
                AQjmsError.throwEx(150);
            } else if (name.equals("JMSXDeliveryCount")) {
                AQjmsError.throwEx(110, "JMSXDeliveryCount");
            } else if (name.equals("JMSXGroupID")) {
                AQjmsError.throwEx(150);
            } else if (name.equals("JMSXGroupSeq")) {
                AQjmsError.throwEx(150);
            } else if (name.equals("JMSXProducerTXID")) {
                AQjmsError.throwEx(150);
            } else if (name.equals("JMSXConsumerTXID")) {
                AQjmsError.throwEx(150);
            } else if (name.equals("JMSXRecvTimestamp")) {
                AQjmsError.throwEx(110, "JMSXRecvTimestamp");
            } else if (name.equals("JMSXState")) {
                AQjmsError.throwEx(110, "JMSXState");
            } else if (name.equals("JMS_OracleExcpQ")) {
                if (value instanceof String) {
                    this.excp_queue = (String)value;
                } else {
                    AQjmsError.throwEx(153);
                }
            } else if (name.equals("JMS_OracleDelay")) {
                if (value instanceof NUMBER) {
                    this.msg_delay = ((Datum)value).intValue();
                } else {
                    AQjmsError.throwEx(153);
                }
            } else if (name.equals("JMS_OracleOriginalMessageID")) {
                AQjmsError.throwEx(110, "JMS_OracleOriginalMessageID");
            } else {
                AQjmsError.throwEx(140);
            }
        } else {
            AQjmsError.throwEx(140);
        }
    }
}

