/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import oracle.jdbc.driver.OracleConnection;
import oracle.jms.AQjmsConnectionMetaData;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsEventListener;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;

public class AQjmsConnection
implements QueueConnection,
TopicConnection {
    String hostname;
    String oracle_sid;
    int portno;
    String user;
    Connection db_conn;
    String driver;
    String client_id;
    int conn_type;
    boolean started;
    AQjmsConnectionMetaData metadata;
    String connect_str;
    Session jms_sess_open;
    boolean opened_new_conn;
    volatile boolean close_in_progress;
    AQjmsEventListener eventListener;

    AQjmsConnection(String hostname, String oracle_sid, int portno, String username, String password, String jdbc_driver, int type) throws JMSException {
        this.hostname = hostname;
        this.oracle_sid = oracle_sid;
        this.portno = portno;
        this.driver = jdbc_driver;
        this.user = username;
        if (type == 10 || type == 20) {
            this.conn_type = type;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            this.db_conn = AQjmsConnection.connect(hostname, oracle_sid, portno, this.driver, username, password);
            this.db_conn.setAutoCommit(false);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection constructor", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        catch (ClassNotFoundException cl_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor - ClassNotFound", cl_ex);
            AQjmsError.throwEx(109, cl_ex);
        }
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.opened_new_conn = true;
        this.jms_sess_open = null;
        this.close_in_progress = false;
        this.driver = ((OracleConnection)this.db_conn).getProtocolType();
    }

    AQjmsConnection(String url, String username, String password, int type) throws JMSException {
        if (type == 10 || type == 20) {
            this.conn_type = type;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.db_conn = DriverManager.getConnection(url, username, password);
            this.db_conn.setAutoCommit(false);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor url un/ps", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        catch (ClassNotFoundException cl_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor url un/ps CNF", cl_ex);
            AQjmsError.throwEx(109, cl_ex);
        }
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.opened_new_conn = true;
        this.jms_sess_open = null;
        this.close_in_progress = false;
        this.driver = ((OracleConnection)this.db_conn).getProtocolType();
        try {
            if (this.db_conn != null) {
                this.user = ((OracleConnection)this.db_conn).getUserName();
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection constructor url no_user", sql_ex);
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsConnection(String url, Properties info, int type) throws JMSException {
        if (type == 10 || type == 20) {
            this.conn_type = type;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.db_conn = info != null ? DriverManager.getConnection(url, info) : DriverManager.getConnection(url);
            this.db_conn.setAutoCommit(false);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor url", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        catch (ClassNotFoundException cl_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor url CNF", cl_ex);
            AQjmsError.throwEx(109, cl_ex);
        }
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.opened_new_conn = true;
        this.jms_sess_open = null;
        this.close_in_progress = false;
        this.driver = ((OracleConnection)this.db_conn).getProtocolType();
        try {
            if (this.db_conn != null) {
                this.user = ((OracleConnection)this.db_conn).getUserName();
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection constructor url no_user", sql_ex);
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsConnection(Connection db_connection, int type) throws JMSException {
        Class<?> cl = null;
        if (type == 10 || type == 20) {
            this.conn_type = type;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            cl = Class.forName("oracle.jdbc.driver.OracleConnection");
        }
        catch (Exception exception) {
            AQjmsError.throwEx(109);
        }
        try {
            if (db_connection == null) {
                AQjmsError.throwEx(111);
            } else if (cl.isInstance(db_connection)) {
                this.db_conn = db_connection;
            } else {
                AQjmsError.throwEx(112);
            }
            if (!((OracleConnection)this.db_conn).getUsingXAFlag()) {
                this.db_conn.setAutoCommit(false);
            }
            this.user = ((OracleConnection)this.db_conn).getUserName();
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor db_conn", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.opened_new_conn = false;
        this.jms_sess_open = null;
        this.close_in_progress = false;
        this.driver = ((OracleConnection)this.db_conn).getProtocolType();
    }

    synchronized void clearJmsSession() {
        this.jms_sess_open = null;
    }

    public void close() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsConnectionn.close", "closing connection");
        this.close_in_progress = true;
        this.closeConnectionResources();
        AQjmsOracleDebug.trace(5, "AQjmsConnection.close", "connection closed");
    }

    synchronized void closeConnectionResources() {
        try {
            try {
                if (this.eventListener != null) {
                    AQjmsOracleDebug.trace(3, "AQjmsConnection.closeConnectionResources", "calling stop event listener");
                    this.eventListener.stopAQjmsEventListener();
                    this.eventListener = null;
                }
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsConnection.closeConnectionResources-ex", ex);
                this.eventListener = null;
            }
            try {
                if (this.jms_sess_open != null) {
                    this.jms_sess_open.close();
                    this.jms_sess_open = null;
                }
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsConnection.closeConnectionResources-ex", ex);
                this.jms_sess_open = null;
            }
            if (this.opened_new_conn && this.db_conn != null) {
                this.db_conn.close();
            }
            AQjmsOracleDebug.trace(5, "AQjmsConnection.closeConnectionResources", "Connection closed");
            this.db_conn = null;
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection.closeConnectionResources-sqlex", sql_ex);
        }
    }

    private static Connection connect(String host, String sid, int port, String driver, String username, String passwd) throws SQLException, ClassNotFoundException, JMSException {
        String url;
        Class.forName("oracle.jdbc.driver.OracleDriver");
        if (driver.equals("oci8")) {
            url = new String("jdbc:oracle:oci8:");
            url = url.concat("@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(PORT=" + port);
            url = url.concat(")(HOST=" + host + "))(CONNECT_DATA=(SID=" + sid + ")))");
        } else if (driver.equals("thin")) {
            url = new String("jdbc:oracle:thin:");
            url = url.concat("@" + host + ":" + port + ":" + sid);
        } else {
            AQjmsError.throwEx(135);
            throw new AQjmsException("unsupported driver", 0);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection.connect", "Connect as : " + username + ":" + passwd);
        return DriverManager.getConnection(url, username, passwd);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    synchronized AQjmsEventListener createEventListener() throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.startEventListener", "enter");
        if (this.eventListener == null) {
            this.eventListener = new AQjmsEventListener("oracle.jms.AQjmsHttpRcv", 1024);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createEventListener", "start");
        AQjmsOracleDebug.trace(3, "AQjmsSession.createEventListener", "exit");
        return this.eventListener;
    }

    public QueueSession createQueueSession(boolean transacted, int ack_mode) throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwEx(114);
        }
        if (this.getJmsSession() != null) {
            AQjmsError.throwEx(106);
        }
        if (!transacted) {
            AQjmsError.throwEx(102);
        }
        AQjmsSession aq_sess = new AQjmsSession(this, ack_mode, transacted, 10);
        this.setJmsSession((Session)aq_sess);
        return aq_sess;
    }

    public TopicSession createTopicSession(boolean transacted, int ack_mode) throws JMSException {
        AQjmsSession aq_sess = null;
        if (this.isConnectionClosed()) {
            AQjmsError.throwEx(114);
        }
        if (this.getJmsSession() != null) {
            AQjmsError.throwEx(106);
        }
        if (!transacted) {
            AQjmsError.throwEx(102);
        }
        aq_sess = new AQjmsSession(this, ack_mode, transacted, 20);
        this.setJmsSession((Session)aq_sess);
        return aq_sess;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {}
    }

    public String getClientID() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwEx(114);
        }
        return this.user;
    }

    public Session getCurrentJmsSession() {
        return this.jms_sess_open;
    }

    Connection getDBConnection() {
        return this.db_conn;
    }

    String getDriver() {
        return this.driver;
    }

    AQjmsEventListener getEventListener() {
        return this.eventListener;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    Session getJmsSession() {
        return this.jms_sess_open;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwEx(114);
        }
        return this.metadata;
    }

    boolean isConnectionClosed() {
        boolean closed;
        block6: {
            closed = false;
            if (this.close_in_progress) {
                return true;
            }
            if (this.db_conn != null) {
                try {
                    if (!this.db_conn.isClosed()) {
                        closed = false;
                        break block6;
                    }
                    closed = true;
                }
                catch (Exception exception) {
                    closed = true;
                }
            } else {
                closed = true;
            }
        }
        return closed;
    }

    boolean isConnectionStarted() throws JMSException {
        return this.isConnectionClosed() ^ true;
    }

    public void setClientID(String clientID) throws JMSException {
        AQjmsError.throwEx(102);
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        AQjmsError.throwEx(102);
    }

    synchronized void setJmsSession(Session curr_session) throws JMSException {
        if (this.jms_sess_open != null) {
            AQjmsError.throwEx(106);
        } else {
            this.jms_sess_open = curr_session;
        }
    }

    public synchronized void start() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwEx(114);
        }
        if (this.started) {
            return;
        }
        if (this.eventListener != null) {
            this.eventListener.startAQjmsEventListener();
        }
        this.started = true;
    }

    public synchronized void stop() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwEx(114);
        }
        if (!this.started) {
            return;
        }
        if (this.eventListener != null) {
            this.eventListener.stopAQjmsEventListener();
        }
        this.started = false;
    }
}

