/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQQueueProperty;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;

public class AQjmsDestination
implements Queue,
Topic {
    private int type;
    private String owner;
    private String name;
    private String table;
    private int pload_type;
    private String p_data_type;
    private AQjmsDestinationProperty property;
    private Hashtable dest_properties;

    AQjmsDestination(String owner, String name, int dest_type, int payload_type, String adt_type, String table) throws JMSException {
        this.owner = owner;
        this.name = name;
        this.type = dest_type;
        this.p_data_type = payload_type == 2 ? null : adt_type;
        this.property = new AQjmsDestinationProperty();
        this.table = table;
    }

    AQjmsDestination(String owner, String name, int dest_type, int payload_type, String adt_type, AQjmsDestinationProperty dest_property, String table) throws JMSException {
        this.owner = owner;
        this.name = name;
        this.type = dest_type;
        this.p_data_type = payload_type == 2 ? null : adt_type;
        this.property = dest_property;
        this.table = table;
    }

    public void alter(Session session, AQjmsDestinationProperty dest_property) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.alterQueue(dest_property);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void alterPropagationSchedule(Session session, String destination, Double duration, String next_time, Double latency) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.alterPropagationSchedule(destination, duration, next_time, latency);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void disablePropagationSchedule(Session session, String destination) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.disablePropagationSchedule(destination);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void drop(Session session) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.drop();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void enablePropagationSchedule(Session session, String destination) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.enablePropagationSchedule(destination);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    String getAdtType() {
        return this.p_data_type;
    }

    public String getCompleteName() {
        String ret = null;
        ret = this.owner != null && !this.owner.equals("") ? String.valueOf(this.owner) + "." + this.name : this.name;
        return ret;
    }

    public String getCompleteTableName() {
        String ret = null;
        ret = this.owner != null && !this.owner.equals("") ? String.valueOf(this.owner) + "." + this.table : this.table;
        return ret;
    }

    public String getQueueName() throws JMSException {
        if (this.type == 10) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    public String getQueueOwner() throws JMSException {
        return this.owner;
    }

    String getQueueTableName() {
        return this.table;
    }

    public String getTopicName() throws JMSException {
        if (this.type == 20) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    public String getTopicOwner() throws JMSException {
        return this.owner;
    }

    public void grantQueuePrivilege(Session session, String privilege, String grantee, boolean grant_option) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.grantQueuePrivilege(privilege, grantee, grant_option);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void grantTopicPrivilege(Session session, String privilege, String grantee, boolean grant_option) throws JMSException {
        this.grantQueuePrivilege(session, privilege, grantee, grant_option);
    }

    boolean isQueue() {
        return this.type == 10;
    }

    boolean isTopic() {
        return this.type == 20;
    }

    public void revokeQueuePrivilege(Session session, String privilege, String grantee) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.revokeQueuePrivilege(privilege, grantee);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void revokeTopicPrivilege(Session session, String privilege, String grantee) throws JMSException {
        this.revokeQueuePrivilege(session, privilege, grantee);
    }

    public void schedulePropagation(Session session, String destination, Date start_time, Double duration, String next_time, Double latency) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.schedulePropagation(destination, start_time, duration, next_time, latency);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void start(Session session, boolean enqueue, boolean dequeue) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.start(enqueue, dequeue);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void stop(Session session, boolean enqueue, boolean dequeue, boolean wait) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.stop(enqueue, dequeue, wait);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public String toString() {
        String ret = null;
        ret = this.owner != null && !this.owner.equals("") ? String.valueOf(this.owner) + "." + this.name : this.name;
        return ret;
    }

    public void unschedulePropagation(Session session, String destination) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type);
            aq_queue.unschedulePropagation(destination);
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }
}

