/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.sql.BLOB;
import oracle.sql.CustomDatumFactory;

public class AQjmsObjectMessage
extends AQjmsMessage
implements ObjectMessage {
    AQjmsObjectMessage_C obj_msg_cont;
    Serializable serial_obj;

    AQjmsObjectMessage() throws JMSException {
        this.serial_obj = null;
        try {
            this.obj_msg_cont = new AQjmsObjectMessage_C();
            this.obj_msg_cont.setHeader(this.header_ext);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "Constructor", sql_ex);
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsObjectMessage(AQjmsObjectMessage_C msg_cont) throws JMSException {
        this.serial_obj = null;
        try {
            this.obj_msg_cont = msg_cont;
            this.header_ext = msg_cont.getHeader();
            this.readObjectMessageContainer();
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container", sql_ex);
            throw new AQjmsException(sql_ex);
        }
    }

    AQjmsObjectMessage(byte[] bdata) throws JMSException {
        this.serial_obj = AQjmsObjectMessage.convertByteArrayToSerializable(bdata);
    }

    public void clearBody() throws JMSException {
        this.serial_obj = null;
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        AQjmsOracleDebug.println("ObjectMessage.clearprop-1");
        try {
            if (this.obj_msg_cont != null) {
                this.obj_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.println("Message.clearprop-ex-2" + sql_ex);
            throw new AQjmsException(sql_ex);
        }
    }

    static Serializable convertByteArrayToSerializable(byte[] in_byte_array) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "entry");
        try {
            ByteArrayInputStream baistream = new ByteArrayInputStream(in_byte_array);
            ObjectInputStream oistream = new ObjectInputStream(baistream);
            Serializable s_obj = (Serializable)oistream.readObject();
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "exit");
            return s_obj;
        }
        catch (ClassNotFoundException cnf_exp) {
            AQjmsError.throwEx(109, cnf_exp.getMessage());
        }
        catch (InvalidClassException ic_exp) {
            AQjmsError.throwEx(109, ic_exp.getMessage());
        }
        catch (IOException io_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsObjectMessage.ioexp-2", io_exp);
            AQjmsError.throwEx(157, io_exp.getMessage());
        }
        return null;
    }

    static byte[] convertSerializableToByteArray(Serializable s_obj) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertSerializableToByteArray", "entry");
        try {
            ByteArrayOutputStream baostream = new ByteArrayOutputStream();
            ObjectOutputStream oostream = new ObjectOutputStream(baostream);
            oostream.writeObject(s_obj);
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertSerializableToByteArray", "exit");
            return baostream.toByteArray();
        }
        catch (IOException io_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsObjectMessage.ioexp-1", io_exp);
            AQjmsError.throwEx(157, io_exp.getMessage());
            return null;
        }
    }

    AQjmsObjectMessage_C getMessageCont() {
        return this.obj_msg_cont;
    }

    public Serializable getObject() throws JMSException {
        return this.serial_obj;
    }

    public byte[] getSerialObject() throws JMSException {
        Serializable s = this.getObject();
        return AQjmsObjectMessage.convertSerializableToByteArray(s);
    }

    void populateObjectMessageContainer() throws JMSException {
        Object bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        try {
            this.obj_msg_cont.setHeader(this.header_ext);
            b_data = AQjmsObjectMessage.convertSerializableToByteArray(this.serial_obj);
            bytes_len = b_data.length;
            this.obj_msg_cont.setBytesLen(new Integer(bytes_len));
            if (bytes_len > 2000) {
                this.obj_msg_cont.setBytesRaw(null);
            } else {
                this.obj_msg_cont.setBytesRaw(b_data);
                this.obj_msg_cont.setBytesLob(null);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    void readObjectMessageContainer() throws JMSException {
        BLOB bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.readObjectMessageContainer", "entry");
        try {
            bytes_len = this.obj_msg_cont.getBytesLen();
            AQjmsOracleDebug.trace(5, "AQjmsObjectMessage.readObjectMessageContainer", "- bytes_len: " + bytes_len);
            if (bytes_len > 2000) {
                bytes_lob = this.obj_msg_cont.getBytesLob();
                if (bytes_lob != null) {
                    b_data = bytes_lob.getBytes(1L, bytes_len);
                }
            } else {
                b_data = this.obj_msg_cont.getBytesRaw();
            }
            this.serial_obj = AQjmsObjectMessage.convertByteArrayToSerializable(b_data);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.readObjectMessageContainer", "exit");
    }

    public void setObject(Serializable object) throws JMSException {
        Object len = null;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else if (object instanceof Serializable) {
            this.serial_obj = object;
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid object type");
        }
    }

    void write_blob(Connection db_conn, String q_table, byte[] msg_id) throws JMSException {
        BLOB bytes_lob = null;
        int bytes_len = 0;
        byte[] b_data = null;
        int b_len = 0;
        OracleCallableStatement blob_stmt = null;
        ResultSet rset = null;
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.write_blob", "entry");
        try {
            b_data = AQjmsObjectMessage.convertSerializableToByteArray(this.serial_obj);
            bytes_len = b_data.length;
            if (q_table == null) {
                AQjmsOracleDebug.trace(1, "AQjmsObjectMessage.write_blob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsObjectMessage.write_blob", "- bytes_len: " + bytes_len);
            if (bytes_len > 2000) {
                CustomDatumFactory payload_fact = AQjmsObjectMessage_C.getFactory();
                blob_stmt = (OracleCallableStatement)db_conn.prepareCall("SELECT user_data FROM " + q_table + " where msgid = ?");
                blob_stmt.setBytes(1, msg_id);
                rset = blob_stmt.executeQuery();
                if (rset.next()) {
                    AQjmsObjectMessage_C obj_msg_c = (AQjmsObjectMessage_C)((OracleResultSet)rset).getCustomDatum(1, payload_fact);
                    bytes_lob = obj_msg_c.getBytesLob();
                }
                if (bytes_lob == null) {
                    AQjmsError.throwEx(122, "blob is null");
                }
                b_len = bytes_lob.putBytes(1L, b_data);
                try {
                    blob_stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sql_ex) {
            try {
                blob_stmt.close();
            }
            catch (Exception exception) {}
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.write_blob", "exit");
    }
}

