/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQOracleAgent;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsQueueSender;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTopicPublisher;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;

public class AQjmsProducer
implements AQjmsQueueSender,
AQjmsTopicPublisher {
    AQjmsSession jms_sess;
    AQjmsDestination prod_dest;
    int type;
    boolean msgid_enabled;
    boolean timestamp_enabled;
    int m_priority;
    long m_timetolive;
    int del_mode;

    AQjmsProducer(AQjmsSession session, AQjmsDestination destination, int type) throws JMSException {
        this.jms_sess = session;
        this.prod_dest = destination;
        this.type = type;
        this.del_mode = 2;
        this.m_priority = 1;
        this.m_timetolive = -1L;
        this.timestamp_enabled = true;
        this.msgid_enabled = true;
    }

    boolean checkMessageType(AQjmsDestination dest, Message message) throws JMSException {
        boolean match = false;
        String adt_type = null;
        adt_type = dest.getAdtType();
        AQjmsOracleDebug.trace(5, "AQjmsProducer.checkMessageType", "adt_type: " + adt_type);
        AQjmsOracleDebug.trace(5, "AQjmsProducer.checkMessageType", "message_class: " + message.getClass().getName());
        if (message instanceof AQjmsTextMessage) {
            if (!adt_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                AQjmsError.throwEx(108, "TextMessage", adt_type);
            }
        } else if (message instanceof AQjmsBytesMessage) {
            if (!adt_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                AQjmsError.throwEx(108, "BytesMessage", adt_type);
            }
        } else if (message instanceof AQjmsStreamMessage) {
            if (!adt_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsError.throwEx(108, "StreamMessage", adt_type);
            }
        } else if (message instanceof AQjmsMapMessage) {
            if (!adt_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                AQjmsError.throwEx(108, "MapMessage", adt_type);
            }
        } else if (message instanceof AQjmsObjectMessage) {
            if (!adt_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                AQjmsError.throwEx(108, "ObjectMessage", adt_type);
            }
        } else if (message instanceof AQjmsAdtMessage) {
            if (adt_type.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || adt_type.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || adt_type.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || adt_type.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || adt_type.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsError.throwEx(108, "AdtMessage", adt_type);
            }
        } else {
            AQjmsError.throwEx(108, message.getClass().getName(), adt_type);
        }
        return match;
    }

    public void close() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.close", "entry");
        this.jms_sess = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.close", "exit");
    }

    private ARRAY createRecpArrayfromAgentList(AQjmsAgent[] recp_list) throws JMSException {
        Connection db_conn = null;
        ArrayDescriptor desc = null;
        Object[] obj_array = null;
        ARRAY recp_array = null;
        int num_recps = 0;
        AQOracleAgent ora_agt = null;
        AQjmsAgent agt = null;
        int i = 0;
        int j = 0;
        AQjmsOracleDebug.trace(5, "AQjmsProducer.createRecpArrayfromAgentList", "entry");
        if (recp_list == null || recp_list.length == 0) {
            AQjmsError.throwEx(145);
        }
        num_recps = recp_list.length;
        obj_array = new Object[num_recps];
        try {
            i = 0;
            while (i < num_recps) {
                agt = recp_list[i];
                if (agt == null) {
                    j = i + 1;
                    AQjmsError.throwEx(201);
                }
                ora_agt = new AQOracleAgent(agt.getName(), agt.getAddress(), agt.getProtocol());
                AQjmsOracleDebug.trace(5, "AQjmsProducer", "recp[" + i + "]: " + agt.getName() + "::" + agt.getAddress() + "::" + agt.getProtocol());
                obj_array[i] = ora_agt;
                ++i;
            }
        }
        catch (SQLException sqlex) {
            throw new AQjmsException(sqlex);
        }
        try {
            db_conn = this.jms_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112);
        }
        try {
            desc = ArrayDescriptor.createDescriptor((String)"SYS.AQ$_RECIPIENTS", (Connection)db_conn);
            recp_array = new ARRAY(desc, db_conn, (Object)obj_array);
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.createRecpArrayfromAgentList", sqlex);
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.createRecpArrayfromAgentList", "exit");
        return recp_array;
    }

    synchronized void enqueue(AQjmsDestination msg_dest, int dest_type, Message message, int deliveryMode, int priority, long timeToLive, Integer seq_deviation, byte[] relative_msg_id, boolean immediate_visibility, AQjmsAgent[] recipient_list) throws JMSException {
        Connection db_conn = null;
        AQjmsConnection jms_conn = null;
        Object owner = null;
        AQjmsMessageHeaderExt header_ext = null;
        AQjmsPropertyList prop_list = null;
        String q_name = "";
        OracleCallableStatement enq_stmt = null;
        ResultSet rset = null;
        AQjmsAgent sender = null;
        Object b_array = null;
        byte[] msg_id = null;
        Object str_mid = null;
        Integer visib = null;
        Integer prior = null;
        Integer delay = null;
        long expire = 0L;
        long ttl_secs = 0L;
        Integer p_type = null;
        Hashtable map = null;
        Object recp_list = null;
        boolean num_recps = false;
        ARRAY recp_array = null;
        CustomDatum cd_payload = null;
        Object prot = null;
        String userid = null;
        String exceptionQ = null;
        int msg_delay = 0;
        AQjmsAgent dummy_agt = null;
        Date curr_date = new Date();
        AQjmsOracleDebug.trace(4, "AQjmsProducer.enqueue", "entry");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (deliveryMode != 2) {
            AQjmsError.throwEx(101, Integer.toString(deliveryMode));
        }
        if (msg_dest == null) {
            AQjmsError.throwEx(127);
        }
        this.checkMessageType(msg_dest, message);
        q_name = msg_dest.getCompleteName();
        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "q_name: " + q_name);
        ttl_secs = timeToLive == 0L || timeToLive == -1L ? -1L : timeToLive / 1000L;
        jms_conn = this.jms_sess.getJmsConnection();
        try {
            db_conn = this.jms_sess.getDBConnection();
            map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112);
        }
        try {
            if (!(message instanceof AQjmsAdtMessage)) {
                header_ext = ((AQjmsMessage)message).getMessageHeaderExt();
                if (header_ext.getReplyto() == null) {
                    dummy_agt = new AQjmsAgent(" ", null, 0);
                    header_ext.setReplyto(dummy_agt);
                }
                userid = jms_conn.getClientID();
                header_ext.setUserid(userid);
                prop_list = AQjmsMessage.convertHashtableToPropertyList(((AQjmsMessage)message).getPropertiesHashtable());
                header_ext.setProperties(prop_list);
            }
            msg_delay = ((AQjmsMessage)message).getDelay();
            exceptionQ = ((AQjmsMessage)message).getExceptionQueue();
            if (jms_conn.getDriver() != null && jms_conn.getDriver().equalsIgnoreCase("oci8") && !(message instanceof AQjmsAdtMessage) && AQDriverManager.isOciAQEnabled()) {
                long[] l = new long[3];
                int m_type = 0;
                l[0] = this.jms_sess.oci_env_handle;
                l[1] = this.jms_sess.oci_err_handle;
                l[2] = this.jms_sess.oci_svc_handle;
                if (message instanceof AQjmsTextMessage) {
                    m_type = 0;
                } else if (message instanceof AQjmsBytesMessage) {
                    m_type = 1;
                } else if (message instanceof AQjmsStreamMessage) {
                    m_type = 2;
                } else if (message instanceof AQjmsMapMessage) {
                    m_type = 3;
                } else if (message instanceof AQjmsObjectMessage) {
                    m_type = 4;
                } else {
                    AQjmsError.throwEx(122, "wrong msg type for OCI calls");
                }
                AQjmsOracleDebug.println("Context: " + this.jms_sess.oci_aq_cntxt);
                AQjmsSession aQjmsSession = this.jms_sess;
                synchronized (aQjmsSession) {
                    this.ocienq(q_name, message, m_type, priority, ttl_secs, recipient_list, l, this.jms_sess.oci_aq_cntxt);
                }
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "message id: " + message.getJMSMessageID());
            } else {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "message type: " + message.getClass().getName());
                if (message instanceof AQjmsTextMessage) {
                    ((AQjmsTextMessage)message).populateTextMessageContainer((OracleConnection)db_conn);
                    enq_stmt = this.jms_sess.getTextStmt();
                    enq_stmt.setCustomDatum(15, (CustomDatum)((AQjmsTextMessage)message).getMessageCont());
                } else if (message instanceof AQjmsBytesMessage) {
                    ((AQjmsBytesMessage)message).populateBytesMessageContainer();
                    enq_stmt = this.jms_sess.getBytesStmt();
                    enq_stmt.setCustomDatum(15, (CustomDatum)((AQjmsBytesMessage)message).getBytesMessageCont());
                } else if (message instanceof AQjmsStreamMessage) {
                    ((AQjmsStreamMessage)message).populateStreamMessageContainer();
                    enq_stmt = this.jms_sess.getStreamStmt();
                    enq_stmt.setCustomDatum(15, (CustomDatum)((AQjmsStreamMessage)message).getStreamMessageCont());
                } else if (message instanceof AQjmsMapMessage) {
                    ((AQjmsMapMessage)message).populateMapMessageContainer();
                    enq_stmt = this.jms_sess.getMapStmt();
                    enq_stmt.setCustomDatum(15, (CustomDatum)((AQjmsMapMessage)message).getMessageCont());
                } else if (message instanceof AQjmsObjectMessage) {
                    ((AQjmsObjectMessage)message).populateObjectMessageContainer();
                    enq_stmt = this.jms_sess.getObjectStmt();
                    enq_stmt.setCustomDatum(15, (CustomDatum)((AQjmsObjectMessage)message).getMessageCont());
                } else if (message instanceof AQjmsAdtMessage) {
                    cd_payload = ((AQjmsAdtMessage)message).getAdtPayload();
                    if (cd_payload == null) {
                        AQjmsError.throwEx(104);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "cd_payload: " + cd_payload.getClass().getName());
                    if (recipient_list != null && recipient_list.length > 0) {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recipient list specified");
                        enq_stmt = this.jms_sess.getAdtStmt();
                        recp_array = this.createRecpArrayfromAgentList(recipient_list);
                        enq_stmt.setObject(17, (Object)recp_array, 2003);
                    } else {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recipient list not specified");
                        enq_stmt = this.jms_sess.getAdtNoRecplStmt();
                    }
                    enq_stmt.setCustomDatum(15, cd_payload);
                } else {
                    AQjmsError.throwEx(129);
                }
                enq_stmt.setString(1, q_name);
                sender = ((AQjmsMessage)message).getSenderID();
                if (sender != null) {
                    enq_stmt.setString(2, sender.getName());
                    enq_stmt.setString(3, sender.getAddress());
                    enq_stmt.setInt(4, sender.getProtocol());
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "sender: " + sender.getName() + ":: " + sender.getAddress());
                } else {
                    enq_stmt.setString(2, null);
                    enq_stmt.setString(3, null);
                    enq_stmt.setInt(4, 0);
                }
                enq_stmt.setNull(5, -2);
                enq_stmt.setString(6, message.getJMSCorrelationID());
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "corrid: " + message.getJMSCorrelationID());
                visib = new Integer(2);
                enq_stmt.setObject(7, (Object)visib, 4);
                prior = new Integer(priority);
                enq_stmt.setObject(8, (Object)prior, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "priority: " + prior);
                delay = new Integer(msg_delay);
                enq_stmt.setObject(9, (Object)delay, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "delay: " + delay);
                enq_stmt.setLong(10, ttl_secs);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "ttl_secs: " + ttl_secs);
                if (seq_deviation != null) {
                    if (seq_deviation == 2 || seq_deviation == 3) {
                        enq_stmt.setObject(12, (Object)seq_deviation, 4);
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "seq_dev: " + seq_deviation);
                        if (relative_msg_id != null) {
                            enq_stmt.setObject(11, (Object)relative_msg_id, -2);
                        } else {
                            enq_stmt.setNull(11, -2);
                        }
                    } else {
                        AQjmsError.throwEx(154);
                    }
                } else {
                    enq_stmt.setNull(12, 2);
                    enq_stmt.setNull(11, -2);
                }
                enq_stmt.setString(13, exceptionQ);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "exceptionQ: " + exceptionQ);
                p_type = new Integer(1);
                enq_stmt.setObject(14, (Object)p_type, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "p_type: " + p_type);
                if (message instanceof AQjmsAdtMessage) {
                    enq_stmt.registerOutParameter(16, -2);
                } else {
                    if (recipient_list != null && recipient_list.length > 0) {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recp_list_len: " + recipient_list.length);
                        recp_array = this.createRecpArrayfromAgentList(recipient_list);
                        enq_stmt.setObject(16, (Object)recp_array, 2003);
                    } else {
                        enq_stmt.setNull(16, 2003, "SYS.AQ$_RECIPIENTS");
                    }
                    enq_stmt.registerOutParameter(17, -2);
                }
                rset = enq_stmt.executeQuery();
                msg_id = message instanceof AQjmsAdtMessage ? enq_stmt.getBytes(16) : enq_stmt.getBytes(17);
                ((AQjmsMessage)message).setJMSMessageID(msg_id);
            }
            msg_id = ((AQjmsMessage)message).getJMSMessageIDAsBytes();
            if (message instanceof AQjmsTextMessage) {
                ((AQjmsTextMessage)message).write_lob(db_conn, msg_dest.getCompleteTableName(), msg_id);
            } else if (message instanceof AQjmsBytesMessage) {
                ((AQjmsBytesMessage)message).write_blob(db_conn, msg_dest.getCompleteTableName(), msg_id);
            } else if (message instanceof AQjmsStreamMessage) {
                ((AQjmsStreamMessage)message).write_blob(db_conn, msg_dest.getCompleteTableName(), msg_id);
            } else if (message instanceof AQjmsMapMessage) {
                ((AQjmsMapMessage)message).write_blob(db_conn, msg_dest.getCompleteTableName(), msg_id);
            } else if (message instanceof AQjmsObjectMessage) {
                ((AQjmsObjectMessage)message).write_blob(db_conn, msg_dest.getCompleteTableName(), msg_id);
            }
            message.setJMSTimestamp(curr_date.getTime());
            message.setJMSDestination((Destination)msg_dest);
            message.setJMSDeliveryMode(deliveryMode);
            expire = curr_date.getTime() + timeToLive;
            message.setJMSExpiration(expire);
            message.setJMSPriority(priority);
            ((AQjmsMessage)message).setDelay(msg_delay);
            ((AQjmsMessage)message).setExceptionQueue(exceptionQ);
        }
        catch (SQLException ex) {
            try {
                if (enq_stmt != null) {
                    this.jms_sess.destroyStmt(enq_stmt);
                }
            }
            catch (Exception ex2) {
                AQjmsOracleDebug.traceEx(5, "AQjmsProducer.enqueue-ex2", ex2);
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex3", ex);
            throw new AQjmsException(ex);
        }
        catch (ClassNotFoundException ex2) {
            AQjmsError.throwEx(146, ex2);
        }
        catch (Exception ex3) {
            AQjmsError.throwEx(204, ex3);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.enqueue", "exit");
    }

    public synchronized int getDeliveryMode() throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        return this.del_mode;
    }

    public synchronized boolean getDisableMessageID() throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        return this.msgid_enabled;
    }

    public synchronized boolean getDisableMessageTimestamp() throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        return this.timestamp_enabled;
    }

    public synchronized int getPriority() throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        return this.m_priority;
    }

    public synchronized Queue getQueue() throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (this.type == 10) {
            return this.prod_dest;
        }
        AQjmsError.throwEx(107, "TopicPublisher");
        return null;
    }

    public synchronized long getTimeToLive() throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        return this.m_timetolive;
    }

    public synchronized Topic getTopic() throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (this.type == 20) {
            return this.prod_dest;
        }
        AQjmsError.throwEx(107, "QueueReceiver");
        return null;
    }

    boolean isProducerClosed() {
        if (this.jms_sess == null) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.isProducerClosed", "Producer closed");
            return true;
        }
        return false;
    }

    private native void ocienq(String var1, Message var2, int var3, int var4, long var5, AQjmsAgent[] var7, long[] var8, long var9) throws Exception;

    public synchronized void publish(Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-1", "entry");
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-1", "exit");
    }

    public synchronized void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-2", "entry");
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        this.publish(this.prod_dest, message, deliveryMode, priority, timeToLive, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-2", "exit");
    }

    public synchronized void publish(Message message, AQjmsAgent[] recipient_list) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-6", "entry");
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, recipient_list);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-6", "exit");
    }

    public synchronized void publish(Message message, AQjmsAgent[] recipient_list, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-8", "entry");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        this.publish(this.prod_dest, message, deliveryMode, priority, timeToLive, null, null, false, recipient_list);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-8", "exit");
    }

    public synchronized void publish(Topic topic, Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-3", "entry");
        this.publish(topic, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-3", "exit");
    }

    public synchronized void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-4", "entry");
        this.publish(topic, message, deliveryMode, priority, timeToLive, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-4", "exit");
    }

    synchronized void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive, Integer seq_deviation, byte[] relative_msg_id, boolean immediate_visibility, AQjmsAgent[] recipient_list) throws JMSException {
        AQjmsDestination dest_topic = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "entry");
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (deliveryMode != 2) {
            AQjmsError.throwEx(101, Integer.toString(deliveryMode));
        }
        if (topic == null) {
            if (this.prod_dest == null || this.prod_dest.getTopicName() == null) {
                AQjmsError.throwEx(166);
            } else {
                dest_topic = this.prod_dest;
            }
        } else if (topic instanceof AQjmsDestination) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.publish", "topic: " + ((AQjmsDestination)topic).getCompleteName());
            dest_topic = (AQjmsDestination)topic;
        } else {
            AQjmsError.throwEx(166);
        }
        this.enqueue(dest_topic, 20, message, deliveryMode, priority, timeToLive, seq_deviation, relative_msg_id, immediate_visibility, recipient_list);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "exit");
    }

    public synchronized void publish(Topic topic, Message message, AQjmsAgent[] recipient_list) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-7", "entry");
        this.publish(topic, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, recipient_list);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-7", "exit");
    }

    public synchronized void publish(Topic topic, Message message, AQjmsAgent[] recipient_list, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-9", "entry");
        this.publish(topic, message, deliveryMode, priority, timeToLive, null, null, false, recipient_list);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-9", "exit");
    }

    public synchronized void send(Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-1", "entry");
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (this.type != 10) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        this.send(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-1", "exit");
    }

    public synchronized void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-2", "entry");
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (this.type != 10) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        this.send(this.prod_dest, message, deliveryMode, priority, timeToLive, null, null, false);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-2", "exit");
    }

    public synchronized void send(Queue queue, Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "entry");
        this.send(queue, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "exit");
    }

    public synchronized void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "entry");
        this.send(queue, message, deliveryMode, priority, timeToLive, null, null, false);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "exit");
    }

    synchronized void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive, Integer seq_deviation, byte[] relative_msg_id, boolean immediate_visibility) throws JMSException {
        AQjmsDestination dest_queue = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "entry");
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (deliveryMode != 2) {
            AQjmsError.throwEx(101, Integer.toString(deliveryMode));
        }
        if (queue == null) {
            if (this.prod_dest == null || this.prod_dest.getQueueName() == null) {
                AQjmsError.throwEx(143);
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "prod_dest: " + this.prod_dest.getCompleteName());
                dest_queue = this.prod_dest;
            }
        } else if (queue.getQueueName() != null) {
            if (queue instanceof AQjmsDestination) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "queue: " + ((AQjmsDestination)queue).getCompleteName());
                dest_queue = (AQjmsDestination)queue;
            } else {
                AQjmsError.throwEx(125);
            }
        } else {
            AQjmsError.throwEx(143);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "dest_queue: " + dest_queue.getCompleteName());
        this.enqueue(dest_queue, 10, message, deliveryMode, priority, timeToLive, seq_deviation, relative_msg_id, immediate_visibility, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "exit");
    }

    public synchronized void setDeliveryMode(int deliveryMode) throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        if (deliveryMode == 2) {
            this.del_mode = deliveryMode;
        } else {
            AQjmsError.throwEx(101, Integer.toString(deliveryMode));
        }
    }

    public synchronized void setDisableMessageID(boolean value) throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        this.msgid_enabled = value;
    }

    public synchronized void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        this.timestamp_enabled = value;
    }

    public synchronized void setPriority(int priority) throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        this.m_priority = priority;
    }

    public synchronized void setTimeToLive(long timeToLive) throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwEx(138);
        }
        this.m_timetolive = timeToLive;
    }
}

