/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.lio.lioa;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import oracle.ewt.alert.Alert;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.security.admin.lio.lioa.LioaComponent;
import oracle.security.admin.lio.lioo.LiooClient;
import oracle.security.admin.lio.liot.LiotChangePassDialog;
import oracle.security.admin.lio.liot.LiotPasswordDialog;
import oracle.security.admin.util.AdminTRACE;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandAdapter;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CommandEvent;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public class LioaCommandHandler
extends CommandAdapter {
    private MessageBundle lioMsgBundle;
    private BufferedFrame m_frame;
    private WebApplication m_container;
    private LioaComponent m_app;
    private LiooClient m_clientObj;

    public LioaCommandHandler(WebApplication webApplication, LioaComponent lioaComponent) {
        super(webApplication);
        this.m_app = lioaComponent;
        this.m_container = webApplication;
        this.m_clientObj = this.m_app.getClientObject();
        this.m_frame = (BufferedFrame)this.m_container.getFrame();
        this.lioMsgBundle = this.m_app.getMessageBundle();
    }

    public void commandIssued(CommandEvent commandEvent) {
        String string = commandEvent.getCommand();
        if (string.equals("LOGIN")) {
            this.LioLogin();
            return;
        }
        if (string.equals("LOGOUT")) {
            this.LioLogout();
            return;
        }
        if (string.equals("CHANGEPASS")) {
            this.LioChangePass();
            return;
        }
        if (string.equals("EXIT")) {
            this.m_container.exit();
            return;
        }
        if (commandEvent.getCommand().equals("3016")) {
            this.m_app.showHelpContents();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void LioLogin() {
        if (!this.m_clientObj.isWalletExists()) {
            var1_1 = new Alert((Frame)this.m_frame, this.lioMsgBundle.getMessage("1021", false), 0, 1);
            var1_1.setTitle(this.lioMsgBundle.getMessage("1008", false));
            var1_1.runAlert();
            return;
        }
        var1_2 = new LiotPasswordDialog(this.m_frame, this.lioMsgBundle.getMessage("1022", false));
        var1_2.show();
        if (!var1_2.isCanceled()) ** GOTO lbl29
        return;
lbl-1000:
        // 1 sources

        {
            if (!this.m_clientObj.loadWallet(var1_2.getPassword())) {
                var2_3 = new Alert((Frame)this.m_frame, this.lioMsgBundle.getMessage("1023", false), 1, 3);
                var2_3.setTitle(this.lioMsgBundle.getMessage("1008", false));
                if (var2_3.runAlert() == 2) {
                    return;
                }
                var1_2.setVisible(true);
                continue;
            }
            if (!this.m_clientObj.storeSSOWallet()) {
                var2_3 = new Alert((Frame)this.m_frame, this.lioMsgBundle.getMessage("1024", false), 0, 1);
                var2_3.setTitle(this.lioMsgBundle.getMessage("1008", false));
                var2_3.runAlert();
                return;
            }
            this.m_app.setEnabledMenu("LOGIN", false);
            this.m_app.setEnabledMenu("LOGOUT", true);
            this.m_app.setEnabledMenu("CHANGEPASS", true);
            this.m_app.showBannerPanel(true);
            return;
lbl29:
            // 2 sources

            ** while (!var1_2.isCanceled())
        }
lbl30:
        // 1 sources

    }

    private void LioLogout() {
        if (!this.m_clientObj.isSsoWalletExists()) {
            Alert alert = new Alert((Frame)this.m_frame, this.lioMsgBundle.getMessage("1025", false), 0, 1);
            alert.setTitle(this.lioMsgBundle.getMessage("1008", false));
            alert.runAlert();
            return;
        }
        Alert alert = new Alert((Frame)this.m_frame, this.lioMsgBundle.getMessage("1026", false), 1, 3);
        alert.setTitle(this.lioMsgBundle.getMessage("1008", false));
        if (alert.runAlert() == 2) {
            return;
        }
        if (!this.m_clientObj.delSsoWlt()) {
            alert = new Alert((Frame)this.m_frame, this.lioMsgBundle.getMessage("1027", false), 0, 1);
            alert.setTitle(this.lioMsgBundle.getMessage("1008", false));
            alert.runAlert();
            return;
        }
        this.m_app.setEnabledMenu("LOGIN", true);
        this.m_app.setEnabledMenu("LOGOUT", false);
        this.m_app.setEnabledMenu("CHANGEPASS", false);
        this.m_app.showBannerPanel(false);
    }

    private void LioChangePass() {
        String string = null;
        String string2 = null;
        String string3 = null;
        LiotChangePassDialog liotChangePassDialog = new LiotChangePassDialog(this.m_frame, this.lioMsgBundle.getMessage("1028", false));
        ((Dialog)((Object)liotChangePassDialog)).show();
        while (!liotChangePassDialog.isCanceled()) {
            string = liotChangePassDialog.getOldPasswd();
            string2 = liotChangePassDialog.getNewPasswd();
            string3 = liotChangePassDialog.getConfNewPasswd();
            if (!this.m_clientObj.isValidPassword(string)) {
                if (!this.showRetryMessage(this.lioMsgBundle.getMessage("1029", false))) {
                    return;
                }
                ((Component)((Object)liotChangePassDialog)).setVisible(true);
                continue;
            }
            if (string2 == null || string3 == null || string2.length() <= 0 || string3.length() <= 0) {
                if (!this.showRetryMessage(this.lioMsgBundle.getMessage("1030", false))) {
                    return;
                }
                ((Component)((Object)liotChangePassDialog)).setVisible(true);
                continue;
            }
            if (!string2.equals(string3)) {
                if (!this.showRetryMessage(this.lioMsgBundle.getMessage("1031", false))) {
                    return;
                }
                ((Component)((Object)liotChangePassDialog)).setVisible(true);
                continue;
            }
            this.m_clientObj.changePassword(string, string2);
            this.showNoteMessage(this.lioMsgBundle.getMessage("1032", false));
            return;
        }
    }

    private void LioExit() {
        this.m_container.exit();
    }

    protected void showNoteMessage(String string) {
        Alert alert = new Alert((Frame)this.m_frame, string, 2, 1);
        alert.setTitle(this.lioMsgBundle.getMessage("1008", false));
        alert.runAlert();
    }

    protected boolean showRetryMessage(String string) {
        Alert alert = new Alert((Frame)this.m_frame, String.valueOf(string) + this.lioMsgBundle.getMessage("1034", false), 1, 3);
        alert.setTitle(this.lioMsgBundle.getMessage("1008", false));
        return alert.runAlert() == 1;
    }

    protected void debug(String string) {
        AdminTRACE.out("Lio CommandHandler: " + string);
    }
}

