/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.lio.lioa;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuSeparator;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.security.admin.lio.lioa.LioaApp;
import oracle.security.admin.lio.lioa.LioaCommandHandler;
import oracle.security.admin.lio.lioa.LioaImageCanvas;
import oracle.security.admin.lio.lioo.LiooClient;
import oracle.security.admin.lio.liot.LiotAboutBox;
import oracle.security.admin.util.AdminImage;
import oracle.security.admin.util.AdminTRACE;
import oracle.sysman.emSDK.client.appComponent.BaseAppComponent;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.MenuCommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ToolBarCommandButton;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public class LioaComponent
extends BaseAppComponent {
    protected static MessageBundle lioMsgBundle = new MessageBundle("Lio");
    private AdminImage m_imgBundle;
    public LioaCommandHandler m_commandAdapter;
    private ToolBar m_toolBar;
    private WebApplication m_container;
    private LiooClient m_clientObj;

    public LioaComponent(WebApplication webApplication) {
        super(webApplication);
        this.m_container = webApplication;
        lioMsgBundle.setPackage("oracle.security.resources");
        this.m_imgBundle = new AdminImage("Lio");
    }

    public void initClient() {
        super.initClient();
        this.addHelpBook(((Object)((Object)this)).getClass(), "/", "oel", lioMsgBundle.getMessage("1010", false));
        this.m_clientObj = new LiooClient();
        this.m_commandAdapter = new LioaCommandHandler(this.m_container, this);
        LWMenu lWMenu = this.addLioMenu();
        this.m_commandAdapter.addMenu(lWMenu);
        this.m_toolBar = this.addLioToolBar();
        this.m_commandAdapter.addToolBar(this.m_toolBar);
        boolean bl = false;
        bl = this.m_clientObj.isSsoWalletExists();
        this.showBannerPanel(bl);
        this.setEnabledMenu("LOGIN", !bl);
        this.setEnabledMenu("LOGOUT", bl);
        this.setEnabledMenu("CHANGEPASS", bl);
    }

    public LiooClient getClientObject() {
        return this.m_clientObj;
    }

    protected void showBannerPanel(boolean bl) {
        GridBagConstraints gridBagConstraints;
        LioaImageCanvas lioaImageCanvas;
        Image image;
        String string;
        GridBagLayout gridBagLayout = new GridBagLayout();
        LioaComponent lioaComponent = this;
        ((Container)((Object)lioaComponent)).setLayout(gridBagLayout);
        lioaComponent.removeAll();
        String string2 = lioMsgBundle.getMessage("1009", false);
        if (bl) {
            string = lioMsgBundle.getMessage("1017", false);
            image = this.m_imgBundle.getImage("1011");
        } else {
            string = lioMsgBundle.getMessage("1018", false);
            image = this.m_imgBundle.getImage("1012");
        }
        this.m_container.showStatus(string);
        if (image != null) {
            lioaImageCanvas = new LioaImageCanvas(image);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            ((GridBagLayout)((Container)((Object)lioaComponent)).getLayout()).setConstraints((Component)((Object)lioaImageCanvas), gridBagConstraints);
            ((Container)((Object)lioaComponent)).add((Component)((Object)lioaImageCanvas));
        }
        if (string2 != null) {
            lioaImageCanvas = new MultiLineLabel(WordWrapper.getTextWrapper(), string2);
            lioaImageCanvas.setAlignment(3);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(1, 1, 10, 1);
            ((GridBagLayout)((Container)((Object)lioaComponent)).getLayout()).setConstraints((Component)((Object)lioaImageCanvas), gridBagConstraints);
            ((Container)((Object)lioaComponent)).add((Component)((Object)lioaImageCanvas));
        }
        this.validate();
    }

    private LWMenu addLioMenu() {
        LWMenu lWMenu = new LWMenu(lioMsgBundle.getMessage("1011", false), new LWPopupMenu());
        lWMenu.getSubMenu().add((Component)new MenuCommandItem("LOGIN", lioMsgBundle.getMessage("1012", false)));
        lWMenu.getSubMenu().add((Component)new MenuCommandItem("LOGOUT", lioMsgBundle.getMessage("1013", false)));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)new MenuCommandItem("CHANGEPASS", lioMsgBundle.getMessage("1014", false)));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)new MenuCommandItem("EXIT", lioMsgBundle.getMessage("1015", false)));
        return lWMenu;
    }

    public void setEnabledMenu(String string, boolean bl) {
        LWMenuBar lWMenuBar = ((LioaApp)this.m_container).getLioManuBar();
        LWMenu lWMenu = (LWMenu)lWMenuBar.getContent().getComponent(0);
        LWPopupMenu lWPopupMenu = lWMenu.getSubMenu();
        if (lWPopupMenu == null) {
            this.debug("Popup menu is null");
        }
        int n = lWPopupMenu.getContent().getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            MenuCommandItem menuCommandItem;
            Component component = lWPopupMenu.getContent().getComponent(n2);
            if (component instanceof MenuCommandItem && (menuCommandItem = (MenuCommandItem)component).getCommand().trim() == string) {
                menuCommandItem.setEnabled(bl);
            }
            ++n2;
        }
        this.setEnabledToolBarItem(string, bl);
    }

    private ToolBar addLioToolBar() {
        Image image = null;
        ImageStrip imageStrip = null;
        ToolBarCommandButton toolBarCommandButton = null;
        this.m_toolBar = new ToolBar();
        image = this.m_imgBundle.getImage("1016");
        imageStrip = new ImageStrip(image, 16);
        toolBarCommandButton = new ToolBarCommandButton("LOGIN", (ImageSet)imageStrip);
        toolBarCommandButton.setHelpText(lioMsgBundle.getMessage("1016", false));
        this.m_toolBar.addItem((ToolBarItem)toolBarCommandButton);
        return this.m_toolBar;
    }

    private void setEnabledToolBarItem(String string, boolean bl) {
        int n = this.m_toolBar.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            ToolBarCommandButton toolBarCommandButton;
            ToolBarItem toolBarItem = this.m_toolBar.getItem(n2);
            if (toolBarItem instanceof ToolBarCommandButton && (toolBarCommandButton = (ToolBarCommandButton)toolBarItem).getCommand().equals(string)) {
                toolBarCommandButton.setEnabled(bl);
            }
            ++n2;
        }
    }

    public boolean isExitAllowed() {
        return super.isExitAllowed();
    }

    protected void showAboutBox() {
        LiotAboutBox liotAboutBox = new LiotAboutBox((BufferedFrame)this.getContainer().getFrame(), lioMsgBundle.getMessage("1008", false));
        ((Dialog)((Object)liotAboutBox)).show();
    }

    public void destroy() {
    }

    public MessageBundle getMessageBundle() {
        return lioMsgBundle;
    }

    public void debug(String string) {
        AdminTRACE.out("AppCmp: " + string);
    }
}

