/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.util;

import java.awt.Image;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.ewt.graphics.ImageUtils;
import oracle.sysman.emSDK.client.appContainer.ImageLoader;

public class AdminImageUtil {
    private static int IMG_CACHE_SIZE = 100;
    private static Hashtable img_cache = new Hashtable();
    private ResourceBundle m_bundle;
    private ImageLoader m_imgCont;
    private String m_package = "oracle.security.resources";
    private Locale m_locale = Locale.getDefault();
    private String m_facility;

    public AdminImageUtil(String string) {
        this(Locale.getDefault(), string);
    }

    public AdminImageUtil(ImageLoader imageLoader, String string) {
        this(imageLoader, Locale.getDefault(), string);
    }

    public AdminImageUtil(Locale locale, String string) {
        if (locale != null) {
            this.m_locale = locale;
        }
        this.m_facility = string;
    }

    public AdminImageUtil(ImageLoader imageLoader, Locale locale, String string) {
        this.m_imgCont = imageLoader;
        if (locale != null) {
            this.m_locale = locale;
        }
        this.m_facility = string;
    }

    public AdminImageUtil(ImageLoader imageLoader, Locale locale, String string, String string2) {
        this(imageLoader, locale, string);
        this.setPackage(string2);
    }

    private Image checkImageCache(String string) {
        Image image = null;
        Hashtable hashtable = (Hashtable)img_cache.get(this.m_facility);
        if (hashtable != null) {
            image = (Image)hashtable.get(string);
        }
        return image;
    }

    private void addToImageCache(String string, Image image) {
        Hashtable<String, Image> hashtable = (Hashtable<String, Image>)img_cache.get(this.m_facility);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Image>();
            img_cache.put(this.m_facility, hashtable);
        }
        hashtable.put(string, image);
    }

    public Image getImage(String string) {
        Image image = this.checkImageCache(string);
        if (image != null) {
            return image;
        }
        String string2 = null;
        try {
            this.loadBundle(false);
            string2 = this.m_bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        image = this.getImageFromString(string2);
        if (image != null) {
            this.addToImageCache(string, image);
        }
        return image;
    }

    public Image getImageFromString(String string) {
        return ImageUtils.getImageResource(this.getClass(), (String)string);
    }

    public String getImageFileName(String string) {
        String string2 = null;
        try {
            this.loadBundle(false);
            string2 = this.m_bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        return string2;
    }

    public synchronized String getPackage() {
        return this.m_package;
    }

    public synchronized void setPackage(String string) throws MissingResourceException {
        this.m_package = string;
        this.loadBundle(true);
    }

    private void loadBundle(boolean bl) {
        if (this.m_bundle == null || bl) {
            String string = String.valueOf(this.m_package) + "." + this.m_facility + "Img";
            this.m_bundle = ResourceBundle.getBundle(string, this.m_locale);
        }
    }
}

