/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.util;

import java.awt.event.MouseEvent;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.MultipleRowSelection;

public class AdminRowSelectCellInputHandler
extends CellInputHandler {
    private boolean bMouseDragged = false;
    private int indexStart;
    private int indexEnd;

    private void updateRowSelectionState(MouseEvent mouseEvent, Grid grid, int n) {
        if (grid == null) {
            return;
        }
        GridSelection gridSelection = grid.getGridSelection();
        if (mouseEvent.isControlDown()) {
            if (gridSelection.isRowSelected(n)) {
                gridSelection.setRowSelected(n, false);
                return;
            }
            gridSelection.setRowSelected(n, true);
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (gridSelection instanceof MultipleRowSelection) {
                this.indexStart = 0;
                this.indexEnd = n;
                int[] nArray = gridSelection.getSelectedRows();
                this.indexStart = nArray == null || nArray.length == 0 ? 0 : nArray[0];
                if (this.indexStart > n) {
                    this.indexEnd = this.indexStart;
                    this.indexStart = n;
                }
                int n2 = this.indexStart;
                while (n2 <= this.indexEnd) {
                    gridSelection.setRowSelected(n2, true);
                    ++n2;
                }
                return;
            }
        } else {
            int[] nArray;
            if (gridSelection instanceof MultipleRowSelection && (nArray = gridSelection.getSelectedRows()) != null) {
                if (nArray.length == 1 && gridSelection.isRowSelected(n)) {
                    return;
                }
                gridSelection.deselectAll();
            }
            if (!gridSelection.isRowSelected(n)) {
                gridSelection.setRowSelected(n, true);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        this.updateRowSelectionState(mouseEvent, grid, n2);
    }

    public void mouseDragged(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        this.bMouseDragged = true;
        this.indexStart = n2;
    }

    public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        if (!this.bMouseDragged || grid == null) {
            return;
        }
        GridSelection gridSelection = grid.getGridSelection();
        if (gridSelection instanceof MultipleRowSelection) {
            this.indexEnd = n2;
            if (this.indexStart > n2) {
                this.indexEnd = this.indexStart;
                this.indexStart = n2;
            }
            int n3 = this.indexStart;
            while (n3 <= this.indexEnd) {
                gridSelection.setRowSelected(n3, true);
                ++n3;
            }
        } else {
            this.updateRowSelectionState(mouseEvent, grid, n2);
        }
        this.bMouseDragged = false;
    }
}

