/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class AdminWeightedGridLayout
implements LayoutManager {
    private int rows;
    private int cols;
    private int[] columnWeights;
    private int hgap;
    private int vgap;

    public AdminWeightedGridLayout(int n, int n2, int[] nArray) throws IllegalArgumentException {
        this(n, n2, nArray, 0, 0);
    }

    public AdminWeightedGridLayout(int n, int n2, int[] nArray, int n3, int n4) throws IllegalArgumentException {
        if (n < 1 || n2 < 1 || n3 < 0 || n4 < 0 || nArray.length < n2) {
            throw new IllegalArgumentException();
        }
        this.rows = n;
        this.cols = n2;
        this.columnWeights = nArray;
        this.hgap = n3;
        this.vgap = n4;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int n;
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        int n3 = this.rows;
        int n4 = this.cols;
        if (n3 > 0) {
            n4 = (n2 + n3 - 1) / n3;
        } else {
            n3 = (n2 + n4 - 1) / n4;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = 0;
            nArray2[n5] = 0;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            Component component = container.getComponent(n6);
            Dimension dimension = component.getPreferredSize();
            int n7 = n = n6 / n4;
            nArray2[n7] = nArray2[n7] + dimension.width;
            if (nArray[n] < dimension.height) {
                nArray[n] = dimension.height;
            }
            ++n6;
        }
        int n8 = 0;
        int n9 = 0;
        n = 0;
        while (n < n3) {
            n9 += nArray[n];
            if (n8 < nArray2[n]) {
                n8 = nArray2[n];
            }
            ++n;
        }
        return new Dimension(insets.left + insets.right + n8 + (this.cols - 1) * this.hgap, insets.top + insets.bottom + n9 + (this.rows - 1) * this.vgap);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n;
        Insets insets = container.getInsets();
        int n2 = container.getComponentCount();
        int n3 = this.rows;
        int n4 = this.cols;
        if (n3 > 0) {
            n4 = (n2 + n3 - 1) / n3;
        } else {
            n3 = (n2 + n4 - 1) / n4;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = 0;
            nArray2[n5] = 0;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            Component component = container.getComponent(n6);
            Dimension dimension = component.getMinimumSize();
            int n7 = n = n6 / n4;
            nArray2[n7] = nArray2[n7] + dimension.width;
            if (nArray[n] < dimension.height) {
                nArray[n] = dimension.height;
            }
            ++n6;
        }
        int n8 = 0;
        int n9 = 0;
        n = 0;
        while (n < n3) {
            n9 += nArray[n];
            if (n8 < nArray2[n]) {
                n8 = nArray2[n];
            }
            ++n;
        }
        return new Dimension(insets.left + insets.right + n8 + (this.cols - 1) * this.hgap, insets.top + insets.bottom + n9 + (this.rows - 1) * this.vgap);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = this.rows;
        int n3 = this.cols;
        if (n == 0) {
            return;
        }
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        int n4 = container.getSize().width - (insets.left + insets.right);
        int n5 = container.getSize().height - (insets.top + insets.bottom);
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.cols) {
            n6 += this.columnWeights[n7];
            ++n7;
        }
        int n8 = (n4 - (n3 - 1) * this.hgap) / n6;
        int[] nArray = new int[this.cols];
        int n9 = 0;
        while (n9 < this.cols) {
            nArray[n9] = n8 * this.columnWeights[n9];
            ++n9;
        }
        n5 = (n5 - (n2 - 1) * this.vgap) / n2;
        int n10 = 0;
        int n11 = insets.left;
        while (n10 < n3) {
            int n12 = 0;
            int n13 = insets.top;
            while (n12 < n2) {
                int n14 = n12 * n3 + n10;
                if (n14 < n) {
                    container.getComponent(n14).setBounds(n11, n13, nArray[n10], n5);
                }
                n13 += n5 + this.vgap;
                ++n12;
            }
            n11 += nArray[n10] + this.hgap;
            ++n10;
        }
    }
}

