/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.wltmgr.owma;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwMenu.LWMenuSeparator;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.splitter.Splitter;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.security.admin.util.AdminImage;
import oracle.security.admin.util.AdminTRACE;
import oracle.security.admin.wltmgr.owma.OwmaApp;
import oracle.security.admin.wltmgr.owma.OwmaCommandHandler;
import oracle.security.admin.wltmgr.owma.OwmaInvisibleRootDataSource;
import oracle.security.admin.wltmgr.owmb.OwmbDetailComponent;
import oracle.security.admin.wltmgr.owmb.OwmbMenuFactory;
import oracle.security.admin.wltmgr.owmb.OwmbPopupMenuFactory;
import oracle.security.admin.wltmgr.owmo.OwmoClient;
import oracle.security.admin.wltmgr.owmt.OwmtAboutBox;
import oracle.sysman.emSDK.adminObj.client.ClientObject;
import oracle.sysman.emSDK.client.appContainer.WebApplication;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeDataSource;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.CheckboxMenuCommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.MenuCommandItem;
import oracle.sysman.emSDK.client.guiComponent.commandAdapter.ToolBarCommandButton;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public class OwmaDetailComponent
extends OwmbDetailComponent {
    private WebApplication m_container;
    private OwmaCommandHandler m_commandAdapter;
    private OwmoClient m_clientObj;
    private OwmaInvisibleRootDataSource m_iRootDataSrc;
    private OwmbMenuFactory m_menuItem;
    protected static MessageBundle owmMsgBundle = new MessageBundle("Owm");
    private AdminImage m_imgBundle;
    private ToolBar m_toolBar;

    public OwmaDetailComponent(WebApplication webApplication) {
        super(webApplication);
        this.m_container = webApplication;
        owmMsgBundle.setPackage("oracle.security.resources");
        this.m_imgBundle = new AdminImage("Owm");
        this.m_menuItem = new OwmbMenuFactory();
        this.m_popupMenuFactory = new OwmbPopupMenuFactory();
    }

    protected void initClient() {
        super.initClient();
        Splitter splitter = this.getSplitter();
        splitter.setSizeRatio(0.3);
        this.addHelpBook(((Object)((Object)this)).getClass(), "/", "owm", owmMsgBundle.getMessage("1666", false));
        this.m_clientObj = new OwmoClient();
        this.m_commandAdapter = new OwmaCommandHandler(this.m_container, this);
        LWMenu lWMenu = this.addWalletMenu();
        this.m_commandAdapter.addMenu(lWMenu);
        lWMenu = this.addOperationMenu();
        this.m_commandAdapter.addMenu(lWMenu);
        this.m_toolBar = this.createToolBar();
        this.m_commandAdapter.addToolBar(this.m_toolBar);
        this.m_commandAdapter.setPopupMenuAdapter(this);
        DataDrivenTree dataDrivenTree = this.getTreeMaster().getTree();
        this.m_iRootDataSrc = new OwmaInvisibleRootDataSource(dataDrivenTree);
        this.getTreeMaster().setTreeRoot((TreeDataSource)this.m_iRootDataSrc);
        String[] stringArray = new String[]{"WALLET_CLOSE", "WALLET_SAVE", "WALLET_SAVE_AS", "WALLET_SAVE_SYS", "WALLET_DEL", "WALLET_PASS", "WALLET_EXP_SSO"};
        String[] stringArray2 = new String[]{"CERT_CREAT", "CERT_IMP", "CERT_IMP_TC", "CERT_REM_USERCERT", "CERT_REM_TC", "CERT_EXP_UC", "CERT_EXP_CR", "CERT_EXP_TCR", "CERT_EXP_TC_ALL", "CERT_EXP_WALLET"};
        this.initMenuItems(stringArray, stringArray2);
    }

    public boolean isExitAllowed() {
        return this.m_commandAdapter.isExitAllowed();
    }

    public static void centerWindow(Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.width / 2 - window.getSize().width / 2;
        int n2 = dimension.height / 2 - window.getSize().height / 2;
        ((Component)window).setBounds(n, n2, window.getSize().width, window.getSize().height);
    }

    private LWMenu addWalletMenu() {
        LWMenu lWMenu = this.m_menuItem.createMenu("1500");
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_NEW", "1501"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_OPEN", "1502"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_CLOSE", "1503"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_SAVE", "1512"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_SAVE_AS", "1513"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_SAVE_SYS", "1516"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_DEL", "1504"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_PASS", "1505"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createCheckboxMenuItem("WALLET_EXP_SSO", "1514"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("WALLET_EXIT", "1511"));
        return lWMenu;
    }

    private LWMenu addOperationMenu() {
        LWMenu lWMenu = this.m_menuItem.createMenu("1520");
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_CREAT", "1521"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_IMP", "1522"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_IMP_TC", "1523"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_REM_USERCERT", "1530"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_REM_TC", "1525"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_EXP_UC", "1527"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_EXP_CR", "1528"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_EXP_TCR", "1529"));
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_EXP_TC_ALL", "1685"));
        lWMenu.getSubMenu().add((Component)new LWMenuSeparator());
        lWMenu.getSubMenu().add((Component)this.m_menuItem.createMenuItem("CERT_EXP_WALLET", "1696"));
        return lWMenu;
    }

    private void initMenuItems(String[] stringArray, String[] stringArray2) {
        LWMenu lWMenu = null;
        LWMenuBar lWMenuBar = ((OwmaApp)this.m_container).getOwmMenuBar();
        lWMenu = (LWMenu)lWMenuBar.getContent().getComponent(1);
        int n = 0;
        while (n < stringArray.length) {
            this.setDisableMenuItem(lWMenu, stringArray[n]);
            this.setDisabledToolBarItems(stringArray[n]);
            ++n;
        }
        lWMenu = (LWMenu)lWMenuBar.getContent().getComponent(2);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.setDisableMenuItem(lWMenu, stringArray2[n2]);
            ++n2;
        }
        this.m_popupMenuFactory.updatePopupMenu(stringArray, stringArray2);
    }

    public void setDisabledMenuItems(String[] stringArray, String[] stringArray2) {
        LWMenu lWMenu = null;
        LWMenuBar lWMenuBar = ((OwmaApp)this.m_container).getOwmMenuBar();
        lWMenu = (LWMenu)lWMenuBar.getContent().getComponent(0);
        int n = 0;
        while (n < stringArray.length) {
            this.setDisableMenuItem(lWMenu, stringArray[n]);
            this.setDisabledToolBarItems(stringArray[n]);
            ++n;
        }
        lWMenu = (LWMenu)lWMenuBar.getContent().getComponent(1);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.setDisableMenuItem(lWMenu, stringArray2[n2]);
            ++n2;
        }
        this.m_popupMenuFactory.updatePopupMenu(stringArray, stringArray2);
    }

    private void setDisableMenuItem(LWMenu lWMenu, String string) {
        LWPopupMenu lWPopupMenu = lWMenu.getSubMenu();
        if (lWPopupMenu == null) {
            AdminTRACE.out("OwmaDetailComponent: Popup menu is null");
        }
        int n = lWPopupMenu.getContent().getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            MenuCommandItem menuCommandItem;
            Component component = lWPopupMenu.getContent().getComponent(n2);
            if (component instanceof MenuCommandItem) {
                menuCommandItem = (MenuCommandItem)component;
                if (menuCommandItem.getCommand().trim() == string) {
                    menuCommandItem.setEnabled(false);
                }
            } else if (component instanceof CheckboxMenuCommandItem && (menuCommandItem = (CheckboxMenuCommandItem)component).getCommand().trim() == string) {
                menuCommandItem.setEnabled(false);
            }
            ++n2;
        }
    }

    private void setDisabledToolBarItems(String string) {
        int n = this.m_toolBar.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            ToolBarCommandButton toolBarCommandButton;
            ToolBarItem toolBarItem = this.m_toolBar.getItem(n2);
            if (toolBarItem instanceof ToolBarCommandButton && (toolBarCommandButton = (ToolBarCommandButton)toolBarItem).getCommand().equals(string)) {
                toolBarCommandButton.setEnabled(false);
            }
            ++n2;
        }
    }

    public void setEnabledMenuItems() {
        LWMenu lWMenu = null;
        LWMenu lWMenu2 = null;
        LWMenuBar lWMenuBar = ((OwmaApp)this.m_container).getOwmMenuBar();
        lWMenu = (LWMenu)lWMenuBar.getContent().getComponent(0);
        this.setEnabledMenuItem(lWMenu);
        this.setEnabledToolBarItems();
        lWMenu2 = (LWMenu)lWMenuBar.getContent().getComponent(1);
        this.setEnabledMenuItem(lWMenu2);
    }

    private void setEnabledMenuItem(LWMenu lWMenu) {
        LWPopupMenu lWPopupMenu = lWMenu.getSubMenu();
        if (lWPopupMenu == null) {
            AdminTRACE.out("OwmaDetailComponent: Popup menu is null");
        }
        int n = lWPopupMenu.getContent().getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            MenuCommandItem menuCommandItem;
            Component component = lWPopupMenu.getContent().getComponent(n2);
            if (component instanceof MenuCommandItem) {
                menuCommandItem = (MenuCommandItem)component;
                menuCommandItem.setEnabled(true);
            } else if (component instanceof CheckboxMenuCommandItem) {
                menuCommandItem = (CheckboxMenuCommandItem)component;
                menuCommandItem.setEnabled(true);
            }
            ++n2;
        }
    }

    public boolean getAutoLoginStatus() {
        LWMenuBar lWMenuBar = ((OwmaApp)this.m_container).getOwmMenuBar();
        LWMenu lWMenu = (LWMenu)lWMenuBar.getContent().getComponent(0);
        LWPopupMenu lWPopupMenu = lWMenu.getSubMenu();
        if (lWPopupMenu == null) {
            AdminTRACE.out("OwmaDetailComponent: Popup menu is null");
        }
        int n = lWPopupMenu.getContent().getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = lWPopupMenu.getContent().getComponent(n2);
            if (component instanceof CheckboxMenuCommandItem) {
                CheckboxMenuCommandItem checkboxMenuCommandItem = (CheckboxMenuCommandItem)component;
                if (checkboxMenuCommandItem.getCommand().equals("WALLET_EXP_SSO")) {
                    return checkboxMenuCommandItem.getState();
                }
                AdminTRACE.out("OwmaDetailComponent: Unable to find Autologin menu item");
            }
            ++n2;
        }
        return false;
    }

    public boolean setAutoLoginStatus(boolean bl) {
        LWMenuBar lWMenuBar = ((OwmaApp)this.m_container).getOwmMenuBar();
        LWMenu lWMenu = (LWMenu)lWMenuBar.getContent().getComponent(0);
        LWPopupMenu lWPopupMenu = lWMenu.getSubMenu();
        if (lWPopupMenu == null) {
            AdminTRACE.out("OwmaDetailComponent: Popup menu is null");
        }
        int n = lWPopupMenu.getContent().getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = lWPopupMenu.getContent().getComponent(n2);
            if (component instanceof CheckboxMenuCommandItem) {
                CheckboxMenuCommandItem checkboxMenuCommandItem = (CheckboxMenuCommandItem)component;
                if (checkboxMenuCommandItem.getCommand().equals("WALLET_EXP_SSO")) {
                    checkboxMenuCommandItem.setState(bl);
                    return true;
                }
                AdminTRACE.out("OwmaDetailComponent: Unable to find Autologin menu item");
            }
            ++n2;
        }
        return false;
    }

    private void setEnabledToolBarItems() {
        int n = this.m_toolBar.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.m_toolBar.getItem(n2).setEnabled(true);
            ++n2;
        }
    }

    protected void showAboutBox() {
        OwmtAboutBox owmtAboutBox = new OwmtAboutBox((BufferedFrame)this.getContainer().getFrame(), owmMsgBundle.getMessage("1586", false));
        ((Dialog)((Object)owmtAboutBox)).show();
    }

    private ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar();
        Image image = null;
        ImageStrip imageStrip = null;
        ToolBarCommandButton toolBarCommandButton = null;
        image = this.m_imgBundle.getImage("1004");
        imageStrip = new ImageStrip(image, 16);
        toolBarCommandButton = new ToolBarCommandButton("WALLET_NEW", (ImageSet)imageStrip);
        toolBarCommandButton.setHelpText(owmMsgBundle.getMessage("1531", false));
        toolBar.addItem((ToolBarItem)toolBarCommandButton);
        image = this.m_imgBundle.getImage("1005");
        imageStrip = new ImageStrip(image, 16);
        toolBarCommandButton = new ToolBarCommandButton("WALLET_OPEN", (ImageSet)imageStrip);
        toolBarCommandButton.setHelpText(owmMsgBundle.getMessage("1532", false));
        toolBar.addItem((ToolBarItem)toolBarCommandButton);
        image = this.m_imgBundle.getImage("1020");
        imageStrip = new ImageStrip(image, 16);
        toolBarCommandButton = new ToolBarCommandButton("WALLET_SAVE", (ImageSet)imageStrip);
        toolBarCommandButton.setHelpText(owmMsgBundle.getMessage("1536", false));
        toolBar.addItem((ToolBarItem)toolBarCommandButton);
        image = this.m_imgBundle.getImage("1006");
        imageStrip = new ImageStrip(image, 16);
        toolBarCommandButton = new ToolBarCommandButton("WALLET_DEL", (ImageSet)imageStrip);
        toolBarCommandButton.setHelpText(owmMsgBundle.getMessage("1533", false));
        toolBar.addItem((ToolBarItem)toolBarCommandButton);
        return toolBar;
    }

    public void setCertificateStatus(int n) {
        this.m_clientObj.setCertStatus(n);
    }

    public int getCertificateStatus() {
        return this.m_clientObj.getCertStatus();
    }

    public ClientObject getClientObject() {
        return this.m_clientObj;
    }

    public OwmbPopupMenuFactory getPopupMenuFactory() {
        return this.m_popupMenuFactory;
    }

    public void refreshTree() {
        this.m_iRootDataSrc.refreshTree();
        ClientObject clientObject = this.getClientObject();
        if (clientObject instanceof OwmoClient && ((OwmoClient)clientObject).isWalletExists()) {
            DTreeItem dTreeItem = this.getTree().getRoot().getItem(0);
            dTreeItem.setExpanded(true);
            DTreeItem dTreeItem2 = dTreeItem.getItem(1);
            dTreeItem2.setExpanded(true);
        }
    }

    private void debug(String string) {
        AdminTRACE.out("OwmaDetailComponent: " + string);
    }
}

