/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.wltmgr.owmo;

import java.text.DateFormat;
import java.util.Date;

public class OwmoCertificate {
    private String m_subjName;
    private String m_issuerName;
    private String m_versionNo;
    private String m_serialNo;
    private int m_expDate;
    private int m_keySize;
    private String m_keyType;
    private String m_MD5fp;
    private String m_SHA1fp;

    public OwmoCertificate(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6, String string7) {
        this.m_subjName = string;
        this.m_issuerName = string2;
        this.m_versionNo = string3;
        this.m_serialNo = string4;
        this.m_expDate = n;
        this.m_keySize = n2;
        this.m_keyType = string5;
        this.m_MD5fp = string6;
        this.m_SHA1fp = string7;
    }

    public String getSubjectName() {
        return this.m_subjName;
    }

    public String getIssuerName() {
        return this.m_issuerName;
    }

    public String getVersionNo() {
        if (this.m_versionNo.startsWith("NZTTVERSION_")) {
            return this.m_versionNo.substring(12);
        }
        return this.m_versionNo;
    }

    public String getSerialNo() {
        if (this.m_serialNo.equals("0x")) {
            return new String("0x00");
        }
        return this.m_serialNo;
    }

    public String getExpDate() {
        Date date = new Date((long)this.m_expDate * 1000L);
        return DateFormat.getDateInstance(1).format(date);
    }

    public int getKeySize() {
        return this.m_keySize;
    }

    public String getKeyType() {
        return this.m_keyType;
    }

    public String getMD5FingerPrint() {
        return this.m_MD5fp;
    }

    public String getSHA1FingerPrint() {
        return this.m_SHA1fp;
    }

    public String toString() {
        return "Subject:    " + this.m_subjName + "\nIssuer:     " + this.m_issuerName + "\nVersion:    " + this.m_versionNo + "\nSerial:     " + this.m_serialNo + "\nExpiration: " + this.m_expDate + "\nKey Size:   " + this.m_keySize + "\nKey Type:   " + this.m_keyType + "\nMD5 FP:     " + this.m_MD5fp + "\nSHA1 FP:    " + this.m_SHA1fp;
    }
}

