/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.wltmgr.owmt;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import oracle.ewt.EwtContainer;
import oracle.ewt.border.Border;
import oracle.ewt.border.FrameBorder;
import oracle.ewt.button.PushButton;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.graphics.frame.LoweredFramePainter;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.hTree.HTreeEvent;
import oracle.ewt.hTree.HTreeItem;
import oracle.ewt.hTree.HTreeSelectionListener;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.FixedAlignmentPainter;
import oracle.ewt.painter.ImagePainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.splitter.Splitter;
import oracle.security.admin.util.AdminTRACE;
import oracle.security.admin.wltmgr.owmt.OwmtBaseDialog;
import oracle.security.admin.wltmgr.owmt.OwmtListDataSource;
import oracle.security.admin.wltmgr.owmt.OwmtUserHTree;
import oracle.security.admin.wltmgr.owmt.OwmtUserHTreeItem;

public class OwmtGetUserNameDialog
extends OwmtBaseDialog
implements ActionListener,
ComponentListener,
GridRowSelectListener,
HTreeSelectionListener {
    private static int IMAGE_COL_WIDTH = 15;
    private LWLabel rtlLabel;
    private LWTextField rtlField;
    private LWLabel filterLabel;
    private LWTextField filterField;
    private PushButton filterButton;
    private Grid m_listGrid;
    private OwmtListDataSource m_ds;
    private OwmtUserHTree objectTree;

    public OwmtGetUserNameDialog(BufferedFrame bufferedFrame, String string) {
        super(bufferedFrame, string);
    }

    protected EwtContainer createControlPanel() {
        ((Component)((Object)this)).setSize(450, 300);
        EwtContainer ewtContainer = new EwtContainer();
        GridBagLayout gridBagLayout = new GridBagLayout();
        ewtContainer.setLayout(gridBagLayout);
        String string = OwmtBaseDialog.owmMsgBundle.getMessage("1561", false);
        LWLabel lWLabel = new LWLabel(string, 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        ((GridBagLayout)ewtContainer.getLayout()).setConstraints((Component)lWLabel, gridBagConstraints);
        ewtContainer.add((Component)lWLabel);
        this.rtlField = new LWTextField();
        this.rtlField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        ((GridBagLayout)ewtContainer.getLayout()).setConstraints((Component)this.rtlField, gridBagConstraints);
        ewtContainer.add((Component)this.rtlField);
        ScrollBox scrollBox = this.createBrowseTreePanel();
        EwtContainer ewtContainer2 = this.createUserListPanel();
        Splitter splitter = new Splitter((Component)scrollBox, (Component)ewtContainer2, false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        ((GridBagLayout)ewtContainer.getLayout()).setConstraints((Component)splitter, gridBagConstraints);
        ewtContainer.add((Component)splitter);
        this.confirmButton.setLabel(OwmtBaseDialog.owmMsgBundle.getMessage("1005", false));
        return ewtContainer;
    }

    private ScrollBox createBrowseTreePanel() {
        try {
            this.objectTree = new OwmtUserHTree(this);
            this.objectTree.setBackground(Color.white);
            this.objectTree.addSelectionListener(this);
            this.objectTree.populateTree("Root");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ScrollBox scrollBox = new ScrollBox((Component)((Object)this.objectTree), 0, 0);
        scrollBox.setBorder((Border)new FrameBorder(2, LoweredFramePainter.getFramePainter()));
        return scrollBox;
    }

    public void hTreeSelectionChanging(HTreeEvent hTreeEvent) {
    }

    public void hTreeSelectionChanged(HTreeEvent hTreeEvent) {
        HTreeItem[] hTreeItemArray = this.objectTree.getSelectedItems();
        if (hTreeItemArray.length > 0) {
            OwmtUserHTreeItem owmtUserHTreeItem = (OwmtUserHTreeItem)hTreeItemArray[0];
            String string = owmtUserHTreeItem.getLabel();
            String string2 = owmtUserHTreeItem.getData();
            this.rtlField.setText(String.valueOf(string) + ":" + string2);
        }
    }

    private EwtContainer createUserListPanel() {
        EwtContainer ewtContainer = new EwtContainer();
        GridBagLayout gridBagLayout = new GridBagLayout();
        ewtContainer.setLayout(gridBagLayout);
        LWLabel lWLabel = new LWLabel(OwmtBaseDialog.owmMsgBundle.getMessage("1562", false), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 2, 0, 5);
        ((GridBagLayout)ewtContainer.getLayout()).setConstraints((Component)lWLabel, gridBagConstraints);
        ewtContainer.add((Component)lWLabel);
        this.filterField = new LWTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 2);
        ((GridBagLayout)ewtContainer.getLayout()).setConstraints((Component)this.filterField, gridBagConstraints);
        ewtContainer.add((Component)this.filterField);
        OwmtListDataSource owmtListDataSource = this.getListDataSource();
        this.m_listGrid = this.createGrid(owmtListDataSource);
        ScrollBox scrollBox = new ScrollBox((Component)this.m_listGrid, 0, 0);
        scrollBox.setBorder((Border)new FrameBorder(2, LoweredFramePainter.getFramePainter()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 2, 1, 2);
        ((GridBagLayout)ewtContainer.getLayout()).setConstraints((Component)scrollBox, gridBagConstraints);
        ewtContainer.add((Component)scrollBox);
        return ewtContainer;
    }

    private OwmtListDataSource getListDataSource() {
        this.m_ds = new OwmtListDataSource();
        int n = 0;
        while (n < 5) {
            this.m_ds.setListItem(n, "User_" + n);
            ++n;
        }
        return this.m_ds;
    }

    public void updateUserDataSource() {
    }

    protected Grid createGrid(OwmtListDataSource owmtListDataSource) {
        Grid grid = new Grid((TwoDDataSource)owmtListDataSource);
        grid.setDefaultRowHeight(20);
        grid.addComponentListener(this);
        grid.addRowSelectListener((GridRowSelectListener)this);
        grid.setGridSelection((GridSelection)new SingleRowSelection());
        grid.setColumnCellInputHandler(0, NullInputHandler.getCellInputHandler());
        grid.setDrawFocusCellHighlite(false);
        grid.setHorizontalSeparatorsVisible(false);
        grid.setVerticalSeparatorsVisible(false);
        grid.setColumnPainter(0, (Painter)new FixedAlignmentPainter((Painter)new ImagePainter(null, 0)));
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)complexAppearanceManager);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(0);
        appearance.setHorizontalJustify(3);
        return grid;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setColumnsWidth();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void rowDeselected(GridEvent gridEvent) {
    }

    public void rowDeselecting(GridEvent gridEvent) {
    }

    public void rowSelected(GridEvent gridEvent) {
        int[] nArray;
        GridSelection gridSelection;
        if (gridEvent.getSource() == this.m_listGrid) {
            this.m_listGrid.getGridSelection().setRowSelected(gridEvent.getRow(), true);
        }
        if ((gridSelection = this.m_listGrid.getGridSelection()) != null && (nArray = gridSelection.getSelectedRows()) != null) {
            String string = this.m_ds.getListItem(nArray[0]);
            this.rtlField.setText(string);
        }
    }

    public void rowSelecting(GridEvent gridEvent) {
    }

    protected void setColumnsWidth() {
        if (this.m_listGrid != null) {
            this.m_listGrid.setColumnWidth(0, IMAGE_COL_WIDTH);
            int n = this.m_listGrid.getInnerSize().width - IMAGE_COL_WIDTH;
            if (n > 0) {
                this.m_listGrid.setColumnWidth(1, n);
            }
        }
    }

    public void debug(String string) {
        AdminTRACE.out("OwmtGetUserNameDialog:" + string);
    }
}

