/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.admin.wltmgr.owmt;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import oracle.ewt.dTree.DTreeSelectionEvent;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.painter.FixedAlignmentPainter;
import oracle.ewt.painter.ImagePainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableScrollBox;
import oracle.security.admin.util.AdminTRACE;
import oracle.security.admin.util.AdminWindowsUtil;
import oracle.security.admin.wltmgr.owmb.OwmbDetailComponent;
import oracle.security.admin.wltmgr.owmb.OwmbPopupMenuFactory;
import oracle.security.admin.wltmgr.owmo.OwmoClient;
import oracle.security.admin.wltmgr.owmt.OwmtListDataSource;
import oracle.security.admin.wltmgr.owmt.OwmtTrustedCertGuiObject;
import oracle.sysman.emSDK.adminObj.client.ClientObject;
import oracle.sysman.emSDK.adminObj.client.GuiObject;
import oracle.sysman.emSDK.client.appComponent.TreeDetailAppComponent;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.DataDrivenTree;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeItem;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeNodeSelectionListener;
import oracle.sysman.emSDK.client.dataComponent.dataDrivenTree.TreeProxy;
import oracle.sysman.emSDK.client.guiComponent.popupMenu.PopupMenuSource;
import oracle.sysman.emSDK.common.nls.MessageBundle;

public class OwmtTcProxy
extends TreeProxy
implements PopupMenuSource,
TreeNodeSelectionListener,
ComponentListener {
    private int m_index;
    protected static MessageBundle owmMsgBundle = new MessageBundle("Owm");
    private String TRUSTED_CERT_NODE_LABEL;
    private SpreadTable m_listTable;

    public OwmtTcProxy(DataDrivenTree dataDrivenTree, int n) {
        super(dataDrivenTree);
        this.m_index = n;
        owmMsgBundle.setPackage("oracle.security.resources");
        this.TRUSTED_CERT_NODE_LABEL = owmMsgBundle.getMessage("1573", false);
    }

    public OwmtTcProxy() {
    }

    public Vector getRMenuCommandItems(TreeItem treeItem) {
        Object object = this.getTree().getAppComponent();
        if (object instanceof OwmbDetailComponent) {
            OwmbPopupMenuFactory owmbPopupMenuFactory = ((OwmbDetailComponent)((Object)object)).getPopupMenuFactory();
            if (treeItem.getLabel().equals(this.TRUSTED_CERT_NODE_LABEL)) {
                return owmbPopupMenuFactory.getTCFolderMenu();
            }
            return owmbPopupMenuFactory.getTCMenu();
        }
        return new Vector();
    }

    public void treeSelectionChanging(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
    }

    public void treeSelectionChanged(DTreeSelectionEvent dTreeSelectionEvent, TreeItem treeItem) {
        OwmbDetailComponent owmbDetailComponent;
        ClientObject clientObject;
        Object object = this.getTree().getAppComponent();
        AdminWindowsUtil.setCursor(3, (Component)this.getTree());
        if (object instanceof TreeDetailAppComponent && (clientObject = (owmbDetailComponent = (OwmbDetailComponent)((Object)object)).getClientObject()) instanceof OwmoClient) {
            if (!treeItem.getLabel().equals(this.TRUSTED_CERT_NODE_LABEL)) {
                OwmtTrustedCertGuiObject owmtTrustedCertGuiObject = new OwmtTrustedCertGuiObject((OwmoClient)owmbDetailComponent.getClientObject(), treeItem.getLabel(), this.m_index);
                owmbDetailComponent.getTreeDetail().showPropertyPanel((GuiObject)owmtTrustedCertGuiObject);
            } else {
                OwmtListDataSource owmtListDataSource = this.getCertListDataSource(owmbDetailComponent.getClientObject());
                this.m_listTable = this.createCertListTable(owmtListDataSource);
                TableScrollBox tableScrollBox = new TableScrollBox(this.m_listTable, 0, 0);
                owmbDetailComponent.getTreeDetail().showComponent((Component)tableScrollBox);
            }
        }
        AdminWindowsUtil.setCursor(0, (Component)this.getTree());
    }

    private OwmtListDataSource getCertListDataSource(ClientObject clientObject) {
        OwmtListDataSource owmtListDataSource = new OwmtListDataSource();
        Vector vector = ((OwmoClient)clientObject).getTrustedCertTableInfo();
        int n = vector.size();
        owmtListDataSource.setListItem(0, new String());
        owmtListDataSource.setListItem(1, owmMsgBundle.getMessage("1571", false));
        owmtListDataSource.setListItem(2, owmMsgBundle.getMessage("1667", false));
        owmtListDataSource.setListItem(3, owmMsgBundle.getMessage("1668", false));
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = (String[])vector.elementAt(n2);
            owmtListDataSource.setListItem(n2, stringArray);
            ++n2;
        }
        return owmtListDataSource;
    }

    private SpreadTable createCertListTable(OwmtListDataSource owmtListDataSource) {
        SpreadTable spreadTable = new SpreadTable((TwoDDataSource)owmtListDataSource, (OneDDataSource)owmtListDataSource, null);
        Grid grid = spreadTable.getGrid();
        grid.setDefaultRowHeight(20);
        grid.addComponentListener(this);
        grid.setGridSelection((GridSelection)new SingleRowSelection());
        grid.setColumnCellInputHandler(0, NullInputHandler.getCellInputHandler());
        grid.setDrawFocusCellHighlite(false);
        grid.setHorizontalSeparatorsVisible(false);
        grid.setVerticalSeparatorsVisible(false);
        grid.setColumnPainter(0, (Painter)new FixedAlignmentPainter((Painter)new ImagePainter(null, 0)));
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)complexAppearanceManager);
        Appearance appearance = complexAppearanceManager.getColumnAppearance(0);
        appearance.setHorizontalJustify(3);
        return spreadTable;
    }

    private void columnResize() {
        if (this.m_listTable == null) {
            return;
        }
        int n = (this.m_listTable.getGrid().getInnerSize().width - 20) / 7;
        if (n < 50) {
            n = 50;
        }
        if (n > 0) {
            this.m_listTable.setColumnWidth(0, 20);
            this.m_listTable.setColumnWidth(1, n * 4);
            this.m_listTable.setColumnWidth(2, n);
            this.m_listTable.setColumnWidth(3, n * 2);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.columnResize();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.columnResize();
    }

    private void debug(String string) {
        AdminTRACE.out("TC PROXY:" + string);
    }
}

