/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.wallet;

import java.util.Date;
import oracle.security.wallet.CertificateCache;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZIdentity;
import oracle.security.wallet.NZNative;

public class NZCertificate
extends NZIdentity {
    private String myIssuerName;
    private String mySerialNumber;
    private String myMD5Digest;
    private String mySHADigest;
    private String myVersion = "NZTTVERSION_INVALID_TYPE";
    private int myValidityState = 2;
    private int myStartDate;
    private int myExpiryDate;
    private String mySignatureAlgo;

    private NZCertificate() {
    }

    public NZCertificate(byte[] byArray) throws NZException {
        super(byArray);
        this.setCertificate(byArray);
    }

    private void setCertificate(byte[] byArray) throws NZException {
        CertificateCache certificateCache = NZNative.getCertificateCache(byArray);
        this.myIssuerName = certificateCache.myIssuerName;
        this.mySerialNumber = certificateCache.mySerialNumber;
        this.myMD5Digest = certificateCache.myMD5Digest;
        this.mySHADigest = certificateCache.mySHADigest;
        this.myVersion = certificateCache.myVersion;
        this.myStartDate = certificateCache.myStartDate;
        this.myExpiryDate = certificateCache.myExpiryDate;
        this.mySignatureAlgo = certificateCache.mySignatureAlgo;
    }

    public String getIssuerName() {
        return this.myIssuerName;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public int getStartDate() {
        return this.myStartDate;
    }

    public int getExpiryDate() {
        return this.myExpiryDate;
    }

    public int getValidityState() {
        return this.myValidityState;
    }

    public String getSignatureAlgo() {
        return this.mySignatureAlgo;
    }

    public String getSerialNumber() {
        return this.mySerialNumber;
    }

    public String getMD5Digest() {
        return this.myMD5Digest;
    }

    public String getSHA1Digest() {
        return this.mySHADigest;
    }

    public String toString() {
        String string = String.valueOf(super.toString()) + "\n" + "StartDate = " + new Date((long)this.myStartDate * 1000L).toString() + ", ExpDate = " + new Date((long)this.myExpiryDate * 1000L).toString() + ", MD5 = " + this.myMD5Digest + ", SHA1 = " + this.mySHADigest;
        return string;
    }
}

