/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.wallet;

import oracle.security.wallet.IdentityCache;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZNative;

public abstract class NZIdentity {
    protected String myDN;
    protected String myComment;
    protected String myIdentityType = "NZDST_INVALID_DATA_SOURCE";
    protected int myKeySize;
    protected String myKeyUsage = "NZTTKPUSAGE_ENCR_AND_SIGNATURE";
    protected byte[] myIdentityPtr;

    protected NZIdentity() {
    }

    protected NZIdentity(byte[] byArray) throws NZException {
        if (byArray == null) {
            throw new NZException("Identity ptr is null!");
        }
        this.setIdentity(byArray);
    }

    private void setIdentity(byte[] byArray) throws NZException {
        IdentityCache identityCache = NZNative.getIdentityCache(byArray);
        this.myDN = identityCache.myDN;
        this.myComment = identityCache.myComment;
        this.myIdentityType = identityCache.myIdentityType;
        this.myKeySize = identityCache.myKeySize;
        this.myKeyUsage = identityCache.myKeyUsage;
        this.myIdentityPtr = byArray;
    }

    public String getDN() {
        return this.myDN;
    }

    public String getSubName() {
        return this.getDN();
    }

    public String getComment() {
        return this.myComment;
    }

    public String getIdentityType() {
        return this.myIdentityType;
    }

    public int getKeySize() {
        return this.myKeySize;
    }

    public String getKeyType() {
        return "RSA";
    }

    byte[] getIdentityPtr() {
        return this.myIdentityPtr;
    }

    public String toB64Format() throws NZException {
        return NZNative.getIdentityB64Format(this.myIdentityPtr);
    }

    public String toString() {
        return "DN: " + this.myDN + "\tComment: " + this.myComment + "\tIdentType: " + this.myIdentityType + "\tKeysize: " + this.myKeySize;
    }
}

