/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.wallet;

import java.util.Enumeration;
import java.util.Vector;
import oracle.security.admin.util.AdminTRACE;
import oracle.security.wallet.CertificateCache;
import oracle.security.wallet.IdentityCache;
import oracle.security.wallet.NZCertChainException;
import oracle.security.wallet.NZException;
import oracle.security.wallet.PersonaCache;
import oracle.security.wallet.PersonaPvtCache;
import oracle.security.wallet.WalletCache;

public class NZNative {
    private static int myDbg = 4;
    private static byte[] oss_context;

    public NZNative() {
        myDbg = AdminTRACE.getTraceLevel();
    }

    static boolean isLibDomestic() {
        return NZNative.nativeIsLibDomestic(oss_context);
    }

    static WalletCache getWalletCache(byte[] byArray) throws NZException {
        WalletCache walletCache = new WalletCache();
        if (!NZNative.nativeGetWCache(oss_context, byArray, walletCache)) {
            throw new NZException("failed to get wallet cache");
        }
        return walletCache;
    }

    static Enumeration getWalletPersonas(byte[] byArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        byte[] byArray2 = NZNative.nativeGetWalletPersonaListPtr(oss_context, byArray);
        if (byArray2 == null) {
            AdminTRACE.out("Warning: Empty Persona List.");
        } else {
            byte[] byArray3 = byArray2;
            while (byArray3 != null) {
                vector.addElement(byArray3);
                byArray3 = NZNative.nativeGetNextPersonaPtr(byArray3);
            }
        }
        return vector.elements();
    }

    static IdentityCache getIdentityCache(byte[] byArray) throws NZException {
        IdentityCache identityCache = new IdentityCache();
        if (!NZNative.nativeGetICache(oss_context, byArray, identityCache)) {
            throw new NZException("failed to get identity cache");
        }
        return identityCache;
    }

    static CertificateCache getCertificateCache(byte[] byArray) throws NZException {
        CertificateCache certificateCache = new CertificateCache();
        if (!NZNative.nativeGetCCache(oss_context, byArray, certificateCache)) {
            throw new NZException("failed to get Cert cache");
        }
        return certificateCache;
    }

    static PersonaCache getPersonaCache(byte[] byArray) throws NZException {
        PersonaCache personaCache = new PersonaCache();
        if (!NZNative.nativeGetPCache(oss_context, byArray, personaCache)) {
            throw new NZException("failed to get Persona cache");
        }
        return personaCache;
    }

    static Enumeration getPersonaCertReqs(byte[] byArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        byte[] byArray2 = NZNative.nativeGetPersonaCertReqsList(oss_context, byArray);
        if (byArray2 == null) {
            AdminTRACE.out("Warning: Empty CertReq List.");
        } else {
            byte[] byArray3 = byArray2;
            while (byArray3 != null) {
                vector.addElement(byArray3);
                byArray3 = NZNative.nativeGetNextCertReqPtr(byArray3);
            }
        }
        return vector.elements();
    }

    static Enumeration getPersonaCertificates(byte[] byArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        byte[] byArray2 = NZNative.nativeGetPersonaCertsList(oss_context, byArray);
        if (byArray2 == null) {
            AdminTRACE.out("Warning: Empty Cert List.");
        } else {
            byte[] byArray3 = byArray2;
            while (byArray3 != null) {
                vector.addElement(byArray3);
                byArray3 = NZNative.nativeGetNextCertPtr(byArray3);
            }
        }
        return vector.elements();
    }

    static Enumeration getPersonaTrustpoints(byte[] byArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        byte[] byArray2 = NZNative.nativeGetPersonaTPsList(oss_context, byArray);
        if (byArray2 == null) {
            AdminTRACE.out("Warning: Empty TP List.");
        } else {
            byte[] byArray3 = byArray2;
            while (byArray3 != null) {
                vector.addElement(byArray3);
                byArray3 = NZNative.nativeGetNextTPPtr(byArray3);
            }
        }
        return vector.elements();
    }

    static Enumeration getPersonaPrivates(byte[] byArray) {
        Vector<byte[]> vector = new Vector<byte[]>();
        byte[] byArray2 = NZNative.nativeGetPersonaPrivatesList(oss_context, byArray);
        if (byArray2 == null) {
            AdminTRACE.out("Warning: Empty Private List.");
        } else {
            byte[] byArray3 = byArray2;
            while (byArray3 != null) {
                vector.addElement(byArray3);
                byArray3 = NZNative.nativeGetNextPPrivPtr(byArray3);
            }
        }
        return vector.elements();
    }

    static PersonaPvtCache getPersonaPvtCache(byte[] byArray) throws NZException {
        PersonaPvtCache personaPvtCache = new PersonaPvtCache();
        if (!NZNative.nativeGetPPrivCache(oss_context, byArray, personaPvtCache)) {
            throw new NZException("failed to get Persona Private cache");
        }
        return personaPvtCache;
    }

    static String getIdentityB64Format(byte[] byArray) throws NZException {
        String string = NZNative.nativeGetIdentityB64Format(oss_context, byArray);
        if (string == null) {
            throw new NZException("Failed to obtain B64 Format from Identity.");
        }
        return string;
    }

    static byte[] getVKeyBytes(byte[] byArray, String string) throws NZException {
        byte[] byArray2 = NZNative.nativeGetVKeyBytes(oss_context, byArray, string);
        if (byArray2 == null) {
            throw new NZException("Failed to obtain Private Key data from Persona Private");
        }
        return byArray2;
    }

    static boolean addCertReqToPersona(byte[] byArray, String string, int n, String string2, Vector vector) throws NZException {
        boolean bl = NZNative.nativeAddCertReq(oss_context, byArray, string, n, string2, vector);
        if (!bl) {
            throw new NZException("Failed to add Certreq.");
        }
        return bl;
    }

    static boolean exportCertReqFromPersona(byte[] byArray, String string) {
        return NZNative.nativeExportCertReq(oss_context, byArray, string);
    }

    static byte[] installB64CertInWallet(byte[] byArray, byte[] byArray2, String string, String string2) throws NZException {
        Vector vector = new Vector();
        byte[] byArray3 = NZNative.nativeInstallB64Cert(oss_context, byArray, byArray2, string, string2, vector);
        if (vector.size() > 0 && ((String)vector.firstElement()).equals("CertChain")) {
            throw new NZCertChainException();
        }
        if (byArray3 == null) {
            throw new NZException("Failed to install Cert.");
        }
        return byArray3;
    }

    static boolean deleteCertOrTPFromWallet(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NZException {
        boolean bl = NZNative.nativeDeleteCertOrTP(oss_context, byArray, byArray2, byArray3);
        if (!bl) {
            throw new NZException("Unable to delete Cert/TP, Possibly Cert-Chain Check failed..");
        }
        return bl;
    }

    static boolean setPersonaName(byte[] byArray, String string) {
        return true;
    }

    static boolean setWalletWrl(byte[] byArray, String string) {
        return true;
    }

    static boolean setWalletRioType(byte[] byArray, int n) {
        return true;
    }

    static boolean setWalletLdapDN(byte[] byArray, String string) {
        return true;
    }

    static boolean setWalletPassword(byte[] byArray, String string) {
        return true;
    }

    static byte[] createWallet() throws NZException {
        byte[] byArray = NZNative.nativeCreateWallet(oss_context);
        if (byArray == null) {
            throw new NZException("failed to Create New Wallet.");
        }
        return byArray;
    }

    static boolean destroyWallet(byte[] byArray) {
        AdminTRACE.out("Destroying wallet...");
        NZNative.nativeDestroyWallet(oss_context, byArray);
        return true;
    }

    static byte[] loadWallet(String string, String string2) {
        byte[] byArray = NZNative.nativeLoadEncWallet(oss_context, string, string2);
        if (byArray == null) {
            AdminTRACE.out("Loadwallet failed with args: Wrl=" + string + ", pwd=" + string2);
        }
        return byArray;
    }

    static boolean storeSSOWallet(byte[] byArray, String string, String string2) throws NZException {
        boolean bl = NZNative.nativeStoreSSOWallet(oss_context, byArray, string, string2);
        if (!bl) {
            throw new NZException("Store SSO Wallet failed.");
        }
        return bl;
    }

    static boolean storeWallet(byte[] byArray, String string, String string2) throws NZException {
        boolean bl = NZNative.nativeStoreEncWallet(oss_context, byArray, string, string2);
        if (!bl) {
            throw new NZException("StoreWallet failed.");
        }
        return bl;
    }

    static String getDefaultWRL() throws NZException {
        String string = NZNative.nativeGetDefaultWRL(oss_context);
        if (string == null) {
            throw new NZException("Failed to obtain default WRL for wallets.");
        }
        return string;
    }

    private static native void nativeInitialize();

    private static native boolean nativeGetWCache(byte[] var0, byte[] var1, WalletCache var2);

    private static native boolean nativeGetPCache(byte[] var0, byte[] var1, PersonaCache var2);

    private static native boolean nativeGetICache(byte[] var0, byte[] var1, IdentityCache var2);

    private static native boolean nativeGetCCache(byte[] var0, byte[] var1, CertificateCache var2);

    private static native boolean nativeGetPPrivCache(byte[] var0, byte[] var1, PersonaPvtCache var2);

    private static native String nativeGetIdentityB64Format(byte[] var0, byte[] var1);

    private static native byte[] nativeGetVKeyBytes(byte[] var0, byte[] var1, String var2);

    private static native byte[] nativeGetNextPersonaPtr(byte[] var0);

    private static native byte[] nativeGetWalletPersonaListPtr(byte[] var0, byte[] var1);

    private static native byte[] nativeGetNextCertReqPtr(byte[] var0);

    private static native byte[] nativeGetPersonaCertReqsList(byte[] var0, byte[] var1);

    private static native byte[] nativeGetNextCertPtr(byte[] var0);

    private static native byte[] nativeGetPersonaCertsList(byte[] var0, byte[] var1);

    private static native byte[] nativeGetNextTPPtr(byte[] var0);

    private static native byte[] nativeGetPersonaTPsList(byte[] var0, byte[] var1);

    private static native byte[] nativeGetNextPPrivPtr(byte[] var0);

    private static native byte[] nativeGetPersonaPrivatesList(byte[] var0, byte[] var1);

    private static native boolean nativeAddCertReq(byte[] var0, byte[] var1, String var2, int var3, String var4, Vector var5);

    private static native byte[] nativeInstallB64Cert(byte[] var0, byte[] var1, byte[] var2, String var3, String var4, Vector var5);

    private static native boolean nativeDeleteCertOrTP(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    private static native boolean nativeExportCertReq(byte[] var0, byte[] var1, String var2);

    private static native byte[] nativeCreateWallet(byte[] var0);

    private static native boolean nativeDestroyWallet(byte[] var0, byte[] var1);

    private static native boolean nativeStoreSSOWallet(byte[] var0, byte[] var1, String var2, String var3);

    private static native boolean nativeStoreEncWallet(byte[] var0, byte[] var1, String var2, String var3);

    private static native byte[] nativeLoadEncWallet(byte[] var0, String var1, String var2);

    private static native String nativeGetDefaultWRL(byte[] var0);

    private static native boolean nativeIsLibDomestic(byte[] var0);

    static {
        System.loadLibrary("owm2");
        NZNative.nativeInitialize();
    }
}

