/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.wallet;

import java.util.Enumeration;
import java.util.Vector;
import oracle.security.wallet.NZCertReq;
import oracle.security.wallet.NZCertificate;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZIdentity;
import oracle.security.wallet.NZNative;
import oracle.security.wallet.NZPersonaPvt;
import oracle.security.wallet.PersonaCache;
import sun.misc.BASE64Encoder;

public class NZPersona {
    private static final String ENC_PKEY_HEADER = "-----BEGIN ENCRYPTED PRIVATE KEY-----\n";
    private static final String ENC_PKEY_FOOTER = "-----END ENCRYPTED PRIVATE KEY-----\n";
    private String myName = "Default_Persona";
    private int myUsage = 0;
    private int myState = 0;
    private Vector myCertRequests = new Vector();
    private Vector myCertificates = new Vector();
    private Vector myPersonaPvts = new Vector();
    private Vector myUtpList = new Vector();
    private Vector myPtpList = new Vector();
    private Vector myEtpList = new Vector();
    private byte[] myPersonaPtr;

    public String toString() {
        String string = "Printing Persona\n";
        string = String.valueOf(string) + "State: " + this.myState + "\n";
        string = String.valueOf(string) + "\t Printing CertReqs..\n";
        Enumeration enumeration = this.myCertRequests.elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + ((NZIdentity)enumeration.nextElement()).toString();
            string = String.valueOf(string) + "\n";
        }
        string = String.valueOf(string) + " Printing Certs..\n";
        enumeration = this.myCertificates.elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + ((NZIdentity)enumeration.nextElement()).toString();
            string = String.valueOf(string) + "\n";
        }
        string = String.valueOf(string) + " Printing UTPs..\n";
        enumeration = this.myUtpList.elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + ((NZIdentity)enumeration.nextElement()).toString();
            string = String.valueOf(string) + "\n";
        }
        string = String.valueOf(string) + " Printing PTPs..\n";
        enumeration = this.myPtpList.elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + ((NZIdentity)enumeration.nextElement()).toString();
            string = String.valueOf(string) + "\n";
        }
        string = String.valueOf(string) + " Printing ETPs..\n";
        enumeration = this.myEtpList.elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + ((NZIdentity)enumeration.nextElement()).toString();
            string = String.valueOf(string) + "\n";
        }
        return string;
    }

    private NZPersona() throws NZException {
    }

    public NZPersona(byte[] byArray) throws NZException {
        if (byArray == null) {
            throw new NZException("Persona ptr is NULL");
        }
        this.setPersona(byArray);
    }

    private void setPersona(byte[] byArray) throws NZException {
        PersonaCache personaCache = NZNative.getPersonaCache(byArray);
        this.myName = personaCache.myName;
        this.myUsage = personaCache.myUsage;
        this.myState = personaCache.myState;
        this.myPersonaPtr = byArray;
        this.myCertRequests = this.createCertReqsVec(byArray);
        this.myCertificates = this.createCertificatesVec(byArray);
        this.createTPsVec(byArray);
        this.myPersonaPvts = this.createPPvtsVec(byArray);
    }

    private Vector createCertReqsVec(byte[] byArray) throws NZException {
        Vector<NZCertReq> vector = new Vector<NZCertReq>();
        Enumeration enumeration = NZNative.getPersonaCertReqs(byArray);
        while (enumeration.hasMoreElements()) {
            NZCertReq nZCertReq = new NZCertReq((byte[])enumeration.nextElement());
            vector.addElement(nZCertReq);
        }
        return vector;
    }

    private Vector createCertificatesVec(byte[] byArray) throws NZException {
        Vector<NZCertificate> vector = new Vector<NZCertificate>();
        Enumeration enumeration = NZNative.getPersonaCertificates(byArray);
        while (enumeration.hasMoreElements()) {
            NZCertificate nZCertificate = new NZCertificate((byte[])enumeration.nextElement());
            vector.addElement(nZCertificate);
        }
        return vector;
    }

    private void createTPsVec(byte[] byArray) throws NZException {
        this.myUtpList.removeAllElements();
        this.myPtpList.removeAllElements();
        this.myEtpList.removeAllElements();
        Enumeration enumeration = NZNative.getPersonaTrustpoints(byArray);
        while (enumeration.hasMoreElements()) {
            NZCertificate nZCertificate = new NZCertificate((byte[])enumeration.nextElement());
            if (nZCertificate.getIdentityType().equals("NZDST_CLEAR_UTP")) {
                this.myUtpList.addElement(nZCertificate);
                continue;
            }
            if (nZCertificate.getIdentityType().equals("NZDST_CLEAR_PTP")) {
                this.myPtpList.addElement(nZCertificate);
                continue;
            }
            if (!nZCertificate.getIdentityType().equals("NZDST_CLEAR_ETP")) continue;
            this.myEtpList.addElement(nZCertificate);
        }
    }

    private Vector createPPvtsVec(byte[] byArray) throws NZException {
        Vector<NZPersonaPvt> vector = new Vector<NZPersonaPvt>();
        Enumeration enumeration = NZNative.getPersonaPrivates(byArray);
        while (enumeration.hasMoreElements()) {
            NZPersonaPvt nZPersonaPvt = new NZPersonaPvt((byte[])enumeration.nextElement());
            vector.addElement(nZPersonaPvt);
        }
        return vector;
    }

    public boolean addCertRequest(String string, int n, String string2) throws NZException {
        Vector vector = new Vector(2);
        if (NZNative.addCertReqToPersona(this.myPersonaPtr, string, n, string2, vector)) {
            this.setPersona(this.myPersonaPtr);
            return true;
        }
        return false;
    }

    public boolean exportCertReq(String string) throws NZException {
        if (this.myCertRequests.size() == 0) {
            throw new NZException("No Cert Request to export !");
        }
        return NZNative.exportCertReqFromPersona(this.myPersonaPtr, string);
    }

    public boolean setName(String string) {
        this.myName = string;
        return true;
    }

    public String getName() {
        return this.myName;
    }

    public String getUsage() {
        return String.valueOf(this.myUsage);
    }

    public String getState() {
        return String.valueOf(this.myState);
    }

    public int getPvtKeyCount() {
        return this.myPersonaPvts.size();
    }

    public byte[] getPrivateKeyData(String string) throws NZException {
        return ((NZPersonaPvt)this.myPersonaPvts.elementAt(0)).getPrivateKeyBytes(string);
    }

    public String getB64PrivateKeyData(String string) throws NZException {
        byte[] byArray = this.getPrivateKeyData(string);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string2 = bASE64Encoder.encodeBuffer(byArray);
        return ENC_PKEY_HEADER + string2 + ENC_PKEY_FOOTER;
    }

    public int getCertReqCount() {
        return this.myCertRequests.size();
    }

    public NZCertReq getCertRequest(int n) {
        return (NZCertReq)this.myCertRequests.elementAt(n);
    }

    public int getCertificateCount() {
        return this.myCertificates.size();
    }

    public NZCertificate getCertificate(int n) {
        return (NZCertificate)this.myCertificates.elementAt(n);
    }

    public int getUTPCount() {
        return this.myUtpList.size();
    }

    public NZCertificate getUTPCertificate(int n) {
        return (NZCertificate)this.myUtpList.elementAt(n);
    }

    public int getPTPCount() {
        return this.myPtpList.size();
    }

    public NZCertificate getPTPCertificate(int n) {
        return (NZCertificate)this.myPtpList.elementAt(n);
    }

    public int getETPCount() {
        return this.myEtpList.size();
    }

    public NZCertificate getETPCertificate(int n) {
        return (NZCertificate)this.myEtpList.elementAt(n);
    }

    byte[] getPersonaPtr() {
        return this.myPersonaPtr;
    }
}

