/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.wallet;

import oracle.security.wallet.NZException;
import oracle.security.wallet.NZNative;
import oracle.security.wallet.PersonaPvtCache;

public class NZPersonaPvt {
    private int myKeyUsage = 0;
    private int myCipherType;
    private byte[] myPersonaPvtPtr;

    private NZPersonaPvt() {
    }

    public NZPersonaPvt(byte[] byArray) throws NZException {
        if (byArray == null) {
            throw new NZException("Persona-Private ptr is NULL");
        }
        this.setPersonaPvt(byArray);
    }

    private void setPersonaPvt(byte[] byArray) throws NZException {
        PersonaPvtCache personaPvtCache = NZNative.getPersonaPvtCache(byArray);
        this.myCipherType = personaPvtCache.myCipherType;
        this.myKeyUsage = personaPvtCache.myKeyUsage;
        this.myPersonaPvtPtr = byArray;
    }

    public int getCipherType() {
        return this.myCipherType;
    }

    public int getKeyUsage() {
        return this.myKeyUsage;
    }

    public byte[] getPrivateKeyBytes(String string) throws NZException {
        return NZNative.getVKeyBytes(this.myPersonaPvtPtr, string);
    }
}

