/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.wallet.owmcl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import oracle.security.wallet.DBG;
import oracle.security.wallet.NZCertReq;
import oracle.security.wallet.NZCertificate;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZNative;
import oracle.security.wallet.NZPersona;
import oracle.security.wallet.NZWallet;

public class OwmclRun {
    private int m_certStatus;
    private NZWallet nzWalletObj;
    private boolean m_walletExists;
    public static final String cacertstr = "-----BEGIN CERTIFICATE-----\nMIICjjCCAfegAwIBAgIBATANBgkqhkiG9w0BAQQFADBrMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGT3JhY2xlMSgwJgYDVQQLEx9FbnRlcnByaXNlIEFwcGxpY2F0aW9uIFNlcnZpY2VzMSEwHwYDVQQDExhFQVNRQSBDZXJ0aWZpY2F0ZSBTZXJ2ZXIwHhcNOTgwNDE1MDA0NTQ1WhcNMDAwNDE0MDA0NTQ1WjBrMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGT3JhY2xlMSgwJgYDVQQLEx9FbnRlcnByaXNlIEFwcGxpY2F0aW9uIFNlcnZpY2VzMSEwHwYDVQQDExhFQVNRQSBDZXJ0aWZpY2F0ZSBTZXJ2ZXIwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANi0bMVLgXMLZZKPg89YhtZ23vtbq2DV7ofReEqvki4Xz9Vvua24YAi3qduCwfLWpznjSca/kNC9inU417vSq2ckpmtrfYgBI+4BbOM9/Moc8491hOmJXyQLJ+Gbhhijp/i/AZ6S/UEApwSJdNV40EIat1zSiuiGPtIa7sscekBTAgMBAAGjQjBAMB0GA1UdDgQWBBQMIfAS4l8gVcNru25g07xs7DURjDAfBgNVHSMEGDAWgBQMIfAS4l8gVcNru25g07xs7DURjDANBgkqhkiG9w0BAQQFAAOBgQDJL7u3HvNdtbeeA/MoMNoFet3Rat89/Im1lukJRZ5MMm+a45c9LdwXAfbPr2PgNvwEUH6g4eVRVBwi2Nel+yp8bmui8MC50g/5uVB72g/5wGbzvt8VxSeQ84muzi91dhZlwVEt6WV8Qkc7m7+R5Y2h56gcL87gxJx6cwoUBjjqQg==\n-----END CERTIFICATE-----\n";

    public static void main(String[] stringArray) {
        try {
            OwmclRun owmclRun = new OwmclRun();
            new NZNative();
            System.out.println("");
            System.out.println("**********************************************************");
            System.out.println("*      Oracle Wallet Manager Command Line Version        *");
            System.out.println("*                   Release 2.0                          *");
            System.out.println("**********************************************************");
            System.out.println("");
            if (!owmclRun.createEmptyWallet()) {
                return;
            }
            DBG.debug("The default System WRL is: " + owmclRun.getDefaultWRL());
            DBG.debug("\n The LIBRARY type is " + (owmclRun.libIsDomestic() ? "DOMESTIC" : "EXPORT"));
            if (stringArray != null && stringArray.length > 0 && stringArray[0].equals("CR")) {
                if (!owmclRun.addCertRequest()) {
                    return;
                }
                if (!owmclRun.installCertificate("/home/arswamin/CERTS", "cert1.txt", "NZDST_CLEAR_PTP")) {
                    return;
                }
                DBG.debug("installed TP cert from /home/arswamin/CERTS/cert1.txt");
                if (!owmclRun.installCertificate("/home/arswamin/CERTS", "cert2.txt", "NZDST_CLEAR_PTP")) {
                    return;
                }
                DBG.debug("installed TP cert from /home/arswamin/CERTS/cert2.txt");
                owmclRun.printTrustPointInfo();
                owmclRun.setWRL("file:/tmp/WALLETS/WALLET_CR");
                if (owmclRun.storeWallet()) {
                    DBG.debug("Stored encrypted CR Wallet in dir:/tmp/WALLETS/WALLET_CR");
                }
            } else {
                if (!owmclRun.loadWallet("file:/tmp/WALLETS/WALLET_CR", "password")) {
                    return;
                }
                DBG.debug("***>Entering a block for expected failure..");
                if (!owmclRun.installCertificate("/tmp/WALLETS/WALLET_WITH_CERT", "b64cert.txt", "NZDST_CERTIFICATE")) {
                    DBG.debug("failed to install Cert when CA cert not present");
                }
                DBG.debug("***>Exiting a block for expected failure..");
                if (!owmclRun.installCACert(cacertstr)) {
                    return;
                }
                if (!owmclRun.installCertificate("/tmp/WALLETS/WALLET_WITH_CERT", "b64cert.txt", "NZDST_CERTIFICATE")) {
                    return;
                }
                DBG.debug("++++++ Testing install of VERISIGN TPs +++ \n");
                if (!owmclRun.installCACert("-----BEGIN CERTIFICATE-----\nMIICPDCCAaUCEDJQM89Q0VbzXIGtZVxPyCUwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTIwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDlGb9to1ZhLZlIcfZn3rmN67eehoAKkQ76OCWvRoiC5XOooJskXQ0fzGVuDLDQVoQYh5oGmxChc9+0WDlrbsH2FdWoqD+qEgaNMax/sDTXjzRniAnNFBHiTkVWaR94AoDa3EeRKbs2yWNcxeDXLYd7obcysHswuiovMaruo2fa2wIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAEtEZmBoZOSYG/OwcuaViXzde7OVwB0u2NgZ0C00PcZQmhCGjKo/O6gE/DdSlcPZydvN8oYGxLEb8IKIMEKOF1AcZHq4PplJdJf8rAJD+5YMVgQlDHx8h50kp9jwMim1pN9dokzFFjKoQvZFprY2ueC/ZTaTwtLXa9zeWdaiNfhF\n-----END CERTIFICATE-----\n")) {
                    return;
                }
                if (!owmclRun.installCACert("-----BEGIN CERTIFICATE-----\nMIICPTCCAaYCEQC6WslMBTuS1qe2307QU5INMA0GCSqGSIb3DQEBAgUAMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05NjAxMjkwMDAwMDBaFw0wNDAxMDcyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAtlqLow1qI4OAa885h/QhEzMGTCWi7VUSl8WngLn6g8EgoPovFQ18oWBrfnks+gYPOq72G2+x0v8vKFJfg31LxHq3+GYfgFT8t8KOWUoUV0bRmpO+QZEDuxWAk1zr58wIbD8+s0r8/0tsI9VQgiZEGY4jw3HqGSRHBJ51v8imAB8CAwEAATANBgkqhkiG9w0BAQIFAAOBgQC2AB+TV6QHp0DOZUA/VV7t7/pUSaUw1iF8YYfug5MLv7Qz8pisnwa/TqjOFIFMywROWMPPX+5815pvy0GKt3+BuP+EYcYnQ2UdDOyxAArdG6S7x3ggKLKi3TaVLuFUT79guXdoEZkj6OpS6KoATmdOu5C1RZtG644W78QzWzM91Q==\n-----END CERTIFICATE-----\n")) {
                    return;
                }
                if (!owmclRun.installCACert("-----BEGIN CERTIFICATE-----\nMIICPTCCAaYCEQDknv3zOugOz6URPhmkJAIyMA0GCSqGSIb3DQEBAgUAMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05NjAxMjkwMDAwMDBaFw0wNDAxMDcyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAyVxZnvIbigEUtBDfBEDb41evakVAj4QMC9Ez2dkRz+4CWB8l9yqoRAWq7AMfeH+ek7maAKojfdashaJjRcdyJ8z0TMZ1cdI5709C8HXfCpDGjiBvmA/4rCNfcCk2pMmG57GaIMtTpYXnPb59mv4kRTPcdhXtD6JxZExlLoFoRacCAwEAATANBgkqhkiG9w0BAQIFAAOBgQBhcOwvP579K+ZoVCGwZ3kIDCCWMYoNer62Jt95LCJpSTbjl3diYaIy13pUITa6Ask05yXaRDWw0lyAXbOU+Pms7qRgdSoflUkjsUp89LNHciFbfperVKxi513srpvSybIk+4Kt6WcVS7qqpvCXoPawl1cAyAw8CaCCBLpB2veZpA==\n-----END CERTIFICATE-----\n")) {
                    return;
                }
                DBG.debug("++++++ END Testing install of VERISIGN TPs +++ \n");
                owmclRun.setWRL("file:/tmp/WALLETS/WALLET_WITH_CERT");
                if (owmclRun.storeWallet()) {
                    DBG.debug("Stored encrypted CR+Cert Wallet in dir:/tmp/WALLETS/WALLET_WITH_CERT");
                }
                owmclRun.dumpWallet();
                String string = owmclRun.getCertRequest(0).toB64Format();
                DBG.debug("Printing one certrequest..");
                DBG.debug(string);
                string = owmclRun.getPTPCertificate(0).toB64Format();
                DBG.debug("Printing one Trustpoint..");
                DBG.debug(string);
                DBG.debug("\n");
                if (!owmclRun.loadWallet("file:/tmp/WALLETS/WALLET_WITH_CERT", "password")) {
                    DBG.debug("Loading of wallet WITH usercert + CA cert fails.");
                } else {
                    DBG.debug("Successfully LOADED wallet WITH usercert + CA Cert.");
                }
                owmclRun.dumpWallet();
                string = owmclRun.getCertRequest(0).toB64Format();
                DBG.debug("Printing one certrequest..");
                DBG.debug(string);
                string = owmclRun.getPTPCertificate(0).toB64Format();
                DBG.debug("Printing one Trustpoint..");
                DBG.debug(string);
                DBG.debug("====>>Entering second  block for expected failure..");
                if (!owmclRun.installCertificate("/tmp/WALLETS/WALLET_WITH_CERT", "b64cert.txt", "NZDST_CERTIFICATE")) {
                    DBG.debug("Attempt to install a preexisting cert again failed.");
                } else {
                    owmclRun.setWRL("file:/tmp/WALLETS/WALLET_WITH_CERT");
                    if (owmclRun.storeWallet()) {
                        DBG.debug("WARNING-UNEXPECTED: Stored encrypted CR+Cert Wallet in dir:/tmp/WALLETS/WALLET_WITH_CERT");
                    }
                }
                DBG.debug("====>>Exiting second block for expected failure..");
            }
            owmclRun.dumpWallet();
            DBG.debug("!!!!!!!!>> Entering expected failure block for deletion..");
            if (owmclRun.deleteCACert()) {
                DBG.debug("WARNING-UNEXPECTED: deleted CA cert from wallet even while the user cert exists.");
            } else {
                DBG.debug("Failed to delete CA cert.");
            }
            DBG.debug("!!!!!!!!>> Exiting expected failure block for deletion..");
            if (!owmclRun.deleteUserCert()) {
                DBG.debug("Failed to delete user cert.");
                return;
            }
            DBG.debug("Deleted user cert successfully.");
            if (!owmclRun.deleteCACert()) {
                DBG.debug("Failed to delete CA cert.");
                return;
            }
            DBG.debug("Deleted CA cert successfully.");
            owmclRun.dumpWallet();
            owmclRun.setWRL("file:/tmp/WALLETS/WALLET_WITH_CERT");
            DBG.debug("Starting MEM LEAK TESTING ");
            if (!owmclRun.loadWallet("file:/tmp/WALLETS/WALLET_WITH_CERT", "password")) {
                return;
            }
            if (!owmclRun.loadWallet("file:/tmp/WALLETS/WALLET_WITH_CERT", "password")) {
                return;
            }
            if (!owmclRun.loadWallet("file:/tmp/WALLETS/WALLET_WITH_CERT", "password")) {
                return;
            }
            if (!owmclRun.loadWallet("file:/tmp/WALLETS/WALLET_WITH_CERT", "password")) {
                return;
            }
            if (!owmclRun.loadWallet("file:/tmp/WALLETS/WALLET_WITH_CERT", "password")) {
                return;
            }
            DBG.debug("Loaded Wallet from file:/tmp/WALLETS/WALLET_WITH_CERT");
            DBG.debug("Printing  Wallet loaded back from file.");
            owmclRun.dumpWallet();
            DBG.debug("ENDED MEM LEAK TESTING ");
            DBG.debug("Start testing NON-WRITEABLE path.");
            owmclRun.setWRL("file:/tmp/foobar");
            owmclRun.storeWallet();
            owmclRun.setWRL("file:/etc/ORACLE/WALLET/arswamin");
            owmclRun.storeWallet();
            DBG.debug("ENDED NON-WRITEABLE path TESTING ");
            return;
        }
        catch (NZException nZException) {
            System.out.println(nZException.toString());
            nZException.printStackTrace();
            return;
        }
    }

    public boolean libIsDomestic() {
        return NZWallet.isSSLLibDomestic();
    }

    public boolean deleteCACert() {
        boolean bl = false;
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            NZCertificate nZCertificate = nZPersona.getPTPCertificate(2);
            bl = this.nzWalletObj.deleteCertOrTP(nZPersona, nZCertificate);
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            System.out.println(string);
        }
        return bl;
    }

    public boolean deleteUserCert() {
        boolean bl = false;
        try {
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            NZCertificate nZCertificate = nZPersona.getCertificate(0);
            bl = this.nzWalletObj.deleteCertOrTP(nZPersona, nZCertificate);
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            System.out.println(string);
        }
        return bl;
    }

    public void dumpWallet() {
        DBG.debug(this.nzWalletObj.toString());
        DBG.debug("\n");
    }

    public String getDefaultWRL() throws NZException {
        return NZWallet.getDefaultWRL();
    }

    public NZWallet getWalletObj() {
        return this.nzWalletObj;
    }

    public void setWalletObj(NZWallet nZWallet) {
        this.nzWalletObj = nZWallet;
    }

    public boolean installCACertEx(String string, String string2) throws NZException {
        NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        return this.nzWalletObj.installB64Cert(nZPersona, string2, string);
    }

    public boolean installCACert(String string) throws NZException {
        NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
        return this.nzWalletObj.installB64Cert(nZPersona, "NZDST_CLEAR_PTP", string);
    }

    public boolean loadWallet(String string, String string2) throws NZException {
        this.nzWalletObj.freeWalletCMem();
        this.nzWalletObj = null;
        System.gc();
        this.nzWalletObj = NZWallet.loadWallet(string, string2);
        this.nzWalletObj.setWRL(string);
        this.nzWalletObj.setPassword(string2);
        return true;
    }

    public NZCertReq getCertRequest(int n) {
        return this.nzWalletObj.getPersonabyIndex(0).getCertRequest(n);
    }

    public NZCertificate getPTPCertificate(int n) {
        return this.nzWalletObj.getPersonabyIndex(0).getPTPCertificate(n);
    }

    public boolean setWRL(String string) {
        return this.nzWalletObj.setWRL(string);
    }

    public boolean storeWallet() {
        boolean bl = false;
        try {
            bl = this.nzWalletObj.storeWallet();
        }
        catch (NZException nZException) {
            String string = nZException.toString();
            System.out.println(string);
        }
        return bl;
    }

    public boolean createEmptyWallet() {
        Object object;
        System.out.println("Creating empty wallet...");
        System.out.println("Enter something to move ahead");
        try {
            object = new byte[100];
            System.in.read((byte[])object);
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.createEmptyWallet("password")) {
            System.out.println("Wallet creation sucessful");
            object = this.nzWalletObj.toString();
            System.out.println((String)object);
            return true;
        }
        System.out.println("Wallet creation fail");
        return false;
    }

    private boolean createEmptyWallet(String string) {
        this.nzWalletObj = null;
        NZPersona nZPersona = null;
        try {
            this.nzWalletObj = new NZWallet(string);
            System.out.println("finished new NZWallet()");
            this.m_walletExists = true;
            nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            this.printTrustPointInfo();
            return true;
        }
        catch (NZException nZException) {
            String string2 = nZException.toString();
            System.out.println(string2);
            nZException.printStackTrace();
            return false;
        }
    }

    public boolean addCertRequest() {
        String string = "";
        try {
            if (!this.nzWalletObj.getPersonabyIndex(0).addCertRequest("CN=foo, C=US", 1024, "Random Seed")) {
                return false;
            }
            string = "file:/tmp/WALLETS/WALLET_1024CR";
            if (!this.nzWalletObj.getPersonabyIndex(0).exportCertReq(string)) {
                System.out.println("Unable to export Certrequest.");
            } else {
                String string2 = "Exported cert request to :" + string;
                System.out.println(string2);
            }
        }
        catch (NZException nZException) {
            return false;
        }
        return true;
    }

    public boolean installCertificate(String string, String string2, String string3) {
        try {
            String string4 = this.getB64CertFromFile(string, string2);
            NZPersona nZPersona = this.nzWalletObj.getPersonabyIndex(0);
            this.nzWalletObj.installB64Cert(nZPersona, string3, string4);
            return true;
        }
        catch (NZException nZException) {
            return false;
        }
    }

    public String getB64CertFromFile(String string, String string2) {
        try {
            File file = new File(string, string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return new String(byArray);
        }
        catch (Exception exception) {
            return "null";
        }
    }

    public void printTrustPointInfo() {
        Object object;
        Object object2;
        Object object3;
        int n = this.nzWalletObj.getPersonabyIndex(0).getUTPCount();
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        String string = "UTP Count: " + n;
        System.out.println(string);
        int n2 = 0;
        while (n2 < n) {
            object3 = this.nzWalletObj.getPersonabyIndex(0).getUTPCertificate(n2);
            System.out.println("===>");
            object2 = "Issuer Name:    " + ((NZCertificate)object3).getIssuerName();
            System.out.println((String)object2);
            object2 = "Version:        " + ((NZCertificate)object3).getVersion();
            System.out.println((String)object2);
            object2 = "Start Date:     " + ((NZCertificate)object3).getStartDate();
            System.out.println((String)object2);
            object2 = "Expiry Date:    " + ((NZCertificate)object3).getExpiryDate();
            System.out.println((String)object2);
            object2 = "Signature Algo: " + ((NZCertificate)object3).getSignatureAlgo();
            System.out.println((String)object2);
            object2 = "Serial Number:  " + ((NZCertificate)object3).getSerialNumber();
            System.out.println((String)object2);
            object2 = "MD5Digest:         " + ((NZCertificate)object3).getMD5Digest();
            System.out.println((String)object2);
            object2 = "SHA1Digest:         " + ((NZCertificate)object3).getSHA1Digest();
            System.out.println((String)object2);
            ++n2;
        }
        n = this.nzWalletObj.getPersonabyIndex(0).getPTPCount();
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        object3 = "PTP Count: " + n;
        System.out.println((String)object3);
        int n3 = 0;
        while (n3 < n) {
            object2 = this.nzWalletObj.getPersonabyIndex(0).getPTPCertificate(n3);
            System.out.println("===>");
            object = "Issuer Name:    " + ((NZCertificate)object2).getIssuerName();
            System.out.println((String)object);
            object = "Version:        " + ((NZCertificate)object2).getVersion();
            System.out.println((String)object);
            object = "Start Date:     " + ((NZCertificate)object2).getStartDate();
            System.out.println((String)object);
            object = "Expiry Date:    " + ((NZCertificate)object2).getExpiryDate();
            System.out.println((String)object);
            object = "Signature Algo: " + ((NZCertificate)object2).getSignatureAlgo();
            System.out.println((String)object);
            object = "Serial Number:  " + ((NZCertificate)object2).getSerialNumber();
            System.out.println((String)object);
            object = "MD5Digest:         " + ((NZCertificate)object2).getMD5Digest();
            System.out.println((String)object);
            object = "SHA1Digest:         " + ((NZCertificate)object2).getSHA1Digest();
            System.out.println((String)object);
            ++n3;
        }
        n = this.nzWalletObj.getPersonabyIndex(0).getETPCount();
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        object2 = "ETP Count: " + n;
        System.out.println((String)object2);
        int n4 = 0;
        while (n4 < n) {
            object = this.nzWalletObj.getPersonabyIndex(0).getETPCertificate(n4);
            System.out.println("===>");
            String string2 = "Issuer Name:    " + ((NZCertificate)object).getIssuerName();
            System.out.println(string2);
            string2 = "Version:        " + ((NZCertificate)object).getVersion();
            System.out.println(string2);
            string2 = "Start Date:     " + ((NZCertificate)object).getStartDate();
            System.out.println(string2);
            string2 = "Expiry Date:    " + ((NZCertificate)object).getExpiryDate();
            System.out.println(string2);
            string2 = "Signature Algo: " + ((NZCertificate)object).getSignatureAlgo();
            System.out.println(string2);
            string2 = "Serial Number:  " + ((NZCertificate)object).getSerialNumber();
            System.out.println(string2);
            string2 = "MD5Digest:         " + ((NZCertificate)object).getMD5Digest();
            System.out.println(string2);
            string2 = "SHA1Digest:         " + ((NZCertificate)object).getSHA1Digest();
            System.out.println(string2);
            ++n4;
        }
    }

    private void printCertificate(NZCertificate nZCertificate) {
        System.out.println("===>");
        String string = "Issuer Name:    " + nZCertificate.getIssuerName();
        System.out.println(string);
        string = "Version:        " + nZCertificate.getVersion();
        System.out.println(string);
        string = "Start Date:     " + nZCertificate.getStartDate();
        System.out.println(string);
        string = "Expiry Date:    " + nZCertificate.getExpiryDate();
        System.out.println(string);
        string = "Signature Algo: " + nZCertificate.getSignatureAlgo();
        System.out.println(string);
        string = "Serial Number:  " + nZCertificate.getSerialNumber();
        System.out.println(string);
        string = "MD5Digest:         " + nZCertificate.getMD5Digest();
        System.out.println(string);
        string = "SHA1Digest:         " + nZCertificate.getSHA1Digest();
        System.out.println(string);
    }

    private void printBanner() {
        System.out.println("");
        System.out.println("**********************************************************");
        System.out.println("*      Oracle Wallet Manager Command Line Version        *");
        System.out.println("*                   Release 2.0                          *");
        System.out.println("**********************************************************");
        System.out.println("");
    }

    public static void println(String string) {
        System.out.println(string);
    }
}

