/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ResourceBundle;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jsp.dbutil.CursorBean;
import oracle.jsp.event.JspScopeEvent;
import oracle.jsp.event.JspScopeListener;

public class ConnBean
implements JspScopeListener {
    protected Connection m_conn;
    private String m_user;
    private String m_password;
    private String m_url;
    private int m_scSize;
    private static int DEFAULT_PREFETCH_SIZE = 10;
    private static int DEFAULT_BATCH_SIZE = 1;
    private int m_preFetch = DEFAULT_PREFETCH_SIZE;
    private int m_batchSize = DEFAULT_BATCH_SIZE;
    private static final String MSG_FILE = "oracle.jsp.dbutil.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.LocalStrings");

    public ConnBean() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void setUser(String string) {
        this.m_user = string;
    }

    public synchronized String getUser() {
        return this.m_user;
    }

    public synchronized void setPassword(String string) {
        this.m_password = string;
    }

    public synchronized String getPassword() {
        return this.m_password;
    }

    public synchronized void setURL(String string) {
        this.m_url = string;
    }

    public synchronized String getURL() {
        return this.m_url;
    }

    public synchronized void connect() throws SQLException {
        if (this.m_conn != null) {
            return;
        }
        this.m_conn = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_fail"));
        }
        if (this.m_scSize > 0) {
            ((OracleConnection)this.m_conn).setStmtCacheSize(this.m_scSize);
        }
        if (this.m_preFetch != DEFAULT_PREFETCH_SIZE) {
            ((OracleConnection)this.m_conn).setDefaultRowPrefetch(this.m_preFetch);
        }
        if (this.m_batchSize != DEFAULT_BATCH_SIZE) {
            ((OracleConnection)this.m_conn).setDefaultExecuteBatch(this.m_batchSize);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.close();
            this.m_conn = null;
        }
    }

    public synchronized Connection getConnection() {
        return this.m_conn;
    }

    public synchronized CursorBean getCursorBean(int n, String string) throws SQLException {
        if (this.m_conn == null) {
            this.connect();
        }
        CursorBean cursorBean = new CursorBean();
        cursorBean.create(this, n, string);
        if (this.m_preFetch != DEFAULT_PREFETCH_SIZE) {
            cursorBean.setPreFetch(this.m_preFetch);
        }
        if (this.m_batchSize != DEFAULT_BATCH_SIZE && n != 0) {
            cursorBean.setExecuteBatch(this.m_batchSize);
        }
        return cursorBean;
    }

    public synchronized void setPreFetch(int n) {
        this.m_preFetch = n;
    }

    public synchronized int getPreFetch() {
        return this.m_preFetch;
    }

    public synchronized void setExecuteBatch(int n) {
        this.m_batchSize = n;
    }

    public synchronized int getExecuteBatch() {
        return this.m_batchSize;
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.m_scSize = n;
        if (this.m_conn != null) {
            ((OracleConnection)this.m_conn).setStmtCacheSize(this.m_scSize);
        }
    }

    public synchronized int getStmtCacheSize() {
        return this.m_scSize;
    }

    public void outOfScope(JspScopeEvent jspScopeEvent) {
        try {
            this.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

