/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.dbutil;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import oracle.jdbc.driver.OracleDriver;
import oracle.jsp.dbutil.BeanUtil;
import oracle.jsp.event.JspScopeEvent;
import oracle.jsp.event.JspScopeListener;

public class DBBean
implements JspScopeListener {
    private Connection m_conn;
    private String m_user;
    private String m_password;
    private String m_url;
    private static final String MSG_FILE = "oracle.jsp.dbutil.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.dbutil.LocalStrings");

    public DBBean() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void setUser(String string) {
        this.m_user = string;
    }

    public synchronized String getUser() {
        return this.m_user;
    }

    public synchronized void setPassword(String string) {
        this.m_password = string;
    }

    public synchronized String getPassword() {
        return this.m_password;
    }

    public synchronized void setURL(String string) {
        this.m_url = string;
    }

    public synchronized String getURL() {
        return this.m_url;
    }

    public synchronized void connect() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = DriverManager.getConnection(this.m_url, this.m_user, this.m_password);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.close();
            this.m_conn = null;
        }
    }

    public String getResultAsXMLString(String string) throws SQLException {
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_null"));
        }
        Statement statement = this.m_conn.createStatement();
        if (statement == null) {
            throw new SQLException(msgs.getString("cursor_null"));
        }
        ResultSet resultSet = statement.executeQuery(string);
        String string2 = BeanUtil.translateToXML(this.m_conn, string, resultSet);
        resultSet.close();
        statement.close();
        return string2;
    }

    public String getResultAsHTMLTable(String string) throws SQLException {
        if (this.m_conn == null) {
            throw new SQLException(msgs.getString("conn_null"));
        }
        Statement statement = this.m_conn.createStatement();
        if (statement == null) {
            throw new SQLException(msgs.getString("cursor_null"));
        }
        ResultSet resultSet = statement.executeQuery(string);
        String string2 = BeanUtil.translateToHTMLTable(resultSet);
        resultSet.close();
        statement.close();
        return string2;
    }

    public void outOfScope(JspScopeEvent jspScopeEvent) {
        try {
            this.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

