/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import java.util.Enumeration;
import java.util.Vector;
import oracle.net.util.QueueNode;
import oracle.net.util.QueueableCommand;

public class CommandPriorityQueue {
    private QueueNode root = null;

    public QueueableCommand removeHighestPriorityCommand() {
        QueueableCommand command = null;
        command = this.deleteMin();
        return command;
    }

    public QueueableCommand findMin() {
        return this.root == null ? null : this.root.item;
    }

    public synchronized void insert(QueueableCommand item) {
        QueueNode n = new QueueNode(null, null, item);
        this.root = this.imeld(n, this.root);
    }

    public synchronized QueueableCommand deleteMin() {
        QueueNode n = null;
        if (this.root == null) {
            return null;
        }
        n = this.root;
        this.root = this.imeld(this.root.left, this.root.right);
        return n.item;
    }

    public QueueNode imeld(QueueNode h1, QueueNode h2) {
        QueueNode temp;
        if (h1 == null) {
            return h2;
        }
        if (h2 == null) {
            return h1;
        }
        if (h1.item.lowerPriorityThan(h2.item)) {
            temp = h1;
            h1 = h2;
            h2 = temp;
        }
        QueueNode x = h1;
        QueueNode y = h1;
        h1 = h1.right;
        y.right = y.left;
        while (h1 != null) {
            if (h1.item.lowerPriorityThan(h2.item)) {
                temp = h1;
                h1 = h2;
                h2 = temp;
            }
            y.left = h1;
            y = h1;
            h1 = y.right;
            y.right = y.left;
        }
        y.left = h2;
        return x;
    }

    public String toString() {
        String retString = "";
        retString = this.root != null ? this.root.toString() : "<empty>";
        return retString;
    }

    public synchronized Enumeration elements() {
        Vector<QueueableCommand> heapItems = new Vector<QueueableCommand>();
        QueueNode node = this.root;
        if (node != null) {
            CommandPriorityQueue.addChildrenItems(node, heapItems);
            heapItems.addElement(node.item);
        }
        return heapItems.elements();
    }

    protected static void addChildrenItems(QueueNode node, Vector vector) {
        if (node.right != null) {
            CommandPriorityQueue.addChildrenItems(node.right, vector);
            vector.addElement(node.right.item);
        }
        if (node.left != null) {
            CommandPriorityQueue.addChildrenItems(node.left, vector);
            vector.addElement(node.left.item);
        }
    }

    public boolean isEmpty() {
        return this.root == null;
    }
}

