/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import java.util.Enumeration;
import oracle.net.util.ICommand;
import oracle.net.util.ListenerManager;
import oracle.net.util.SchedulerEvent;
import oracle.net.util.SchedulerListener;
import oracle.net.util.Timer;

public class CommandScheduler {
    private static CommandScheduler s_defaultScheduler = null;
    private CommandQueue _queue = new CommandQueue();
    Timer _timer = new Timer(this._queue);
    private ListenerManager _listeners;
    private static CommandScheduler _sCommandScheduler;

    public static CommandScheduler getDefaultCommandScheduler() {
        if (s_defaultScheduler == null) {
            s_defaultScheduler = new CommandScheduler();
        }
        return s_defaultScheduler;
    }

    public CommandScheduler() {
        this._timer.setName("CommandScheduler timer");
    }

    public void schedule(ICommand command, int delay) {
        CommandQueue queue;
        if (delay < 0) {
            throw new IllegalArgumentException();
        }
        long time = System.currentTimeMillis() + (long)delay;
        SchedulerEvent event = new SchedulerEvent(this, 1, command, time);
        this.processSchedulerEvent(event);
        if (event.isCommandRejected()) {
            return;
        }
        CommandQueue commandQueue = queue = this._queue;
        synchronized (commandQueue) {
            try {
                boolean reschedule = queue.remove(command);
                boolean bl = reschedule = queue.add(command, time) || reschedule;
                if (reschedule) {
                    this._timer.schedule(queue.getNextDelay());
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                throw throwable;
            }
        }
    }

    protected void processSchedulerEvent(SchedulerEvent event) {
        Enumeration enumeration;
        int id = event.getID();
        ListenerManager listeners = this._listeners;
        if (listeners != null && (enumeration = listeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                SchedulerListener listener = (SchedulerListener)enumeration.nextElement();
                switch (id) {
                    case 1: {
                        listener.taskScheduled(event);
                        break;
                    }
                    case 2: {
                        listener.taskRunning(event);
                        break;
                    }
                }
            }
        }
    }

    protected void processCommand(ICommand command, long time) {
        try {
            SchedulerEvent event = new SchedulerEvent(this, 2, command, time);
            this.processSchedulerEvent(event);
            if (!event.isCommandRejected()) {
                this.runCommand(command);
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    protected void runCommand(ICommand command) {
        command.execute();
    }

    private class Element {
        public final ICommand command;
        public final long time;
        public Element next;

        public Element(ICommand command, long time, Element next) {
            this.command = command;
            this.time = time;
            this.next = next;
        }
    }

    private class CommandQueue
    implements Runnable {
        private Element _head;

        CommandQueue() {
        }

        public void run() {
            Element command = null;
            CommandQueue commandQueue = this;
            synchronized (commandQueue) {
                block9: {
                    try {
                        if (this.isEmpty()) {
                            Object var6_3 = null;
                            return;
                        }
                        long delay = this.getNextDelay();
                        if (delay > (long)0) break block9;
                        command = this.popFirstCommand();
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        throw throwable;
                    }
                }
                Object var6_4 = null;
                {
                }
            }
            if (command != null) {
                CommandScheduler.this.processCommand(command.command, command.time);
            }
            CommandQueue commandQueue2 = this;
            synchronized (commandQueue2) {
                try {
                    if (!this.isEmpty()) {
                        CommandScheduler.this._timer.schedule(this.getNextDelay());
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    throw throwable;
                }
            }
        }

        public boolean add(ICommand command, long time) {
            Element previous = null;
            Element current = this._head;
            while (current != null && current.time <= time) {
                previous = current;
                current = current.next;
            }
            Element adding = new Element(command, time, current);
            if (previous == null) {
                this._head = adding;
                return true;
            }
            previous.next = adding;
            return false;
        }

        public boolean remove(ICommand command) {
            Element previous = null;
            Element current = this._head;
            while (current != null) {
                if (current.command == command) {
                    if (previous == null) {
                        this._head = current.next;
                        return true;
                    }
                    previous.next = current.next;
                    break;
                }
                previous = current;
                current = current.next;
            }
            return false;
        }

        public Element popFirstCommand() {
            Element head = this._head;
            this._head = head.next;
            return head;
        }

        public long getNextDelay() {
            long millis = this._head.time - System.currentTimeMillis();
            if (millis < (long)0) {
                millis = 0L;
            }
            return millis;
        }

        public boolean isEmpty() {
            return this._head == null;
        }
    }
}

