/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class NetException
extends Exception {
    public static final int UNDEFINED = 0;
    protected static final int FIRSTERRORCODE = 1;
    protected static final int LASTERRORCODE = 1;
    private ResourceBundle m_resBun = ResourceBundle.getBundle("oracle.net.util.UtilResBun");
    protected int m_errorCode = 0;
    protected String m_errorString = null;
    protected Exception m_errorException = null;

    public NetException(String errorString) {
        super(errorString);
        this.m_errorString = errorString;
    }

    public NetException(int errorCode) {
        this.m_errorCode = errorCode;
    }

    public NetException(Exception errorException) {
        super(errorException.toString());
        this.m_errorException = errorException;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public String getErrorString() {
        String errorString = null;
        errorString = this.m_errorString != null ? this.m_errorString : (this.m_errorException != null ? this.m_errorException.toString() : this.getErrorString(this.m_errorCode));
        return errorString;
    }

    public String toString() {
        return this.getErrorString();
    }

    protected String getErrorString(int errorCode) {
        if (errorCode >= 1 && errorCode <= 1) {
            return this.m_resBun.getString(String.valueOf("UtilErr").concat(String.valueOf(errorCode)));
        }
        String fmt = this.m_resBun.getString("UtilErrGenFmt");
        Object[] args = new Object[]{String.valueOf(errorCode)};
        return MessageFormat.format(fmt, args);
    }
}

