/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import oracle.net.util.IProgress;

public class ProgressMultiplexor
implements IProgress {
    private IProgress[] m_progressInterfaces = new IProgress[2];
    private boolean m_limitsKnown = false;
    private int m_max = -1;
    private int m_min = -1;
    private int m_current = -1;
    private int m_type = 1;
    private int m_mode = 1;

    public ProgressMultiplexor() {
    }

    public ProgressMultiplexor(IProgress multiplexee1, IProgress multiplexee2) {
        this.m_progressInterfaces[0] = multiplexee1;
        this.m_progressInterfaces[1] = multiplexee2;
    }

    public synchronized void addProgressInterface(IProgress progressInterface) {
        int emptyIndex = -1;
        for (int i = 0; i < this.m_progressInterfaces.length; ++i) {
            if (this.m_progressInterfaces[i] != null) continue;
            emptyIndex = i;
            break;
        }
        if (emptyIndex == -1) {
            IProgress[] newProgressInterfaces = new IProgress[this.m_progressInterfaces.length * 2];
            System.arraycopy(this.m_progressInterfaces, 0, newProgressInterfaces, 0, this.m_progressInterfaces.length);
            System.arraycopy(newProgressInterfaces, this.m_progressInterfaces.length, this.m_progressInterfaces, 0, this.m_progressInterfaces.length);
            emptyIndex = this.m_progressInterfaces.length;
            this.m_progressInterfaces = newProgressInterfaces;
        }
        this.m_progressInterfaces[emptyIndex] = progressInterface;
    }

    public synchronized void removeProgressInterface(IProgress progressInterface) {
        for (int i = 0; i < this.m_progressInterfaces.length; ++i) {
            if (this.m_progressInterfaces[i] != progressInterface) continue;
            this.m_progressInterfaces[i] = null;
            break;
        }
    }

    public synchronized void begin(Object callingObject) {
        for (int i = 0; i < this.m_progressInterfaces.length; ++i) {
            if (this.m_progressInterfaces[i] == null) continue;
            this.m_progressInterfaces[i].begin(callingObject);
        }
        this.m_limitsKnown = false;
        this.m_max = -1;
        this.m_min = -1;
        this.m_current = -1;
        this.m_type = 1;
        this.m_mode = 1;
    }

    public synchronized void begin(Object callingObject, int min, int max, int type, int mode) {
        for (int i = 0; i < this.m_progressInterfaces.length; ++i) {
            if (this.m_progressInterfaces[i] == null) continue;
            this.m_progressInterfaces[i].begin(callingObject, min, max, type, mode);
        }
        this.m_limitsKnown = false;
        this.m_max = max;
        this.m_min = min;
        this.m_current = min;
        this.m_type = type;
        this.m_mode = mode;
    }

    public synchronized void incrementProgress(Object callingObject, int increment, String progressMsg) {
        for (int i = 0; i < this.m_progressInterfaces.length; ++i) {
            if (this.m_progressInterfaces[i] == null) continue;
            this.m_progressInterfaces[i].incrementProgress(callingObject, increment, progressMsg);
        }
        this.m_current += increment;
    }

    public synchronized void progress(Object callingObject, int current, String progressMsg) {
        for (int i = 0; i < this.m_progressInterfaces.length; ++i) {
            if (this.m_progressInterfaces[i] == null) continue;
            this.m_progressInterfaces[i].progress(callingObject, current, progressMsg);
        }
        this.m_current = current;
    }

    public synchronized void done(Object callingObject, String progressMsg) {
        for (int i = 0; i < this.m_progressInterfaces.length; ++i) {
            if (this.m_progressInterfaces[i] == null) continue;
            this.m_progressInterfaces[i].done(callingObject, progressMsg);
        }
        this.m_limitsKnown = false;
        this.m_max = -1;
        this.m_min = -1;
        this.m_current = -1;
        this.m_type = 1;
        this.m_mode = 1;
    }

    public synchronized void setStatusMsg(Object callingObject, String statusMsg) {
        for (int i = 0; i < this.m_progressInterfaces.length; ++i) {
            if (this.m_progressInterfaces[i] == null) continue;
            this.m_progressInterfaces[i].setStatusMsg(callingObject, statusMsg);
        }
    }

    public int getMin(Object callingObject) {
        return this.m_min;
    }

    public int getMax(Object callingObject) {
        return this.m_max;
    }

    public int getType(Object callingObject) {
        return this.m_type;
    }

    public int getMode(Object callingObject) {
        return this.m_mode;
    }

    public boolean areLimitsKnown(Object callingObject) {
        return this.m_limitsKnown;
    }

    public int getCurrent(Object callingObject) {
        return this.m_current;
    }
}

