/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.util.IProgress;

public class ProgressedOutputStream
extends OutputStream {
    private OutputStream m_outStream = null;
    private IProgress m_progressInterface = null;
    private int m_bytesWritten = 0;
    private int m_lastYieldAt = 0;
    private int m_type;

    public ProgressedOutputStream(OutputStream outStream, IProgress progressInterface) {
        this.m_outStream = outStream;
        this.m_progressInterface = progressInterface;
        if (this.m_progressInterface != null) {
            this.m_type = this.m_progressInterface.getType(this);
        }
    }

    public void close() throws IOException {
        this.m_outStream.close();
    }

    public void flush() throws IOException {
        this.m_outStream.flush();
    }

    private void doProgress(int count) {
        if (this.m_progressInterface != null) {
            if (this.m_type == 1) {
                this.m_progressInterface.progress(this, this.m_bytesWritten, null);
            } else {
                this.m_progressInterface.incrementProgress(this, count, null);
            }
        }
        if (this.m_bytesWritten - this.m_lastYieldAt >= 128) {
            this.m_lastYieldAt = this.m_bytesWritten;
            Thread.yield();
        }
    }

    public void write(int b) throws IOException {
        this.m_outStream.write(b);
        ++this.m_bytesWritten;
        this.doProgress(1);
    }

    public void write(byte[] b) throws IOException {
        this.m_outStream.write(b);
        this.m_bytesWritten += b.length;
        this.doProgress(b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.m_outStream.write(b, off, len);
        this.m_bytesWritten += len;
        this.doProgress(len);
    }
}

