/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import java.util.Vector;

public class RFC822Address {
    private static final int BEGIN = 1;
    private static final int FORM2ORFORM3 = 2;
    private static final int UNKNOWN = 3;
    private static final int FORM4 = 4;
    private static final int FORM3ORFORM4 = 5;
    private static final int PARSINGADDRESSINBRACKETS = 6;
    private static final int FOUNDCLOSINGPAREN = 7;
    private static final int NORMAL = 1;
    private static final int INSIDEQUOTE = 2;
    private static final int INSIDECOMMENT = 3;
    private String m_address;

    public RFC822Address() {
        this.m_address = "";
    }

    public RFC822Address(String address) {
        this.m_address = address;
        if (address == null) {
            this.m_address = "";
        }
    }

    public static RFC822Address[] extractFullAddresses(String addresses, String delimiters) {
        Vector addressList = RFC822Address.extractVectorOfFullAddressStrings(addresses, delimiters);
        RFC822Address[] addressArray = new RFC822Address[addressList.size()];
        for (int i = 0; i < addressList.size(); ++i) {
            addressArray[i] = new RFC822Address((String)addressList.elementAt(i));
        }
        return addressArray;
    }

    public static String[] extractStringArrayOfFullAddresses(String addresses, String delimiters) {
        Vector addressList = RFC822Address.extractVectorOfFullAddressStrings(addresses, delimiters);
        Object[] addressArray = new String[addressList.size()];
        addressList.copyInto(addressArray);
        return addressArray;
    }

    public static Vector extractVectorOfFullAddressStrings(String addresses, String delimiters) {
        Vector<String> addressList = new Vector<String>();
        if (addresses == null) {
            return addressList;
        }
        StringBuffer address = new StringBuffer();
        int state = 1;
        block5: for (int i = 0; i < addresses.length(); ++i) {
            char input = addresses.charAt(i);
            switch (state) {
                case 1: {
                    if (input == '\"') {
                        state = 2;
                        address.append(input);
                        continue block5;
                    }
                    if (input == '(') {
                        state = 3;
                        address.append(input);
                        continue block5;
                    }
                    if (delimiters.indexOf(input) != -1) {
                        addressList.addElement(address.toString().trim());
                        address = new StringBuffer();
                        continue block5;
                    }
                    address.append(input);
                    continue block5;
                }
                case 2: {
                    address.append(input);
                    if (input != '\"') continue block5;
                    state = 1;
                    continue block5;
                }
                case 3: {
                    address.append(input);
                    if (input != ')') continue block5;
                    state = 1;
                }
            }
        }
        if (address.length() > 0) {
            addressList.addElement(address.toString().trim());
        }
        return addressList;
    }

    public String extractFamiliarName() {
        return RFC822Address.extractFamiliarName(this.m_address);
    }

    public static String extractFamiliarName(String address) {
        if (address == null) {
            return "";
        }
        StringBuffer familiarName = new StringBuffer();
        StringBuffer token = new StringBuffer();
        int state = 1;
        boolean foundFamiliarName = false;
        block7: for (int i = 0; i < address.length() && !foundFamiliarName; ++i) {
            char input = address.charAt(i);
            switch (state) {
                case 1: {
                    if (input == '\"') {
                        state = 2;
                        continue block7;
                    }
                    if (input == ' ') continue block7;
                    state = 3;
                    token.append(input);
                    continue block7;
                }
                case 2: {
                    if (input == '<') {
                        foundFamiliarName = true;
                        continue block7;
                    }
                    if (input == '\"') {
                        foundFamiliarName = true;
                        continue block7;
                    }
                    familiarName.append(input);
                    continue block7;
                }
                case 3: {
                    if (input == '<') {
                        familiarName = token;
                        foundFamiliarName = true;
                        continue block7;
                    }
                    if (input == '(') {
                        state = 5;
                        continue block7;
                    }
                    token.append(input);
                    continue block7;
                }
                case 5: {
                    if (input == ')') {
                        state = 7;
                        foundFamiliarName = true;
                        continue block7;
                    }
                    familiarName.append(input);
                    continue block7;
                }
                case 7: {
                    if (input != '<') continue block7;
                    familiarName = new StringBuffer(String.valueOf(String.valueOf(String.valueOf(token).concat(String.valueOf("("))).concat(String.valueOf(familiarName.toString()))).concat(String.valueOf(")")));
                    foundFamiliarName = true;
                    continue block7;
                }
            }
        }
        return familiarName.toString().trim();
    }

    public String extractBasicAddress() {
        return RFC822Address.extractBasicAddress(this.m_address);
    }

    public static String extractBasicAddress(String fullAddress) {
        StringBuffer basicAddress = new StringBuffer();
        StringBuffer token = new StringBuffer();
        if (fullAddress == null) {
            return null;
        }
        int state = 1;
        boolean foundBasicAddress = false;
        block8: for (int i = 0; i < fullAddress.length() && !foundBasicAddress; ++i) {
            char input = fullAddress.charAt(i);
            switch (state) {
                case 1: {
                    if (input == '\"') {
                        state = 2;
                        continue block8;
                    }
                    if (input == ' ') continue block8;
                    state = 3;
                    token.append(input);
                    continue block8;
                }
                case 2: {
                    if (input != '<') continue block8;
                    state = 6;
                    continue block8;
                }
                case 3: {
                    if (input == '<') {
                        state = 6;
                        continue block8;
                    }
                    if (input == '(') {
                        state = 5;
                        continue block8;
                    }
                    token.append(input);
                    continue block8;
                }
                case 5: {
                    if (input != ')') continue block8;
                    state = 7;
                    continue block8;
                }
                case 6: {
                    if (input == '>') {
                        foundBasicAddress = true;
                        continue block8;
                    }
                    basicAddress.append(input);
                    continue block8;
                }
                case 7: {
                    if (input != '<') continue block8;
                    state = 6;
                }
            }
        }
        if (state == 7 || state == 3) {
            basicAddress = token;
        }
        return basicAddress.toString().trim();
    }

    public boolean equals(Object anObject) {
        boolean rc = false;
        if (anObject != null && anObject instanceof RFC822Address) {
            rc = RFC822Address.areEqual(this, (RFC822Address)anObject);
        }
        return rc;
    }

    public static boolean areEqual(RFC822Address address1, RFC822Address address2) {
        return address1.extractBasicAddress().equalsIgnoreCase(address2.extractBasicAddress());
    }

    public static boolean areEqual(String address1, String address2) {
        return RFC822Address.extractBasicAddress(address1).equalsIgnoreCase(RFC822Address.extractBasicAddress(address2));
    }

    public String toString() {
        return this.m_address;
    }
}

