/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class RFC822Date
extends Date {
    static final int s_millisPerMinute = 60000;
    static final int s_millisPerHour = 3600000;
    private static final String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final int[] ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};

    public RFC822Date(String rfc822Date) throws IllegalArgumentException {
        super(RFC822Date.parse(rfc822Date));
    }

    public RFC822Date() {
    }

    public String toString() {
        String s = RFC822Date.toLocalTZRFC822DateString(this);
        return s;
    }

    public static String toLocalTZRFC822DateString(Date d) {
        String sRet = null;
        String sFormat = "E, dd MMM yyyy HH:mm:ss ";
        DateFormatSymbols dfd = new DateFormatSymbols(Locale.US);
        SimpleDateFormat formatter = new SimpleDateFormat(sFormat, dfd);
        formatter.setTimeZone(TimeZone.getDefault());
        sRet = formatter.format(d);
        sRet = String.valueOf(sRet).concat(String.valueOf(RFC822Date.getGMTOffsetString(d)));
        return sRet;
    }

    public static String getGMTOffsetString(Date d) {
        StringBuffer gmtOffset = new StringBuffer(5);
        TimeZone tz = TimeZone.getDefault();
        int zoneOffset = tz.getRawOffset();
        if (tz.inDaylightTime(d)) {
            zoneOffset += 3600000;
        }
        if (zoneOffset < 0) {
            gmtOffset.append('-');
            zoneOffset *= -1;
        } else {
            gmtOffset.append('+');
        }
        int hours = zoneOffset / 3600000;
        int minutes = (zoneOffset - hours * 3600000) / 60000;
        if (hours < 10) {
            gmtOffset.append('0');
        }
        gmtOffset.append(hours);
        if (minutes < 10) {
            gmtOffset.append('0');
        }
        gmtOffset.append(minutes);
        return gmtOffset.toString();
    }

    public static RFC822Date valueOf(String rfc822Date) throws IllegalArgumentException {
        return new RFC822Date(rfc822Date);
    }

    public static long parse(String s) {
        block42: {
            int year = -1;
            int mon = -1;
            int mday = -1;
            int hour = -1;
            int min = -1;
            int sec = -1;
            int millis = -1;
            int c = -1;
            int i = 0;
            int n = -1;
            int wst = -1;
            int tzoffset = -1;
            int prevc = 0;
            if (s != null) {
                int limit = s.length();
                block0: while (i < limit) {
                    c = s.charAt(i);
                    ++i;
                    if (c <= 32 || c == 44) continue;
                    if (c == 40) {
                        int depth = 1;
                        while (i < limit) {
                            c = s.charAt(i);
                            ++i;
                            if (c == 40) {
                                ++depth;
                                continue;
                            }
                            if (c != 41 || --depth > 0) continue;
                            continue block0;
                        }
                        continue;
                    }
                    if (48 <= c && c <= 57) {
                        n = c - 48;
                        while (i < limit) {
                            char c2 = s.charAt(i);
                            c = c2;
                            if ('0' > c2 || c > 57) break;
                            n = n * 10 + c - 48;
                            ++i;
                        }
                        if (prevc == 43 || prevc == 45 && year >= 0) {
                            n = n < 24 ? (n *= 60) : n % 100 + n / 100 * 60;
                            if (prevc == 43) {
                                n = -n;
                            }
                            if (tzoffset != 0 && tzoffset != -1) break block42;
                            tzoffset = n;
                        } else if (n >= 70) {
                            if (year >= 0 || c > 32 && c != 44 && c != 47 && i < limit) break block42;
                            year = n < 1900 ? n + 1900 : n;
                        } else if (c == 58) {
                            if (hour < 0) {
                                hour = (byte)n;
                            } else {
                                if (min >= 0) break block42;
                                min = (byte)n;
                            }
                        } else if (c == 47) {
                            if (mon < 0) {
                                mon = (byte)(n - 1);
                            } else {
                                if (mday >= 0) break block42;
                                mday = (byte)n;
                            }
                        } else {
                            if (i < limit && c != 44 && c > 32 && c != 45) break block42;
                            if (hour >= 0 && min < 0) {
                                min = (byte)n;
                            } else if (min >= 0 && sec < 0) {
                                sec = (byte)n;
                            } else {
                                if (mday >= 0) break block42;
                                mday = (byte)n;
                            }
                        }
                        prevc = 0;
                        continue;
                    }
                    if (c == 47 || c == 58 || c == 43 || c == 45) {
                        prevc = c;
                        continue;
                    }
                    int st = i - 1;
                    while (i < limit && (65 <= (c = (int)s.charAt(i)) && c <= 90 || 97 <= c && c <= 122)) {
                        ++i;
                    }
                    if (i <= st + 1) break block42;
                    int k = wtb.length;
                    while (--k >= 0) {
                        if (!wtb[k].regionMatches(true, 0, s, st, i - st)) continue;
                        int action = ttb[k];
                        if (action == 0) break;
                        if (action == 1) {
                            if (hour <= 12 && hour >= 1) {
                                if (hour >= 12) break;
                                hour += 12;
                                break;
                            }
                            break block42;
                        }
                        if (action == 14) {
                            if (hour <= 12 && hour >= 1) {
                                if (hour != 12) break;
                                hour = 0;
                                break;
                            }
                            break block42;
                        }
                        if (action <= 13) {
                            if (mon < 0) {
                                mon = (byte)(action - 2);
                                break;
                            }
                            break block42;
                        }
                        tzoffset = action - 10000;
                        break;
                    }
                    if (k >= 0) {
                        prevc = 0;
                        continue;
                    }
                    break block42;
                }
                if (year >= 0 && mon >= 0 && mday >= 0) {
                    if (sec < 0) {
                        sec = 0;
                    }
                    if (min < 0) {
                        min = 0;
                    }
                    if (hour < 0) {
                        hour = 0;
                    }
                    if (tzoffset == -1) {
                        return new Date(year, mon, mday, hour, min, sec).getTime();
                    }
                    TimeZone tz = TimeZone.getDefault();
                    Calendar cal = Calendar.getInstance();
                    cal.set(year, mon, mday, hour, min, sec);
                    long l = cal.getTime().getTime();
                    l += (long)(tzoffset * 60000);
                    l += (long)tz.getRawOffset();
                    if (tz.inDaylightTime(cal.getTime())) {
                        l += (long)3600000;
                    }
                    return l;
                }
            }
        }
        throw new IllegalArgumentException();
    }
}

