/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

import java.util.Enumeration;
import java.util.Vector;
import oracle.net.util.CommandScheduler;
import oracle.net.util.CommandThread;
import oracle.net.util.CommandThreadAdvise;
import oracle.net.util.ICommand;

public class ThreadedCommandPool
implements CommandThreadAdvise,
ICommand {
    private static final int s_coalesceInterval = 120000;
    private static ThreadedCommandPool s_default = null;
    private static CommandScheduler s_scheduler = null;
    private int m_peakBusyThreads = 0;
    private Vector m_availableThreads = new Vector();
    private Vector m_busyThreads = new Vector();

    public static synchronized ThreadedCommandPool getDefaultThreadedCommandPool() {
        if (s_default == null) {
            s_default = new ThreadedCommandPool();
        }
        if (s_scheduler == null) {
            s_scheduler = CommandScheduler.getDefaultCommandScheduler();
            s_scheduler.schedule(s_default, 120000);
        }
        return s_default;
    }

    public boolean isAlive(ICommand command) {
        boolean isAlive = false;
        CommandThread commandThread = this.getBusyCommandThreadForCommand(command);
        if (commandThread != null) {
            isAlive = true;
        }
        return isAlive;
    }

    public void stop(ICommand command) {
        CommandThread commandThread = this.getBusyCommandThreadForCommand(command);
        if (commandThread != null && commandThread.isAlive()) {
            commandThread.done();
            commandThread.stop();
            this.m_busyThreads.removeElement(commandThread);
        }
    }

    public void submit(ICommand command) {
        this.submit(command, String.valueOf("CommandThread ").concat(String.valueOf(command)), 5);
    }

    public void submit(ICommand command, int priority) {
        this.submit(command, String.valueOf("CommandThread ").concat(String.valueOf(command)), priority);
    }

    public void submit(ICommand command, String threadName) {
        this.submit(command, threadName, 5);
    }

    public void submit(ICommand command, String threadName, int priority) {
        CommandThread thread = null;
        Vector vector = this.m_availableThreads;
        synchronized (vector) {
            try {
                if (this.m_availableThreads.isEmpty()) {
                    thread = new CommandThread(this);
                } else {
                    thread = (CommandThread)this.m_availableThreads.lastElement();
                    this.m_availableThreads.removeElementAt(this.m_availableThreads.size() - 1);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
        this.m_busyThreads.addElement(thread);
        this.m_peakBusyThreads = Math.max(this.m_peakBusyThreads, this.m_busyThreads.size());
        thread.setPriority(priority);
        thread.execute(command, threadName);
    }

    public void execute() {
        Vector vector = this.m_availableThreads;
        synchronized (vector) {
            try {
                int idleThreads = this.m_availableThreads.size();
                int busyThreads = this.m_busyThreads.size();
                int totalThreads = idleThreads + busyThreads;
                if (idleThreads > 0 && totalThreads > this.m_peakBusyThreads) {
                    CommandThread thread = (CommandThread)this.m_availableThreads.lastElement();
                    this.m_availableThreads.removeElementAt(idleThreads - 1);
                    thread.done();
                }
                this.m_peakBusyThreads = busyThreads;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
        s_scheduler.schedule(this, 120000);
    }

    public void commandExecuted(CommandThread commandThread, ICommand command) {
        Vector vector = this.m_availableThreads;
        synchronized (vector) {
            try {
                this.m_availableThreads.addElement(commandThread);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        this.m_busyThreads.removeElement(commandThread);
    }

    protected CommandThread getBusyCommandThreadForCommand(ICommand command) {
        CommandThread commandThread = null;
        Enumeration iterator = this.m_busyThreads.elements();
        while (iterator.hasMoreElements()) {
            CommandThread testCommandThread = (CommandThread)iterator.nextElement();
            if (!command.equals(testCommandThread.m_command)) continue;
            commandThread = testCommandThread;
            break;
        }
        return commandThread;
    }
}

