/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util;

public class Timer
implements Runnable {
    private Thread _thread;
    private long _delay;
    private long _expirationTime;
    private Runnable _target;
    private boolean _killed;
    private boolean _scheduled;
    private boolean _cancelled;
    private boolean _sleeping;
    private boolean _firing;
    private boolean _daemon;
    private String _name;
    private static int _sInstanceCounter;
    private static final long THREAD_FUDGE_FACTOR = 10L;

    public Timer(Runnable target) {
        this._init(target, this.getDefaultName());
    }

    public Timer(Runnable target, String name) {
        this._init(target, name);
    }

    public Timer(Runnable target, long delay) {
        this(target);
        this.schedule(delay);
    }

    public synchronized void schedule(long delay) {
        long oldExpire = this._expirationTime;
        this.setDelay(delay);
        this._expirationTime = System.currentTimeMillis() + delay;
        if (!this._isSleeping() || oldExpire > this._expirationTime) {
            if (!this._thread.isAlive()) {
                this._thread.start();
            } else if (this.isScheduled() && this._thread != Thread.currentThread()) {
                this.cancel();
            }
        }
        this._setScheduled(true);
        this.notify();
    }

    public boolean isScheduled() {
        return this._scheduled;
    }

    public synchronized long getDelay() {
        return this._delay;
    }

    public synchronized void setDelay(long delay) {
        this._delay = delay;
    }

    public synchronized long getMillisSinceExpired() {
        return System.currentTimeMillis() - this._expirationTime;
    }

    public synchronized void cancel() {
        boolean wasScheduled = this.isScheduled();
        this._setScheduled(false);
        if (this._firing) {
            this._cancelled = true;
            return;
        }
        this._setSleeping(false);
        if (this._thread.isAlive() && wasScheduled) {
            this._thread.interrupt();
        }
    }

    public synchronized void kill() {
        this._killed = true;
        this._cancelled = true;
        this.notifyAll();
        this._thread = null;
    }

    public void setName(String name) {
        this._name = name;
        this._thread.setName(name);
    }

    public String getName() {
        return this._name;
    }

    public void setDaemon(boolean on) {
        this._thread.setDaemon(on);
        this._daemon = on;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public void setPriority(int newPriority) {
        this._thread.setPriority(newPriority);
    }

    public int getPriority() {
        return this._thread.getPriority();
    }

    public void run() {
        while (!this._killed) {
            try {
                long tilExpired;
                this._waitTilScheduled();
                if (this._killed) continue;
                while ((tilExpired = -this.getMillisSinceExpired()) > (long)0) {
                    this._setSleeping(true);
                    this.accurateSleep(tilExpired);
                    this._setSleeping(false);
                }
                this.doRun();
                this._cancelled = false;
            }
            catch (InterruptedException e) {}
        }
    }

    protected void accurateSleep(long millis) throws InterruptedException {
        if (millis > 10L) {
            Thread.sleep(millis - 10L);
        } else {
            while (this.getMillisSinceExpired() < (long)0) {
                Thread.yield();
            }
        }
    }

    protected void doRun() {
        boolean killed;
        Timer timer = this;
        synchronized (timer) {
            try {
                this._setScheduled(false);
                this._firing = true;
                killed = this._killed;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        if (!killed) {
            try {
                this._target.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._firing = false;
    }

    protected synchronized boolean wasCancelledDuringRun() {
        return this._cancelled || this._thread == null;
    }

    protected String getDefaultName() {
        return String.valueOf("EWT-Timer").concat(String.valueOf(_sInstanceCounter++));
    }

    protected void finalize() throws Throwable {
        this.kill();
        super.finalize();
    }

    private synchronized void _waitTilScheduled() throws InterruptedException {
        while (!this.isScheduled() && !this._killed) {
            this.wait();
        }
    }

    private void _setScheduled(boolean scheduled) {
        this._scheduled = scheduled;
    }

    private boolean _isSleeping() {
        return this._sleeping;
    }

    private synchronized void _setSleeping(boolean sleeping) {
        this._sleeping = sleeping;
    }

    private void _init(Runnable target, String name) {
        this._name = name;
        this._thread = new Thread((Runnable)this, name);
        this._target = target;
    }
}

