/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.util.encoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.util.encoders.CharacterEncoder;

public class QuotedPrintableEncoder
extends CharacterEncoder {
    private static final byte[] decimalToHex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int BUFFSIZE = 256;
    private boolean m_foundCR;
    private byte[] m_lineBuff = new byte[80];
    private int m_charsInBuff;

    int bytesPerAtom() {
        return 0;
    }

    int bytesPerLine() {
        return 38;
    }

    void encodeAtom(OutputStream outStream, byte[] data, int offset, int len) throws IOException {
        throw new IOException("QuotedPrintableEncoder: No such thing as atom");
    }

    public void encodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
        int i;
        byte[] inbuff = new byte[256];
        this.m_foundCR = false;
        this.m_charsInBuff = 0;
        while (-1 != (i = inStream.read(inbuff, 0, 256))) {
            this.encodeByteArray(outStream, inbuff, i);
        }
        if (this.m_charsInBuff > 0) {
            outStream.write(this.m_lineBuff, 0, this.m_charsInBuff);
        }
    }

    void encodeByteArray(OutputStream oStream, byte[] inbuff, int buffLength) throws IOException {
        for (int i = 0; i < buffLength; ++i) {
            int charsToOutput;
            if (!(inbuff[i] != 61 && inbuff[i] >= 33 && inbuff[i] <= 126 || inbuff[i] == 13 || inbuff[i] == 10 && (inbuff[i] != 10 || this.m_foundCR) || inbuff[i] == 32 || inbuff[i] == 9)) {
                this.m_lineBuff[this.m_charsInBuff++] = 61;
                this.m_lineBuff[this.m_charsInBuff++] = decimalToHex[(inbuff[i] & 0xF0) >> 4];
                this.m_lineBuff[this.m_charsInBuff++] = decimalToHex[inbuff[i] & 0xF];
            } else {
                this.m_lineBuff[this.m_charsInBuff++] = inbuff[i];
            }
            if (this.m_foundCR) {
                this.m_foundCR = false;
                if (inbuff[i] == 10) {
                    while (this.m_charsInBuff >= 3 && (this.m_lineBuff[this.m_charsInBuff - 3] == 32 || this.m_lineBuff[this.m_charsInBuff - 3] == 9)) {
                        this.m_lineBuff[this.m_charsInBuff - 3] = 13;
                        this.m_lineBuff[this.m_charsInBuff - 2] = 10;
                        --this.m_charsInBuff;
                    }
                    oStream.write(this.m_lineBuff, 0, this.m_charsInBuff);
                    this.m_charsInBuff = 0;
                }
            }
            if (inbuff[i] == 13) {
                this.m_foundCR = true;
            }
            if ((this.m_charsInBuff != 77 || this.m_lineBuff[76] == 13) && this.m_charsInBuff <= 77) continue;
            for (charsToOutput = 75; charsToOutput > 0 && this.m_lineBuff[charsToOutput - 1] != 32 && this.m_lineBuff[charsToOutput - 1] != 9 && this.m_lineBuff[charsToOutput - 1] != 44 && this.m_lineBuff[charsToOutput - 1] != 45 && this.m_lineBuff[charsToOutput - 1] != 46; --charsToOutput) {
            }
            if (charsToOutput == 0) {
                for (charsToOutput = 75; charsToOutput > 1 && (this.m_lineBuff[charsToOutput - 1] == 61 || this.m_lineBuff[charsToOutput - 2] == 61); --charsToOutput) {
                }
            }
            oStream.write(this.m_lineBuff, 0, charsToOutput);
            oStream.write(61);
            oStream.write(13);
            oStream.write(10);
            this.m_charsInBuff -= charsToOutput;
            System.arraycopy(this.m_lineBuff, charsToOutput, this.m_lineBuff, 0, this.m_charsInBuff);
        }
    }
}

